/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.AABB;

public class ArcParticle
extends LevelMatrixStackParticle {
    protected final Vector3f dest;
    protected final float taper;
    protected final int seed;

    private ArcParticle(ClientLevel levelIn, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(levelIn, sx, sy, sz, 0.0, 0.0, 0.0);
        float dx = (float)(ex - sx);
        float dy = (float)(ey - sy);
        float dz = (float)(ez - sz);
        this.f_107221_ = Math.max(Math.abs(dx), Math.abs(dz));
        this.f_107222_ = Math.abs(dy);
        this.m_107259_(new AABB(sx, sy, sz, ex, ey, ez));
        float distSqr = MathHelper.dist(dx, dy, dz);
        if (distSqr < 4.0f) {
            float frac = distSqr * 0.25f;
            this.taper = frac - 1.25f;
            frac = 1.0f / frac;
            this.dest = new Vector3f(dx * frac, dy * frac, dz * frac);
        } else {
            this.taper = 0.0f;
            this.dest = new Vector3f(dx, dy, dz);
        }
        this.f_107225_ = 7 + this.f_107223_.nextInt(3);
        this.seed = this.f_107223_.nextInt();
        this.f_107219_ = false;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, float partialTicks) {
        float progress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        float easeCos = MathHelper.cos(progress * (float)Math.PI * 0.5f);
        VFXHelper.transformVertical(stack, Vector3f.f_176763_, this.dest);
        VFXHelper.renderStraightArcs(stack, buffer, this.m_6355_(packedLightIn), 2, 0.03f * (easeCos * 1.5f - 0.5f), 0.015f, VFXHelper.getSeedWithTime(this.seed, this.f_107224_), (int)(easeCos * 255.0f) | 0xFFFF00, (int)(easeCos * 164.0f) | 0xFFFC5200, Math.min((float)this.f_107224_ * 0.3333f * 1.25f - 1.25f, this.taper));
    }

    public int m_6355_(float pTicks) {
        return 0xF000F0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprite) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
            return new ArcParticle(level, sx, sy, sz, ex, ey, ez);
        }
    }
}

