/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ShieldingTileEntity
extends BlockEntity {
    private BlockPos shieldProjector;
    private BlockState mimic;
    public static final ModelProperty<Integer> ICON_TOPDOWN = new ModelProperty();
    public static final ModelProperty<Integer> ICON_SIDE = new ModelProperty();
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<ShieldRenderData> RENDER_DATA = new ModelProperty();
    private static final ShieldRenderData DEFAULT_RENDER_DATA = new ShieldRenderData(1.0f, 1.0f, 1.0f, 1.0f, ShieldTexture.SHIELD);

    public ShieldingTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ShieldModule.TYPE_SHIELDING.get(), pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTag = new CompoundTag();
        this.m_183515_(nbtTag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> nbtTag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
    }

    public BlockPos getShieldProjector() {
        return this.shieldProjector;
    }

    public void setShieldProjector(BlockPos shieldProjector) {
        this.shieldProjector = shieldProjector;
        this.m_6596_();
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.m_6596_();
    }

    @Nonnull
    public IModelData getModelData() {
        BlockEntity te;
        int x = this.f_58858_.m_123341_();
        int y = this.f_58858_.m_123342_();
        int z = this.f_58858_.m_123343_();
        int topdown = (z & 1) * 2 + (x & 1);
        int side = (y & 1) * 2 + (x + z & 1);
        ShieldRenderData renderData = DEFAULT_RENDER_DATA;
        if (this.shieldProjector != null && (te = this.f_58857_.m_7702_(this.shieldProjector)) instanceof ShieldProjectorTileEntity) {
            ShieldProjectorTileEntity shield = (ShieldProjectorTileEntity)te;
            renderData = shield.getRenderData();
        }
        return new ModelDataMap.Builder().withInitial(ICON_SIDE, (Object)side).withInitial(ICON_TOPDOWN, (Object)topdown).withInitial(MIMIC, (Object)this.mimic).withInitial(RENDER_DATA, (Object)renderData).build();
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.shieldProjector = new BlockPos(tag.m_128451_("sx"), tag.m_128451_("sy"), tag.m_128451_("sz"));
        this.mimic = tag.m_128441_("mimic") ? NbtUtils.m_129241_((CompoundTag)tag.m_128469_("mimic")) : null;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("sx", this.shieldProjector.m_123341_());
        tag.m_128405_("sy", this.shieldProjector.m_123342_());
        tag.m_128405_("sz", this.shieldProjector.m_123343_());
        if (this.mimic != null) {
            CompoundTag camoNbt = NbtUtils.m_129202_((BlockState)this.mimic);
            tag.m_128365_("mimic", (Tag)camoNbt);
        }
    }
}

