/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.GuiMoverController;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class MoverControllerTileEntity
extends GenericTileEntity {
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MoverConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MoverConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Mover").containerSupplier(DefaultContainerProvider.empty(MoverModule.CONTAINER_MOVER_CONTROLLER, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    public static final int MAXSCAN = 128;
    @GuiValue
    public static final Value<?, String> VALUE_SELECTED_VEHICLE = Value.create((String)"selectedVehicle", (Type)Type.STRING, MoverControllerTileEntity::getSelectedVehicle, MoverControllerTileEntity::setSelectedVehicle);
    private String selectedVehicle;
    @GuiValue
    public static final Value<?, Integer> VALUE_OFFSET_X = Value.create((String)"x", (Type)Type.INTEGER, te -> te.offsetX, (te, x) -> te.setOffset((int)x, te.offsetY, te.offsetZ));
    private int offsetX = 1;
    @GuiValue
    public static final Value<?, Integer> VALUE_OFFSET_Y = Value.create((String)"y", (Type)Type.INTEGER, te -> te.offsetY, (te, y) -> te.setOffset(te.offsetX, (int)y, te.offsetZ));
    private int offsetY = 1;
    @GuiValue
    public static final Value<?, Integer> VALUE_OFFSET_Z = Value.create((String)"z", (Type)Type.INTEGER, te -> te.offsetZ, (te, z) -> te.setOffset(te.offsetX, te.offsetY, (int)z));
    private int offsetZ = 1;
    public static final Key<BlockPos> SELECTED_NODE = new Key("node", Type.BLOCKPOS);
    public static final Key<String> SELECTED_VEHICLE = new Key("vehicle", Type.STRING);
    public static final Key<String> SELECTED_DESTINATION = new Key("destination", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.doScan());
    @ServerCommand
    public static final Command<?> CMD_MOVE = Command.create((String)"move", (te, player, params) -> te.startMove((BlockPos)params.get(SELECTED_NODE), (String)params.get(SELECTED_VEHICLE), (String)params.get(SELECTED_DESTINATION)));
    @ServerCommand
    public static final Command<?> CMD_SELECTNODE = Command.create((String)"selectNode", (te, player, params) -> te.selectNode((BlockPos)params.get(SELECTED_NODE)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETVEHICLES = ListCommand.create((String)"rftoolsbuilder.movercontroller.getVehicles", (te, player, params) -> te.getVehicles(), (te, player, params, list) -> GuiMoverController.setVehiclesFromServer(list));
    @ServerCommand(type=Pair.class, serializer=NodePairSerializer.class)
    public static final ListCommand<?, ?> CMD_GETNODES = ListCommand.create((String)"rftoolsbuilder.movercontroller.getNodes", (te, player, params) -> te.getNodes(), (te, player, params, list) -> GuiMoverController.setNodesFromServer(list));

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MoverControllerTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public MoverControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.TYPE_MOVER_CONTROLLER.get(), pos, state);
    }

    private void selectNode(BlockPos pos) {
        MoverTileEntity mover;
        ItemStack card;
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        this.selectedVehicle = blockEntity instanceof MoverTileEntity ? ((card = (mover = (MoverTileEntity)blockEntity).getCard()).m_41619_() ? null : VehicleCard.getVehicleName(card)) : null;
    }

    private void setOffset(int x, int y, int z) {
        if (this.offsetX == x && this.offsetY == y && this.offsetZ == z) {
            return;
        }
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.m_6596_();
        this.traverseDepthFirst((pos, mover) -> {
            mover.setOffset(x, y, z);
            return null;
        });
    }

    public String getSelectedVehicle() {
        return this.selectedVehicle;
    }

    public void setSelectedVehicle(String vehicle) {
        this.selectedVehicle = vehicle;
        if (this.f_58857_.f_46443_) {
            GuiMoverController.setSelectedVehicle(vehicle);
        }
    }

    @Nullable
    public <T> T traverseBreadthFirst(BiFunction<BlockPos, MoverTileEntity, T> function) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.f_58858_.m_142300_(direction);
            BlockEntity blockEntity = this.f_58857_.m_7702_(moverPos);
            if (!(blockEntity instanceof MoverTileEntity)) continue;
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            return mover.traverseBreadthFirst(function);
        }
        return null;
    }

    @Nullable
    private <T> T traverseDepthFirst(BiFunction<BlockPos, MoverTileEntity, T> function) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.f_58858_.m_142300_(direction);
            BlockEntity blockEntity = this.f_58857_.m_7702_(moverPos);
            if (!(blockEntity instanceof MoverTileEntity)) continue;
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            return mover.traverseDepthFirst(function);
        }
        return null;
    }

    public boolean hasEnoughPower() {
        return this.energyStorage.getEnergyStored() >= this.getPowerPerMove();
    }

    private Integer getPowerPerMove() {
        int power = (Integer)MoverConfiguration.RF_PER_MOVE.get();
        power = (int)((float)power * (2.0f - this.infusable.getInfusedFactor()) / 2.0f);
        return power;
    }

    public void setupMovement(String moverName, String vehicle) {
        if (this.energyStorage.getEnergyStored() < this.getPowerPerMove()) {
            return;
        }
        MoverTileEntity destinationMover = this.findMover(moverName);
        if (destinationMover != null) {
            if (vehicle == null || vehicle.trim().isEmpty()) {
                vehicle = this.traverseBreadthFirst((p, mover) -> {
                    ItemStack card = mover.getCard();
                    if (!card.m_41619_()) {
                        return VehicleCard.getVehicleName(card);
                    }
                    return null;
                });
            }
            if (vehicle != null) {
                this.energyStorage.consumeEnergy((long)this.getPowerPerMove().intValue());
                this.startMove(destinationMover.m_58899_(), vehicle, destinationMover.getName());
            }
        }
    }

    private void startMove(BlockPos destination, String vehicle, String destinationName) {
        MoverTileEntity moverContainingVehicle;
        if (vehicle.contains(" -> ")) {
            vehicle = vehicle.substring(0, vehicle.indexOf(" -> "));
        }
        if ((moverContainingVehicle = this.findVehicle(vehicle)) != null) {
            ItemStack card = moverContainingVehicle.getCard();
            VehicleCard.setDesiredDestination(card, destination, destinationName);
        }
    }

    @Nullable
    private MoverTileEntity findMover(String moverName) {
        return this.traverseDepthFirst((p, mover) -> {
            if (Objects.equals(moverName, mover.getName())) {
                return mover;
            }
            return null;
        });
    }

    @Nullable
    public MoverTileEntity findVehicle(String vehicle) {
        return this.traverseDepthFirst((p, mover) -> {
            ItemStack card = mover.getCard();
            String name = VehicleCard.getVehicleName(card);
            if (Objects.equals(name, vehicle)) {
                return mover;
            }
            return null;
        });
    }

    private void doScan() {
        this.m_6596_();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.f_58858_.m_142300_(direction);
            BlockEntity blockEntity = this.f_58857_.m_7702_(moverPos);
            if (!(blockEntity instanceof MoverTileEntity)) continue;
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            HashSet<BlockPos> alreadyHandled = new HashSet<BlockPos>();
            alreadyHandled.add(moverPos);
            this.doScan(moverPos, mover, alreadyHandled);
            return;
        }
    }

    private void doScan(BlockPos moverPos, MoverTileEntity mover, Set<BlockPos> alreadyHandled) {
        mover.clearNetwork();
        mover.setController(this);
        block0: for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!mover.canConnect(direction)) continue;
            for (int distance = 1; distance <= 128; ++distance) {
                BlockPos destPos = moverPos.m_5484_(direction, distance);
                BlockEntity blockEntity = this.f_58857_.m_7702_(destPos);
                if (!(blockEntity instanceof MoverTileEntity)) continue;
                MoverTileEntity destMover = (MoverTileEntity)blockEntity;
                mover.addConnection(direction, destPos);
                if (alreadyHandled.contains(destPos)) continue block0;
                alreadyHandled.add(destPos);
                this.doScan(destPos, destMover, alreadyHandled);
                continue block0;
            }
        }
    }

    public List<String> getMovers() {
        ArrayList<String> movers = new ArrayList<String>();
        this.traverseDepthFirst((p, mover) -> {
            movers.add(mover.getName());
            return null;
        });
        return movers;
    }

    private List<String> getVehicles() {
        ArrayList<String> vehicles = new ArrayList<String>();
        this.traverseDepthFirst((p, mover) -> {
            ItemStack card = mover.getCard();
            if (!card.m_41619_()) {
                Object name = VehicleCard.getVehicleName(card);
                BlockPos destination = VehicleCard.getDesiredDestination(card);
                String destinationName = VehicleCard.getDesiredDestinationName(card);
                if (destination != null) {
                    name = (String)name + " -> " + destinationName;
                }
                vehicles.add((String)name);
            }
            return null;
        });
        return vehicles;
    }

    private List<Pair<BlockPos, String>> getNodes() {
        ArrayList<Pair<BlockPos, String>> nodeNames = new ArrayList<Pair<BlockPos, String>>();
        this.traverseDepthFirst((p, mover) -> {
            Object name = mover.getName();
            if (name == null || ((String)name).trim().isEmpty()) {
                name = p.m_123341_() + "," + p.m_123342_() + "," + p.m_123343_();
            }
            nodeNames.add(Pair.of((Object)p, (Object)name));
            return null;
        });
        return nodeNames;
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        this.getOrCreateInfo(tagCompound).m_128405_("offsetX", this.offsetX);
        this.getOrCreateInfo(tagCompound).m_128405_("offsetY", this.offsetY);
        this.getOrCreateInfo(tagCompound).m_128405_("offsetZ", this.offsetZ);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag info = tagCompound.m_128469_("Info");
            this.offsetX = info.m_128451_("offsetX");
            this.offsetY = info.m_128451_("offsetY");
            this.offsetZ = info.m_128451_("offsetZ");
        } else {
            this.offsetZ = 1;
            this.offsetY = 1;
            this.offsetX = 1;
        }
    }

    public static class NodePairSerializer
    implements ISerializer<Pair<BlockPos, String>> {
        public Function<FriendlyByteBuf, Pair<BlockPos, String>> getDeserializer() {
            return buf -> Pair.of((Object)buf.m_130135_(), (Object)buf.m_130136_(Short.MAX_VALUE));
        }

        public BiConsumer<FriendlyByteBuf, Pair<BlockPos, String>> getSerializer() {
            return (buf, pair) -> {
                buf.m_130064_((BlockPos)pair.getLeft());
                buf.m_130070_((String)pair.getRight());
            };
        }
    }
}

