/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.items;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ShapeCardType {
    CARD_UNKNOWN,
    CARD_SPACE,
    CARD_SHAPE("def", false, false, false, BuilderTileEntity::buildBlock, null, () -> (Integer)BuilderConfiguration.builderRfPerOperation.get(), new String[]{"This item can be configured as a shape. You", "can then use it in the shield projector to make", "a shield of that shape or in the builder to", "actually build the shape"}){

        @Override
        public void addHudLog(List<String> list, IItemHandler inventory) {
            Shape shape;
            list.add("    Shape card");
            ItemStack shapeCard = inventory.getStackInSlot(0);
            if (!shapeCard.m_41619_() && (shape = ShapeCardItem.getShape(shapeCard)) != null) {
                list.add("    " + shape.getDescription());
            }
        }
    }
    ,
    CARD_VOID("void", false, false, false, BuilderTileEntity::voidBlock, "    Void mode", () -> (Integer)BuilderConfiguration.builderRfPerQuarry.get() * (int)((Double)BuilderConfiguration.voidShapeCardFactor.get()).doubleValue(), "This item will cause the builder to void", "all blocks in the configured space."),
    CARD_QUARRY("quarry", true, false, false, BuilderTileEntity::quarryBlock, "    Normal quarry", () -> (Integer)BuilderConfiguration.builderRfPerQuarry.get(), "This item will cause the builder to quarry", "all blocks in the configured space and replace", "them with " + ShapeCardType.getDirtOrCobbleName() + "."),
    CARD_QUARRY_SILK("quarry_silk", true, false, false, BuilderTileEntity::silkQuarryBlock, "    Silktouch quarry", () -> (int)((double)((Integer)BuilderConfiguration.builderRfPerQuarry.get()).intValue() * (Double)BuilderConfiguration.silkquarryShapeCardFactor.get()), "This item will cause the builder to quarry", "all blocks in the configured space and replace", "them with " + ShapeCardType.getDirtOrCobbleName() + ".", "Blocks are harvested with silk touch"),
    CARD_QUARRY_FORTUNE("quarry_fortune", true, false, true, BuilderTileEntity::quarryBlock, "    Fortune quarry", () -> (int)((double)((Integer)BuilderConfiguration.builderRfPerQuarry.get()).intValue() * (Double)BuilderConfiguration.fortunequarryShapeCardFactor.get()), "This item will cause the builder to quarry", "all blocks in the configured space and replace", "them with " + ShapeCardType.getDirtOrCobbleName() + ".", "Blocks are harvested with fortune"),
    CARD_QUARRY_CLEAR("quarry_clear", true, true, false, BuilderTileEntity::quarryBlock, "    Normal quarry", () -> (Integer)BuilderConfiguration.builderRfPerQuarry.get(), "This item will cause the builder to quarry", "all blocks in the configured space"),
    CARD_QUARRY_CLEAR_SILK("quarry_clear_silk", true, true, false, BuilderTileEntity::silkQuarryBlock, "    Silktouch quarry", () -> (int)((double)((Integer)BuilderConfiguration.builderRfPerQuarry.get()).intValue() * (Double)BuilderConfiguration.silkquarryShapeCardFactor.get()), "This item will cause the builder to quarry", "all blocks in the configured space.", "Blocks are harvested with silk touch"),
    CARD_QUARRY_CLEAR_FORTUNE("quarry_clear_fortune", true, true, true, BuilderTileEntity::quarryBlock, "    Fortune quarry", () -> (int)((double)((Integer)BuilderConfiguration.builderRfPerQuarry.get()).intValue() * (Double)BuilderConfiguration.fortunequarryShapeCardFactor.get()), "This item will cause the builder to quarry", "all blocks in the configured space.", "Blocks are harvested with fortune"),
    CARD_PUMP("pump", false, false, false, BuilderTileEntity::pumpBlock, "    Pump", () -> (Integer)BuilderConfiguration.builderRfPerLiquid.get(), "This item will cause the builder to collect", "all liquids in the configured space.", "The liquid will be replaced with " + ShapeCardType.getDirtOrCobbleName() + "."),
    CARD_PUMP_CLEAR("pump_clear", false, true, false, BuilderTileEntity::pumpBlock, "    Pump", () -> (Integer)BuilderConfiguration.builderRfPerLiquid.get(), "This item will cause the builder to collect", "all liquids in the configured space.", "The liquid will be removed from the world"),
    CARD_PUMP_LIQUID("liquid", false, false, false, BuilderTileEntity::placeLiquidBlock, "    Place liquids", () -> (Integer)BuilderConfiguration.builderRfPerLiquid.get(), "This item will cause the builder to place", "liquids from an tank on top/bottom into the world.");

    private final Supplier<Integer> rfNeeded;
    private final ModelResourceLocation modelResourceLocation;
    private final SingleBlockHandler singleBlockHandler;
    private final String hudLogEntry;
    private final boolean quarry;
    private final boolean clearing;
    private final boolean fortune;
    private final List<Component> information;
    private final String resourceSuffix;

    private static String getDirtOrCobbleName() {
        BlockState state = BuilderConfiguration.getQuarryReplace();
        Block block = state.m_60734_();
        Item item = block.m_5456_();
        if (item == Items.f_41852_) {
            return block.m_7705_();
        }
        return new ItemStack((ItemLike)item, 1).m_41786_().getString();
    }

    private ShapeCardType() {
        this(null, false, false, false, BuilderTileEntity::suspend, null, () -> 0, new String[0]);
    }

    private ShapeCardType(String resourceSuffix, boolean quarry, boolean clearing, boolean fortune, SingleBlockHandler singleBlockHandler, String hudLogEntry, Supplier<Integer> rfNeeded, String ... information) {
        this.resourceSuffix = resourceSuffix;
        this.modelResourceLocation = resourceSuffix == null ? null : new ModelResourceLocation("rftoolsbuilder:shape_card_" + resourceSuffix, "inventory");
        this.quarry = quarry;
        this.clearing = clearing;
        this.fortune = fortune;
        this.rfNeeded = rfNeeded;
        this.singleBlockHandler = singleBlockHandler;
        this.hudLogEntry = hudLogEntry;
        this.information = Arrays.stream(information).map(a -> ComponentFactory.literal((String)(ChatFormatting.WHITE.toString() + a))).collect(Collectors.toList());
    }

    public boolean isItem() {
        return this.resourceSuffix != null;
    }

    public String getResourceSuffix() {
        return this.resourceSuffix;
    }

    public boolean isQuarry() {
        return this.quarry;
    }

    public boolean isClearing() {
        return this.clearing;
    }

    public boolean isFortune() {
        return this.fortune;
    }

    public int getRfNeeded() {
        return this.rfNeeded.get();
    }

    public ModelResourceLocation getModelResourceLocation() {
        return this.modelResourceLocation;
    }

    public void addHudLog(List<String> list, IItemHandler inventoryHelper) {
        if (this.hudLogEntry != null) {
            list.add(this.hudLogEntry);
        }
        if (this.isClearing()) {
            list.add("    (clearing)");
        }
    }

    public void addInformation(List<Component> list) {
        list.addAll(this.information);
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension.get() + "x" + Math.min(1024, (Integer)BuilderConfiguration.maxBuilderDimension.get()) + "x" + BuilderConfiguration.maxBuilderDimension.get())));
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Base cost: " + this.rfNeeded.get() + " RF/t per block")));
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + (this == CARD_SHAPE ? "(final cost depends on infusion level)" : "(final cost depends on infusion level and block hardness)"))));
    }

    public boolean handleSingleBlock(BuilderTileEntity te, int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        return this.singleBlockHandler.handleSingleBlock(te, rfNeeded, srcPos, srcState, pickState);
    }

    @FunctionalInterface
    public static interface SingleBlockHandler {
        public boolean handleSingleBlock(BuilderTileEntity var1, int var2, BlockPos var3, BlockState var4, BlockState var5);
    }
}

