/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.LazyList;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NamedEnum;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Sync;
import mcjty.lib.varia.TeleportationTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.client.IHudSupport;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.builder.BlockInformation;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.BuilderTileEntityMode;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.blocks.AnchorMode;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderMode;
import mcjty.rftoolsbuilder.modules.builder.blocks.RotateMode;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.modules.builder.items.SpaceChamberCardItem;
import mcjty.rftoolsbuilder.setup.ClientCommandHandler;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTileEntity
extends TickingTileEntity
implements IHudSupport {
    public static final int SLOT_TAB = 0;
    public static final int SLOT_FILTER = 1;
    public static final ResourceLocation DONT_REMOVE_ME = new ResourceLocation("rftoolsbuilder", "dontremoveme");
    public static final TagKey<Block> DONT_REMOVE_ME_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)DONT_REMOVE_ME);
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof ShapeCardItem || s.m_41720_() instanceof SpaceChamberCardItem).in().out(), 0, 100, 10).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof FilterModuleItem).in().out(), 1, 84, 46).playerSlots(10, 70));
    private String lastError = null;
    private BuilderMode mode = BuilderMode.MODE_COPY;
    @GuiValue
    public static final Value<BuilderTileEntity, String> VALUE_MODE = Value.createEnum((String)"mode", (NamedEnum[])BuilderMode.values(), BuilderTileEntity::getMode, BuilderTileEntity::setMode);
    private RotateMode rotate = RotateMode.ROTATE_0;
    @GuiValue
    public static final Value<BuilderTileEntity, String> VALUE_ROTATE = Value.createEnum((String)"rotate", (NamedEnum[])RotateMode.values(), BuilderTileEntity::getRotate, BuilderTileEntity::setRotate);
    private AnchorMode anchor = AnchorMode.ANCHOR_SW;
    @GuiValue
    public static final Value<BuilderTileEntity, String> VALUE_ANCHOR = Value.createEnum((String)"anchor", (NamedEnum[])AnchorMode.values(), BuilderTileEntity::getAnchor, BuilderTileEntity::setAnchor);
    private static int currentLevel = 0;
    private int scanLocCnt = 0;
    private static Map<BlockPos, Pair<Long, BlockPos>> scanLocClient = new HashMap<BlockPos, Pair<Long, BlockPos>>();
    private int collectCounter = (Integer)BuilderConfiguration.collectTimer.get();
    private int collectXP = 0;
    private boolean boxValid = false;
    private BlockPos minBox = null;
    private BlockPos maxBox = null;
    private BlockPos scan = null;
    private int projDx;
    private int projDy;
    private int projDz;
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private ShapeCardType cardType = ShapeCardType.CARD_UNKNOWN;
    private static ItemStack TOOL_NORMAL;
    private static ItemStack TOOL_SILK;
    private static ItemStack TOOL_FORTUNE;
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    private ChunkPos forcedChunk = null;
    private Map<BlockPos, BlockState> cachedBlocks = null;
    private ChunkPos cachedChunk = null;
    private final Cached<Set<Block>> cachedVoidableBlocks = Cached.of(this::getCachedVoidableBlocks);
    private final LazyList<ItemStack> overflowItems = new LazyList();
    private final FakePlayerGetter harvester = new FakePlayerGetter((GenericTileEntity)this, "rftools_builder");
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = this.createItemHandler();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BuilderConfiguration.BUILDER_MAXENERGY.get()).intValue(), (long)((Integer)BuilderConfiguration.BUILDER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Builder").containerSupplier(DefaultContainerProvider.container(BuilderModule.CONTAINER_BUILDER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).shortListener(Sync.integer(() -> this.scan == null ? -1 : this.scan.m_123342_(), v -> {
        currentLevel = v;
    })).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    @Cap(type=CapType.MODULE)
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.m_41720_() instanceof ShapeCardItem || itemStack.m_41720_() == BuilderModule.SPACE_CHAMBER_CARD.get();
        }
    });
    private boolean supportMode = false;
    @GuiValue
    public static final Value<?, Boolean> VALUE_SUPPORT;
    @GuiValue(name="wait")
    private boolean waitMode = true;
    @GuiValue(name="loop")
    private boolean loopMode = false;
    @GuiValue(name="hilight")
    private boolean hilightMode = false;
    @GuiValue
    private boolean silent = false;
    @GuiValue(name="entities")
    private boolean entityMode = false;
    private static final Random random;
    private final LazyList<ItemStack> couldntHandle1 = new LazyList();
    private final LazyList<ItemStack> couldntHandle2 = new LazyList();
    @ServerCommand
    public static final Command<?> CMD_RESTART;
    @ServerCommand
    public static final ListCommand<?, ?> CMD_GETHUDLOG;

    public BuilderTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuilderModule.TYPE_BUILDER.get(), pos, state);
        this.setRSMode(RedstoneMode.REDSTONE_ONREQUIRED);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(BuilderTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:builder/builder_intro")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public Direction getBlockOrientation() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() == BuilderModule.BUILDER.get()) {
            return OrientationTools.getOrientationHoriz((BlockState)state);
        }
        return null;
    }

    public boolean isBlockAboveAir() {
        return this.f_58857_.m_46859_(this.f_58858_.m_7494_());
    }

    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ChatFormatting.BLUE + "Mode:");
        if (this.isShapeCard()) {
            this.getCardType().addHudLog(list, (IItemHandler)this.items);
        } else {
            list.add("    Space card: " + this.mode.getName().toLowerCase());
        }
        if (this.scan != null) {
            list.add(ChatFormatting.BLUE + "Progress:");
            list.add("    Y level: " + this.scan.m_123342_());
            int minChunkX = this.minBox.m_123341_() >> 4;
            int minChunkZ = this.minBox.m_123343_() >> 4;
            int maxChunkX = this.maxBox.m_123341_() >> 4;
            int maxChunkZ = this.maxBox.m_123343_() >> 4;
            int curX = this.scan.m_123341_() >> 4;
            int curZ = this.scan.m_123343_() >> 4;
            int totChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
            int curChunk = (curZ - minChunkZ) * (maxChunkX - minChunkX) + curX - minChunkX;
            list.add("    Chunk:  " + curChunk + " of " + totChunks);
        }
        if (this.lastError != null && !this.lastError.isEmpty()) {
            String[] errors;
            for (String error : errors = StringUtils.split((String)this.lastError, (String)"\n")) {
                list.add(ChatFormatting.RED + error);
            }
        }
        return list;
    }

    public BlockPos getHudPos() {
        return this.m_58899_();
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    private boolean isShapeCard() {
        return this.items.getStackInSlot(0).m_41720_() instanceof ShapeCardItem;
    }

    private CompoundTag hasCard() {
        return this.items.getStackInSlot(0).m_41783_();
    }

    private void makeSupportBlocksShaped() {
        ItemStack shapeCard = this.items.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.f_58857_, this.m_58899_(), dimension, offset, blocks, (Integer)BuilderConfiguration.maxBuilderDimension.get() * 256 * (Integer)BuilderConfiguration.maxBuilderDimension.get(), false, false, null);
        BlockState state = (BlockState)((SupportBlock)((Object)BuilderModule.SUPPORT.get())).m_49966_().m_61124_(SupportBlock.STATUS, (Comparable)((Object)SupportBlock.SupportStatus.STATUS_OK));
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (!this.f_58857_.m_46859_(p)) continue;
            this.f_58857_.m_7731_(p, state, 2);
        }
    }

    private void makeSupportBlocks() {
        if (this.isShapeCard()) {
            this.makeSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            ResourceKey<Level> dimension = chamberChannel.getDimension();
            ServerLevel world = LevelTools.getLevel((Level)this.f_58857_, dimension);
            if (world == null) {
                return;
            }
            ServerPlayer player = this.harvester.get();
            BlockPos.MutableBlockPos src = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos();
            for (int x = this.minBox.m_123341_(); x <= this.maxBox.m_123341_(); ++x) {
                for (int y = this.minBox.m_123342_(); y <= this.maxBox.m_123342_(); ++y) {
                    for (int z = this.minBox.m_123343_(); z <= this.maxBox.m_123343_(); ++z) {
                        src.m_122178_(x, y, z);
                        this.sourceToDest((BlockPos)src, dest);
                        BlockState srcState = world.m_8055_((BlockPos)src);
                        Block srcBlock = srcState.m_60734_();
                        BlockState dstState = world.m_8055_((BlockPos)dest);
                        Block dstBlock = dstState.m_60734_();
                        SupportBlock.SupportStatus error = SupportBlock.SupportStatus.STATUS_OK;
                        if (this.mode != BuilderMode.MODE_COPY) {
                            BlockEntity srcTileEntity = world.m_7702_((BlockPos)src);
                            BlockEntity dstTileEntity = world.m_7702_((BlockPos)dest);
                            SupportBlock.SupportStatus error1 = this.isMovable((Player)player, (Level)world, (BlockPos)src, srcBlock, srcTileEntity);
                            SupportBlock.SupportStatus error2 = this.isMovable((Player)player, (Level)world, (BlockPos)dest, dstBlock, dstTileEntity);
                            error = SupportBlock.SupportStatus.max(error1, error2);
                        }
                        if (BuilderTileEntity.isEmpty(srcState, srcBlock) && !BuilderTileEntity.isEmpty(dstState, dstBlock)) {
                            world.m_7731_((BlockPos)src, (BlockState)((SupportBlock)((Object)BuilderModule.SUPPORT.get())).m_49966_().m_61124_(SupportBlock.STATUS, (Comparable)((Object)error)), 3);
                        }
                        if (!BuilderTileEntity.isEmpty(dstState, dstBlock) || BuilderTileEntity.isEmpty(srcState, srcBlock)) continue;
                        world.m_7731_((BlockPos)dest, (BlockState)((SupportBlock)((Object)BuilderModule.SUPPORT.get())).m_49966_().m_61124_(SupportBlock.STATUS, (Comparable)((Object)error)), 3);
                    }
                }
            }
        }
    }

    private void clearSupportBlocksShaped() {
        ItemStack shapeCard = this.items.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.f_58857_, this.m_58899_(), dimension, offset, blocks, (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(), false, false, null);
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (this.f_58857_.m_8055_(p).m_60734_() != BuilderModule.SUPPORT.get()) continue;
            this.f_58857_.m_46597_(p, Blocks.f_50016_.m_49966_());
        }
    }

    public void clearSupportBlocks() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.isShapeCard()) {
            this.clearSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            ResourceKey<Level> dimension = chamberChannel.getDimension();
            ServerLevel world = LevelTools.getLevel((Level)this.f_58857_, dimension);
            BlockPos.MutableBlockPos src = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos();
            for (int x = this.minBox.m_123341_(); x <= this.maxBox.m_123341_(); ++x) {
                for (int y = this.minBox.m_123342_(); y <= this.maxBox.m_123342_(); ++y) {
                    for (int z = this.minBox.m_123343_(); z <= this.maxBox.m_123343_(); ++z) {
                        Block srcBlock;
                        src.m_122178_(x, y, z);
                        if (world != null && (srcBlock = world.m_8055_((BlockPos)src).m_60734_()) == BuilderModule.SUPPORT.get()) {
                            world.m_46597_((BlockPos)src, Blocks.f_50016_.m_49966_());
                        }
                        this.sourceToDest((BlockPos)src, dest);
                        Block dstBlock = world.m_8055_((BlockPos)dest).m_60734_();
                        if (dstBlock != BuilderModule.SUPPORT.get()) continue;
                        world.m_46597_((BlockPos)dest, Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    public boolean isHilightMode() {
        return this.hilightMode;
    }

    public void setHilightMode(boolean hilightMode) {
        this.hilightMode = hilightMode;
        this.m_6596_();
    }

    public boolean isWaitMode() {
        return this.waitMode;
    }

    public void setWaitMode(boolean waitMode) {
        this.waitMode = waitMode;
        this.m_6596_();
    }

    private boolean waitOrSkip(String error) {
        if (this.waitMode) {
            this.lastError = error;
        }
        return this.waitMode;
    }

    private boolean skip() {
        this.lastError = null;
        return false;
    }

    private boolean skip(String error) {
        this.lastError = error;
        return false;
    }

    public boolean suspend(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        this.lastError = null;
        return true;
    }

    private boolean suspend(String error) {
        this.lastError = error;
        return true;
    }

    public boolean hasLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
        this.m_6596_();
    }

    public boolean hasEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(boolean entityMode) {
        this.entityMode = entityMode;
        this.m_6596_();
    }

    public boolean hasSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
        if (!this.f_58857_.f_46443_) {
            if (supportMode) {
                this.makeSupportBlocks();
            } else {
                this.clearSupportBlocks();
            }
        }
        this.m_6596_();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.m_6596_();
    }

    public BuilderMode getMode() {
        return this.mode;
    }

    public void setMode(BuilderMode mode) {
        if (mode != this.mode) {
            this.mode = mode;
            if (!this.f_58857_.m_5776_()) {
                this.restartScan();
            }
            this.m_6596_();
        }
    }

    public void resetBox() {
        this.boxValid = false;
    }

    public AnchorMode getAnchor() {
        return this.anchor;
    }

    public void setAnchor(AnchorMode anchor) {
        if (this.supportMode && !this.f_58857_.m_5776_()) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.anchor = anchor;
        if (this.isShapeCard()) {
            ItemStack shapeCard = this.items.getStackInSlot(0);
            BlockPos dimension = ShapeCardItem.getDimension(shapeCard);
            BlockPos minBox = this.positionBox(dimension);
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            BlockPos offset = new BlockPos(minBox.m_123341_() + (int)Math.ceil(dx / 2), minBox.m_123342_() + (int)Math.ceil(dy / 2), minBox.m_123343_() + (int)Math.ceil(dz / 2));
            ShapeCardItem.setOffset(shapeCard, offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
        }
        if (this.supportMode && !this.f_58857_.m_5776_()) {
            this.makeSupportBlocks();
        }
        this.m_6596_();
    }

    private BlockPos positionBox(BlockPos dimension) {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int spanX = dimension.m_123341_();
        int spanY = dimension.m_123342_();
        int spanZ = dimension.m_123343_();
        int x = 0;
        int z = 0;
        int y = -(this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_NW ? spanY - 1 : 0);
        switch (direction) {
            case SOUTH: {
                x = -(this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanX - 1 : 0);
                z = -spanZ;
                break;
            }
            case NORTH: {
                x = 1 - spanX + (this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanX - 1 : 0);
                z = 1;
                break;
            }
            case WEST: {
                x = 1;
                z = -(this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanZ - 1 : 0);
                break;
            }
            case EAST: {
                x = -spanX;
                z = -(this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? 0 : spanZ - 1);
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public RotateMode getRotate() {
        return this.rotate;
    }

    public void setRotate(RotateMode rotate) {
        if (this.supportMode && !this.f_58857_.m_5776_()) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.rotate = rotate;
        if (this.supportMode && !this.f_58857_.m_5776_()) {
            this.makeSupportBlocks();
        }
        this.m_6596_();
    }

    public void setPowerInput(int powered) {
        boolean o = this.isMachineEnabled();
        super.setPowerInput(powered);
        boolean n = this.isMachineEnabled();
        if (o != n && (this.loopMode || n && this.scan == null) && !this.f_58857_.m_5776_()) {
            this.restartScan();
        }
    }

    private void createProjection(SpaceChamberRepository.SpaceChamberChannel chamberChannel) {
        BlockPos minC = this.rotate(chamberChannel.getMinCorner());
        BlockPos maxC = this.rotate(chamberChannel.getMaxCorner());
        BlockPos minCorner = new BlockPos(Math.min(minC.m_123341_(), maxC.m_123341_()), Math.min(minC.m_123342_(), maxC.m_123342_()), Math.min(minC.m_123343_(), maxC.m_123343_()));
        BlockPos maxCorner = new BlockPos(Math.max(minC.m_123341_(), maxC.m_123341_()), Math.max(minC.m_123342_(), maxC.m_123342_()), Math.max(minC.m_123343_(), maxC.m_123343_()));
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        int spanX = maxCorner.m_123341_() - minCorner.m_123341_();
        int spanY = maxCorner.m_123342_() - minCorner.m_123342_();
        int spanZ = maxCorner.m_123343_() - minCorner.m_123343_();
        switch (direction) {
            case SOUTH: {
                this.projDx = xCoord + Direction.NORTH.m_122436_().m_123341_() - minCorner.m_123341_() - (this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanX : 0);
                this.projDz = zCoord + Direction.NORTH.m_122436_().m_123343_() - minCorner.m_123343_() - spanZ;
                break;
            }
            case NORTH: {
                this.projDx = xCoord + Direction.SOUTH.m_122436_().m_123341_() - minCorner.m_123341_() - spanX + (this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanX : 0);
                this.projDz = zCoord + Direction.SOUTH.m_122436_().m_123343_() - minCorner.m_123343_();
                break;
            }
            case WEST: {
                this.projDx = xCoord + Direction.EAST.m_122436_().m_123341_() - minCorner.m_123341_();
                this.projDz = zCoord + Direction.EAST.m_122436_().m_123343_() - minCorner.m_123343_() - (this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanZ : 0);
                break;
            }
            case EAST: {
                this.projDx = xCoord + Direction.WEST.m_122436_().m_123341_() - minCorner.m_123341_() - spanX;
                this.projDz = zCoord + Direction.WEST.m_122436_().m_123343_() - minCorner.m_123343_() - spanZ + (this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_SE ? spanZ : 0);
                break;
            }
        }
        this.projDy = yCoord - minCorner.m_123342_() - (this.anchor == AnchorMode.ANCHOR_NE || this.anchor == AnchorMode.ANCHOR_NW ? spanY : 0);
    }

    private void calculateBox(CompoundTag cardCompound) {
        int channel = cardCompound.m_128451_("channel");
        SpaceChamberRepository repository = SpaceChamberRepository.get(this.f_58857_);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardType.CARD_SPACE;
        this.createProjection(chamberChannel);
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private void checkStateServerShaped() {
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int i = 0;
        while ((float)i < (float)((Integer)BuilderConfiguration.quarryBaseSpeed.get()).intValue() + factor * (float)((Integer)BuilderConfiguration.quarryInfusionSpeedFactor.get()).intValue()) {
            if (this.scan != null) {
                this.handleBlockShaped();
            }
            ++i;
        }
    }

    public void tickServer() {
        if (!this.overflowItems.isEmpty()) {
            this.insertItems(this.overflowItems.extractList());
        }
        if (!this.isMachineEnabled() && this.loopMode) {
            return;
        }
        if (this.scan == null) {
            return;
        }
        if (this.isHilightMode()) {
            this.updateHilight();
        }
        if (this.isShapeCard()) {
            if (!this.isMachineEnabled()) {
                this.chunkUnload();
                return;
            }
            this.checkStateServerShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel == null) {
            this.scan = null;
            this.m_6596_();
            return;
        }
        ResourceKey<Level> dimension = chamberChannel.getDimension();
        ServerLevel world = LevelTools.getLevel((Level)this.f_58857_, dimension);
        if (world == null) {
            return;
        }
        if (this.mode == BuilderMode.MODE_COLLECT) {
            this.collectItems((Level)world);
        } else {
            float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
            int i = 0;
            while ((float)i < 2.0f + factor * 40.0f) {
                if (this.scan != null) {
                    this.handleBlock((Level)world);
                }
                ++i;
            }
        }
    }

    private void updateHilight() {
        --this.scanLocCnt;
        if (this.scanLocCnt <= 0) {
            this.scanLocCnt = 5;
            int x = this.scan.m_123341_();
            int y = this.scan.m_123342_();
            int z = this.scan.m_123343_();
            double sqradius = 900.0;
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                double d2;
                double d1;
                double d0;
                if (!Objects.equals(player.m_20193_().m_46472_(), this.f_58857_.m_46472_()) || !((d0 = (double)x - player.m_20185_()) * d0 + (d1 = (double)y - player.m_20186_()) * d1 + (d2 = (double)z - player.m_20189_()) * d2 < sqradius)) continue;
                RFToolsBuilderMessages.sendToClient((Player)player, "positionToClient", TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.m_58899_()).put(ClientCommandHandler.PARAM_SCAN, (Object)this.scan));
            }
        }
    }

    private void collectItems(Level world) {
        --this.collectCounter;
        if (this.collectCounter > 0) {
            return;
        }
        this.collectCounter = (Integer)BuilderConfiguration.collectTimer.get();
        if (!this.loopMode) {
            this.scan = null;
        }
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        long rf = this.energyStorage.getEnergyStored();
        float area = (this.maxBox.m_123341_() - this.minBox.m_123341_() + 1) * (this.maxBox.m_123342_() - this.minBox.m_123342_() + 1) * (this.maxBox.m_123343_() - this.minBox.m_123343_() + 1);
        float infusedFactor = (4.0f - factor) / 4.0f;
        int rfNeeded = (int)((Double)BuilderConfiguration.collectRFPerTickPerArea.get() * (double)area * (double)infusedFactor) * (Integer)BuilderConfiguration.collectTimer.get();
        if ((long)rfNeeded > rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rfNeeded);
        AABB bb = new AABB((double)this.minBox.m_123341_() - 0.8, (double)this.minBox.m_123342_() - 0.8, (double)this.minBox.m_123343_() - 0.8, (double)this.maxBox.m_123341_() + 0.8, (double)this.maxBox.m_123342_() + 0.8, (double)this.maxBox.m_123343_() + 0.8);
        List items = world.m_45976_(Entity.class, bb);
        for (Entity entity : items) {
            if (!(entity instanceof ItemEntity ? this.collectItem(world, factor, (ItemEntity)entity) : entity instanceof ExperienceOrb && this.collectXP(world, factor, (ExperienceOrb)entity))) continue;
            return;
        }
    }

    private boolean collectXP(Level world, float infusedFactor, ExperienceOrb orb) {
        int xp = orb.m_20801_();
        long rf = this.energyStorage.getEnergyStored();
        int rfNeeded = (int)((Double)BuilderConfiguration.collectRFPerXP.get() * (double)infusedFactor * (double)xp);
        if ((long)rfNeeded > rf) {
            return true;
        }
        this.collectXP += xp;
        int bottles = this.collectXP / 7;
        if (bottles > 0) {
            if (this.insertItem(new ItemStack((ItemLike)Items.f_42612_, bottles)).m_41619_()) {
                this.collectXP %= 7;
                ((ServerLevel)world).removeEntity((Entity)orb);
                this.energyStorage.consumeEnergy((long)rfNeeded);
            } else {
                this.collectXP = 0;
            }
        }
        return false;
    }

    private boolean collectItem(Level world, float infusedFactor, ItemEntity item) {
        ItemStack stack = item.m_32055_();
        Predicate predicate = (Predicate)this.filterCache.get();
        if (predicate != null && !predicate.test(stack)) {
            return false;
        }
        long rf = this.energyStorage.getEnergyStored();
        int rfNeeded = (int)((float)((Integer)BuilderConfiguration.collectRFPerItem.get()).intValue() * infusedFactor) * stack.m_41613_();
        if ((long)rfNeeded > rf) {
            return true;
        }
        this.energyStorage.consumeEnergy((long)rfNeeded);
        ((ServerLevel)world).removeEntity((Entity)item);
        stack = this.insertItem(stack);
        if (!stack.m_41619_()) {
            BlockPos position = item.m_142538_();
            ItemEntity entityItem = new ItemEntity(world, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), stack);
            world.m_7967_((Entity)entityItem);
        }
        return false;
    }

    private void calculateBoxShaped() {
        ItemStack shapeCard = this.items.getStackInSlot(0);
        if (shapeCard.m_41619_()) {
            return;
        }
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
        BlockPos minCorner = ShapeCardItem.getMinCorner(this.m_58899_(), dimension, offset);
        BlockPos maxCorner = ShapeCardItem.getMaxCorner(this.m_58899_(), dimension, offset);
        int minHeight = this.f_58857_.m_141937_();
        int maxHeight = this.f_58857_.m_151558_();
        if (minCorner.m_123342_() < minHeight) {
            minCorner = new BlockPos(minCorner.m_123341_(), minHeight, minCorner.m_123343_());
        } else if (minCorner.m_123342_() > maxHeight) {
            minCorner = new BlockPos(minCorner.m_123341_(), maxHeight, minCorner.m_123343_());
        }
        if (maxCorner.m_123342_() < minHeight) {
            maxCorner = new BlockPos(maxCorner.m_123341_(), minHeight, maxCorner.m_123343_());
        } else if (maxCorner.m_123342_() > maxHeight) {
            maxCorner = new BlockPos(maxCorner.m_123341_(), maxHeight, maxCorner.m_123343_());
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardItem.getType(shapeCard);
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks.clear();
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private SpaceChamberRepository.SpaceChamberChannel calculateBox() {
        CompoundTag tc = this.hasCard();
        if (tc == null) {
            return null;
        }
        int channel = tc.m_128451_("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.get(this.f_58857_);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        this.calculateBox(tc);
        if (!this.boxValid) {
            return null;
        }
        return chamberChannel;
    }

    private Map<BlockPos, BlockState> getCachedBlocks(ChunkPos chunk) {
        if (chunk != null && !chunk.equals((Object)this.cachedChunk) || chunk == null && this.cachedChunk != null) {
            this.cachedBlocks = null;
        }
        if (this.cachedBlocks == null) {
            this.cachedBlocks = new HashMap<BlockPos, BlockState>();
            ItemStack shapeCard = this.items.getStackInSlot(0);
            Shape shape = ShapeCardItem.getShape(shapeCard);
            boolean solid = ShapeCardItem.isSolid(shapeCard);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
            boolean forquarry = !ShapeCardItem.isNormalShapeCard(shapeCard);
            ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.f_58857_, this.m_58899_(), dimension, offset, this.cachedBlocks, (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(), solid, forquarry, chunk);
            this.cachedChunk = chunk;
        }
        return this.cachedBlocks;
    }

    private void handleBlockShaped() {
        for (int i = 0; i < 100; ++i) {
            if (this.scan == null) {
                return;
            }
            Map<BlockPos, BlockState> blocks = this.getCachedBlocks(new ChunkPos(this.scan.m_123341_() >> 4, this.scan.m_123343_() >> 4));
            if (blocks.containsKey(this.scan)) {
                BlockState state = blocks.get(this.scan);
                if (!this.handleSingleBlock(state)) {
                    this.nextLocation();
                }
                return;
            }
            this.nextLocation();
        }
    }

    private ShapeCardType getCardType() {
        if (this.cardType == ShapeCardType.CARD_UNKNOWN) {
            return ShapeCardItem.getType(this.items.getStackInSlot(0));
        }
        return this.cardType;
    }

    private boolean handleSingleBlock(BlockState pickState) {
        float factor;
        Block block;
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos srcPos = this.scan;
        int sx = this.scan.m_123341_();
        int sy = this.scan.m_123342_();
        int sz = this.scan.m_123343_();
        if (!this.chunkLoad(sx, sz)) {
            return this.suspend("Chunk not available!");
        }
        int rfNeeded = this.getCardType().getRfNeeded();
        BlockState state = null;
        if (this.getCardType() != ShapeCardType.CARD_SHAPE && this.getCardType() != ShapeCardType.CARD_PUMP_LIQUID && !BuilderTileEntity.isEmpty(state = this.f_58857_.m_8055_(srcPos), block = state.m_60734_())) {
            float hardness;
            if (BuilderTileEntity.isFluidBlock(block)) {
                hardness = 1.0f;
            } else {
                if (((Set)this.cachedVoidableBlocks.get()).contains(block)) {
                    rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerQuarry.get()).intValue() * (Double)BuilderConfiguration.voidShapeCardFactor.get());
                }
                hardness = state.m_60800_((BlockGetter)this.f_58857_, srcPos);
            }
            rfNeeded *= (int)((hardness + 1.0f) * 2.0f);
        }
        if ((rfNeeded = (int)((float)rfNeeded * (3.0f - (factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue())) / 3.0f)) > this.energyStorage.getMaxEnergyStored()) {
            return this.skip("Block exceeds max power!");
        }
        if (rfNeeded > this.energyStorage.getEnergyStored()) {
            return this.suspend("Not enough power!");
        }
        return this.getCardType().handleSingleBlock(this, rfNeeded, srcPos, state, pickState);
    }

    public boolean buildBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (BuilderTileEntity.isEmptyOrReplacable(this.f_58857_, srcPos)) {
            TakeableItem item = this.createTakeableItem(this.f_58857_, srcPos, pickState);
            ItemStack stack = item.peek();
            if (stack.m_41619_()) {
                return this.waitOrSkip("Cannot find block!\nor missing inventory\non top or below");
            }
            ServerPlayer fakePlayer = this.harvester.get();
            BlockState newState = Tools.placeStackAt((Player)fakePlayer, (ItemStack)stack, (Level)this.f_58857_, (BlockPos)srcPos, (BlockState)pickState);
            if (newState == null) {
                return this.waitOrSkip("Cannot place block!");
            }
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)item.peek())) {
                if (!stack.m_41619_()) {
                    if (!(stack = item.takeAndReplace(stack)).m_41619_() && !(stack = this.insertItem(stack)).m_41619_()) {
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), stack));
                    }
                } else {
                    item.take();
                }
            }
            if (!this.silent) {
                SoundType sound = newState.m_60734_().getSoundType(newState, (LevelReader)this.f_58857_, srcPos, (Entity)fakePlayer);
                this.playPlaceSoundSafe(sound, this.f_58857_, newState, srcPos.m_123341_(), srcPos.m_123342_(), srcPos.m_123343_());
            }
            this.energyStorage.consumeEnergy((long)rfNeeded);
        }
        return this.skip();
    }

    private void playPlaceSoundSafe(SoundType sound, Level world, BlockState state, int x, int y, int z) {
        try {
            SoundTools.playSound((Level)world, (SoundEvent)sound.m_56777_(), (double)x, (double)y, (double)z, (double)1.0, (double)1.0);
        }
        catch (Exception e) {
            Logging.getLogger().error("Error getting soundtype from " + Tools.getId((BlockState)state) + "! Please report to the mod owner!");
        }
    }

    private void playBreakSoundSafe(SoundType sound, Level world, BlockState state, int x, int y, int z) {
        try {
            SoundTools.playSound((Level)world, (SoundEvent)sound.m_56775_(), (double)x, (double)y, (double)z, (double)1.0, (double)1.0);
        }
        catch (Exception e) {
            Logging.getLogger().error("Error getting soundtype from " + Tools.getId((BlockState)state) + "! Please report to the mod owner!");
        }
    }

    private Set<Block> getCachedVoidableBlocks() {
        ItemStack card = this.items.getStackInSlot(0);
        if (!card.m_41619_() && card.m_41720_() instanceof ShapeCardItem) {
            return ShapeCardItem.getVoidedBlocks(card);
        }
        return Collections.emptySet();
    }

    private void clearOrDirtBlock(int rfNeeded, BlockPos spos, BlockState srcState, boolean clear) {
        this.energyStorage.consumeEnergy((long)rfNeeded);
        if (!this.silent) {
            SoundType soundType = srcState.m_60734_().getSoundType(srcState, (LevelReader)this.f_58857_, spos, null);
            this.playBreakSoundSafe(soundType, this.f_58857_, srcState, spos.m_123341_(), spos.m_123342_(), spos.m_123343_());
        }
        if (srcState.m_204336_(DONT_REMOVE_ME_TAG)) {
            return;
        }
        if (clear) {
            this.f_58857_.m_7731_(spos, Blocks.f_50016_.m_49966_(), 2);
        } else {
            this.f_58857_.m_7731_(spos, this.getReplacementBlock(), 2);
        }
    }

    private BlockState getReplacementBlock() {
        return BuilderConfiguration.getQuarryReplace();
    }

    public boolean silkQuarryBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        return this.commonQuarryBlock(true, rfNeeded, srcPos, srcState);
    }

    private Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.items.getStackInSlot(1));
    }

    private boolean allowedToBreak(BlockState state, Level world, BlockPos pos, Player player) {
        if (!state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, (Entity)player)) {
            return this.skip("Cannot destroy!\nAre fake players\nallowed?");
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return this.skip("Break was canceled!");
        }
        return true;
    }

    private static boolean allowedToBreakS(BlockState state, Level world, BlockPos pos, Player player) {
        if (!state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, (Entity)player)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public boolean quarryBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        return this.commonQuarryBlock(false, rfNeeded, srcPos, srcState);
    }

    private static ItemStack getHarvesterTool(boolean silk, int fortune) {
        if (silk) {
            if (TOOL_SILK == null || TOOL_SILK.m_41619_()) {
                TOOL_SILK = new ItemStack((ItemLike)BuilderModule.SUPER_HARVESTING_TOOL.get());
                TOOL_SILK.m_41663_(Enchantments.f_44985_, 1);
            }
            return TOOL_SILK;
        }
        if (fortune > 0) {
            if (TOOL_FORTUNE == null || TOOL_FORTUNE.m_41619_()) {
                TOOL_FORTUNE = new ItemStack((ItemLike)BuilderModule.SUPER_HARVESTING_TOOL.get());
                TOOL_FORTUNE.m_41663_(Enchantments.f_44987_, fortune);
            }
            return TOOL_FORTUNE;
        }
        if (TOOL_NORMAL == null || TOOL_NORMAL.m_41619_()) {
            TOOL_NORMAL = new ItemStack((ItemLike)BuilderModule.SUPER_HARVESTING_TOOL.get());
        }
        return TOOL_NORMAL;
    }

    private boolean commonQuarryBlock(boolean silk, int rfNeeded, BlockPos srcPos, BlockState srcState) {
        Block block = srcState.m_60734_();
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        int sx = srcPos.m_123341_();
        int sy = srcPos.m_123342_();
        int sz = srcPos.m_123343_();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        if (BuilderTileEntity.isEmpty(srcState, block)) {
            return this.skip();
        }
        if (srcState.m_60800_((BlockGetter)this.f_58857_, srcPos) >= 0.0f) {
            boolean clear = this.getCardType().isClearing();
            if (!clear && srcState == this.getReplacementBlock()) {
                return this.skip();
            }
            if (!((Boolean)BuilderConfiguration.quarryTileEntities.get()).booleanValue() && this.f_58857_.m_7702_(srcPos) != null) {
                return this.skip();
            }
            ServerPlayer fakePlayer = this.harvester.get();
            if (this.allowedToBreak(srcState, this.f_58857_, srcPos, (Player)fakePlayer)) {
                ItemStack filter = this.items.getStackInSlot(1);
                if (!filter.m_41619_() && this.filterCache.get() != null) {
                    boolean match;
                    try {
                        match = ((Predicate)this.filterCache.get()).test(block.m_7397_((BlockGetter)this.f_58857_, srcPos, srcState));
                    }
                    catch (Exception e) {
                        match = false;
                    }
                    if (!match) {
                        this.energyStorage.consumeEnergy((long)Math.min(rfNeeded, (Integer)BuilderConfiguration.builderRfPerSkipped.get()));
                        return this.skip();
                    }
                }
                if (!((Set)this.cachedVoidableBlocks.get()).contains(block)) {
                    List drops;
                    if (!this.overflowItems.isEmpty()) {
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                    int fortune = this.getCardType().isFortune() ? 3 : 0;
                    LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78977_(this.f_58857_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)srcPos.m_123341_(), (double)srcPos.m_123342_(), (double)srcPos.m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)BuilderTileEntity.getHarvesterTool(silk, fortune)).m_78972_(LootContextParams.f_81455_, (Object)fakePlayer).m_78984_(LootContextParams.f_81462_, (Object)this.f_58857_.m_7702_(srcPos));
                    if (fortune > 0) {
                        builder.m_78963_((float)fortune);
                    }
                    if (this.checkValidItems(block, drops = srcState.m_60724_(builder)) && !this.insertItems(drops)) {
                        this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                }
                this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
            } else {
                return this.waitOrSkip(this.lastError);
            }
        }
        return false;
    }

    private static boolean isFluidBlock(Block block) {
        return block instanceof LiquidBlock;
    }

    private static int getFluidLevel(BlockState srcState) {
        if (srcState.m_60734_() instanceof LiquidBlock) {
            return (Integer)srcState.m_61143_((Property)LiquidBlock.f_54688_);
        }
        return -1;
    }

    public boolean placeLiquidBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.f_58857_, srcPos)) {
            FluidStack stack = this.consumeLiquid(this.f_58857_, srcPos);
            if (stack.isEmpty()) {
                return this.waitOrSkip("Cannot find liquid!\nor no usable tank\nabove or below");
            }
            Fluid fluid = stack.getFluid();
            if (fluid.getAttributes().doesVaporize((BlockAndTintGetter)this.f_58857_, srcPos, stack) && this.f_58857_.m_6042_().m_63951_()) {
                fluid.getAttributes().vaporize(null, this.f_58857_, srcPos, stack);
            } else {
                Block block = fluid.m_76145_().m_76188_().m_60734_();
                ServerPlayer fakePlayer = this.harvester.get();
                this.f_58857_.m_7731_(srcPos, block.m_49966_(), 11);
                if (!this.silent) {
                    SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)this.f_58857_, srcPos, (Entity)fakePlayer);
                    this.playPlaceSoundSafe(soundType, this.f_58857_, block.m_49966_(), srcPos.m_123341_(), srcPos.m_123342_(), srcPos.m_123343_());
                }
            }
            this.energyStorage.consumeEnergy((long)rfNeeded);
        }
        return this.skip();
    }

    public boolean pumpBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        Block block = srcState.m_60734_();
        FluidState fluidState = this.f_58857_.m_6425_(srcPos);
        if (fluidState.m_76178_()) {
            return this.skip();
        }
        if (!fluidState.m_76170_()) {
            return this.skip();
        }
        FluidStack fluidStack = FluidTools.pickupFluidBlock((Level)this.f_58857_, (BlockPos)srcPos, s -> false, () -> {});
        if (fluidStack.isEmpty()) {
            return this.skip();
        }
        if (srcState.m_60800_((BlockGetter)this.f_58857_, srcPos) >= 0.0f) {
            ServerPlayer fakePlayer = this.harvester.get();
            if (this.allowedToBreak(srcState, this.f_58857_, srcPos, (Player)fakePlayer)) {
                if (this.checkAndInsertFluids(fluidStack)) {
                    this.energyStorage.consumeEnergy((long)rfNeeded);
                    boolean clear = this.getCardType().isClearing();
                    FluidTools.pickupFluidBlock((Level)this.f_58857_, (BlockPos)srcPos, s -> true, () -> {
                        if (clear) {
                            this.f_58857_.m_7731_(srcPos, Blocks.f_50016_.m_49966_(), 2);
                        } else {
                            this.f_58857_.m_7731_(srcPos, this.getReplacementBlock(), 2);
                        }
                    });
                    if (!this.silent) {
                        SoundType soundType = block.getSoundType(srcState, (LevelReader)this.f_58857_, srcPos, (Entity)fakePlayer);
                        this.playBreakSoundSafe(soundType, this.f_58857_, srcState, srcPos.m_123341_(), srcPos.m_123342_(), srcPos.m_123343_());
                    }
                    return this.skip();
                }
                return this.waitOrSkip("No room for liquid\nor no usable tank\nabove or below!");
            }
            return this.waitOrSkip(this.lastError);
        }
        return this.skip();
    }

    public boolean voidBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        Block block = srcState.m_60734_();
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        int sx = srcPos.m_123341_();
        int sy = srcPos.m_123342_();
        int sz = srcPos.m_123343_();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        ServerPlayer fakePlayer = this.harvester.get();
        if (this.allowedToBreak(srcState, this.f_58857_, srcPos, (Player)fakePlayer)) {
            assert (this.f_58857_ != null);
            if (srcState.m_60800_((BlockGetter)this.f_58857_, srcPos) >= 0.0f) {
                boolean match;
                ItemStack filter = this.items.getStackInSlot(1);
                if (!filter.m_41619_() && this.filterCache.get() != null && !(match = ((Predicate)this.filterCache.get()).test(block.m_7397_((BlockGetter)this.f_58857_, srcPos, srcState)))) {
                    this.energyStorage.consumeEnergy((long)Math.min(rfNeeded, (Integer)BuilderConfiguration.builderRfPerSkipped.get()));
                    return this.skip();
                }
                if (!this.silent) {
                    SoundType soundType = block.getSoundType(srcState, (LevelReader)this.f_58857_, srcPos, (Entity)fakePlayer);
                    this.playBreakSoundSafe(soundType, this.f_58857_, srcState, sx, sy, sz);
                }
                this.f_58857_.m_46597_(srcPos, Blocks.f_50016_.m_49966_());
                this.energyStorage.consumeEnergy((long)rfNeeded);
            }
        } else {
            return this.waitOrSkip(this.lastError);
        }
        return this.skip();
    }

    private void handleBlock(Level world) {
        BlockPos srcPos = this.scan;
        BlockPos destPos = this.sourceToDest(this.scan);
        int x = this.scan.m_123341_();
        int y = this.scan.m_123342_();
        int z = this.scan.m_123343_();
        int destX = destPos.m_123341_();
        int destY = destPos.m_123342_();
        int destZ = destPos.m_123343_();
        switch (this.mode) {
            case MODE_COPY: {
                this.copyBlock(world, srcPos, world, destPos);
                break;
            }
            case MODE_MOVE: {
                if (this.entityMode) {
                    this.moveEntities(world, x, y, z, world, destX, destY, destZ);
                }
                this.moveBlock(world, srcPos, world, destPos, this.rotate);
                break;
            }
            case MODE_BACK: {
                if (this.entityMode) {
                    this.moveEntities(world, destX, destY, destZ, world, x, y, z);
                }
                this.moveBlock(world, destPos, world, srcPos, this.oppositeRotate());
                break;
            }
            case MODE_SWAP: {
                if (this.entityMode) {
                    this.swapEntities(world, x, y, z, world, destX, destY, destZ);
                }
                this.swapBlock(world, srcPos, world, destPos);
            }
        }
        this.nextLocation();
    }

    private TakeableItem findBlockTakeableItem(IItemHandler inventory, Level srcWorld, BlockPos srcPos, BlockState state) {
        if (state == null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (!this.isPlacable(inventory.getStackInSlot(i))) continue;
                slots.add(i);
            }
            if (!slots.isEmpty()) {
                return new TakeableItem(inventory, (Integer)slots.get(random.nextInt(slots.size())));
            }
        } else {
            Block block = state.m_60734_();
            ItemStack srcItem = block.m_7397_((BlockGetter)srcWorld, srcPos, state);
            if (this.isPlacable(srcItem)) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.m_41619_() || !stack.m_41656_(srcItem)) continue;
                    return new TakeableItem(inventory, i);
                }
            }
        }
        return TakeableItem.EMPTY;
    }

    private boolean isPlacable(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return item instanceof BlockItem || item instanceof IPlantable;
    }

    private boolean checkValidItems(Block block, List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (stack.m_41619_() || stack.m_41720_() != null) continue;
            Logging.logError((String)("Builder tried to quarry " + Tools.getId((Block)block).toString() + " and it returned null item!"));
            Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)("Builder tried to quarry " + Tools.getId((Block)block).toString() + " and it returned null item!\nPlease report to mod author!"), (float)10.0f);
            return false;
        }
        return true;
    }

    private boolean checkAndInsertFluids(FluidStack fluid) {
        if (this.checkFluidTank(fluid, this.m_58899_().m_7494_(), Direction.DOWN)) {
            return true;
        }
        return this.checkFluidTank(fluid, this.m_58899_().m_7495_(), Direction.UP);
    }

    private boolean checkFluidTank(FluidStack fluidStack, BlockPos up, Direction side) {
        BlockEntity te = this.f_58857_.m_7702_(up);
        if (te != null) {
            return te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).map(h -> {
                int amount = h.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                if (amount == 1000) {
                    h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private void handleItemInsertion(@Nullable BlockEntity te, Direction direction, List<ItemStack> items, LazyList<ItemStack> couldntHandle) {
        if (te == null) {
            couldntHandle.copyList(items);
            return;
        }
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
        if (!capability.isPresent()) {
            couldntHandle.copyList(items);
            return;
        }
        couldntHandle.clear();
        te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(h -> {
            for (ItemStack item : items) {
                ItemStack overflow = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)item, (boolean)false);
                if (overflow.m_41619_()) continue;
                couldntHandle.add((Object)overflow);
            }
        });
    }

    private boolean insertItems(List<ItemStack> items) {
        this.handleItemInsertion(this.f_58857_.m_7702_(this.f_58858_.m_7494_()), Direction.DOWN, items, this.couldntHandle1);
        if (this.couldntHandle1.isEmpty()) {
            return true;
        }
        this.handleItemInsertion(this.f_58857_.m_7702_(this.f_58858_.m_7495_()), Direction.UP, this.couldntHandle1.getList(), this.couldntHandle2);
        if (this.couldntHandle2.isEmpty()) {
            return true;
        }
        this.overflowItems.copyList(this.couldntHandle2.getList());
        return false;
    }

    private ItemStack insertItem(@Nonnull ItemStack s) {
        s = InventoryTools.insertItem((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Direction)Direction.UP, (ItemStack)s);
        if (!s.m_41619_()) {
            s = InventoryTools.insertItem((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Direction)Direction.DOWN, (ItemStack)s);
        }
        return s;
    }

    private TakeableItem createTakeableItem(Direction direction, Level srcWorld, BlockPos srcPos, BlockState state) {
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction));
        if (te != null) {
            return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).map(h -> this.findBlockTakeableItem((IItemHandler)h, srcWorld, srcPos, state)).orElse(TakeableItem.EMPTY);
        }
        return TakeableItem.EMPTY;
    }

    @Nonnull
    private FluidStack consumeLiquid(Level srcWorld, BlockPos srcPos) {
        FluidStack b = this.consumeLiquid(Direction.UP, srcWorld, srcPos);
        if (b.isEmpty()) {
            b = this.consumeLiquid(Direction.DOWN, srcWorld, srcPos);
        }
        return b;
    }

    @Nonnull
    private FluidStack consumeLiquid(Direction direction, Level srcWorld, BlockPos srcPos) {
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction));
        if (te != null) {
            LazyOptional fluid = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_());
            if (!fluid.isPresent()) {
                fluid = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            }
            if (fluid.isPresent()) {
                return fluid.map(h -> this.findAndConsumeLiquid((IFluidHandler)h, srcWorld, srcPos)).orElse(FluidStack.EMPTY);
            }
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    private FluidStack findAndConsumeLiquid(IFluidHandler tank, Level srcWorld, BlockPos srcPos) {
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack contents = tank.getFluidInTank(i);
            if (contents.isEmpty() || contents.getFluid() == null || contents.getAmount() < 1000) continue;
            return tank.drain(new FluidStack(contents.getFluid(), 1000, contents.getTag()), IFluidHandler.FluidAction.EXECUTE);
        }
        return FluidStack.EMPTY;
    }

    private TakeableItem createTakeableItem(Level srcWorld, BlockPos srcPos, BlockState state) {
        TakeableItem b = this.createTakeableItem(Direction.UP, srcWorld, srcPos, state);
        if (b.peek().m_41619_()) {
            b = this.createTakeableItem(Direction.DOWN, srcWorld, srcPos, state);
        }
        return b;
    }

    public static BlockInformation getBlockInformation(Player fakePlayer, Level world, BlockPos pos, Block block, BlockEntity tileEntity) {
        BlockState state = world.m_8055_(pos);
        if (BuilderTileEntity.isEmpty(state, block)) {
            return BlockInformation.FREE;
        }
        if (!BuilderTileEntity.allowedToBreakS(state, world, pos, fakePlayer)) {
            return BlockInformation.INVALID;
        }
        BlockInformation blockInformation = BlockInformation.getBlockInformation(block);
        if (tileEntity != null) {
            switch ((BuilderTileEntityMode)((Object)BuilderConfiguration.teMode.get())) {
                case MOVE_FORBIDDEN: {
                    return BlockInformation.INVALID;
                }
                case MOVE_WHITELIST: {
                    if (blockInformation != null && blockInformation.getBlockLevel() != SupportBlock.SupportStatus.STATUS_ERROR) break;
                    return BlockInformation.INVALID;
                }
                case MOVE_BLACKLIST: {
                    if (blockInformation == null || blockInformation.getBlockLevel() != SupportBlock.SupportStatus.STATUS_ERROR) break;
                    return BlockInformation.INVALID;
                }
            }
        }
        if (blockInformation != null) {
            return blockInformation;
        }
        return BlockInformation.OK;
    }

    private SupportBlock.SupportStatus isMovable(Player harvester, Level world, BlockPos pos, Block block, BlockEntity tileEntity) {
        return BuilderTileEntity.getBlockInformation(harvester, world, pos, block, tileEntity).getBlockLevel();
    }

    public static boolean isEmptyOrReplacable(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60767_().m_76336_()) {
            return true;
        }
        return BuilderTileEntity.isEmpty(state, block);
    }

    public static boolean isEmpty(BlockState state, Block block) {
        if (block == null) {
            return true;
        }
        if (state.m_60767_() == Material.f_76296_) {
            return true;
        }
        return block == BuilderModule.SUPPORT.get();
    }

    private void clearBlock(Level world, BlockPos pos) {
        if (this.supportMode) {
            world.m_7731_(pos, ((SupportBlock)((Object)BuilderModule.SUPPORT.get())).m_49966_(), 3);
        } else {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private RotateMode oppositeRotate() {
        return switch (this.rotate) {
            case RotateMode.ROTATE_90 -> RotateMode.ROTATE_270;
            case RotateMode.ROTATE_270 -> RotateMode.ROTATE_90;
            default -> this.rotate;
        };
    }

    private void copyBlock(Level srcWorld, BlockPos srcPos, Level destWorld, BlockPos destPos) {
        long rf = this.energyStorage.getEnergy();
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * (double)(4.0f - factor) / 4.0);
        if ((long)rfNeeded > rf) {
            return;
        }
        if (BuilderTileEntity.isEmptyOrReplacable(destWorld, destPos)) {
            if (srcWorld.m_46859_(srcPos)) {
                return;
            }
            BlockState srcState = srcWorld.m_8055_(srcPos);
            TakeableItem takeableItem = this.createTakeableItem(srcWorld, srcPos, srcState);
            ItemStack consumedStack = takeableItem.peek();
            if (consumedStack.m_41619_()) {
                return;
            }
            ServerPlayer fakePlayer = this.harvester.get();
            BlockState newState = Tools.placeStackAt((Player)fakePlayer, (ItemStack)consumedStack, (Level)destWorld, (BlockPos)destPos, (BlockState)srcState);
            if (newState == null) {
                return;
            }
            if (!destWorld.m_8055_(destPos).m_60795_()) {
                destWorld.m_7731_(destPos, newState, 3);
            }
            if (!ItemStack.m_41728_((ItemStack)consumedStack, (ItemStack)takeableItem.peek())) {
                if (!consumedStack.m_41619_()) {
                    if (!(consumedStack = takeableItem.takeAndReplace(consumedStack)).m_41619_() && !(consumedStack = this.insertItem(consumedStack)).m_41619_()) {
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), consumedStack));
                    }
                } else {
                    takeableItem.take();
                }
            }
            if (!this.silent) {
                SoundType soundType = newState.m_60734_().getSoundType(newState, (LevelReader)destWorld, destPos, (Entity)fakePlayer);
                this.playPlaceSoundSafe(soundType, destWorld, newState, destPos.m_123341_(), destPos.m_123342_(), destPos.m_123343_());
            }
            this.energyStorage.consumeEnergy((long)rfNeeded);
        }
    }

    private double getDimensionCostFactor(Level world, Level destWorld) {
        return Objects.equals(destWorld.m_46472_(), world.m_46472_()) ? 1.0 : (Double)BuilderConfiguration.dimensionCostFactor.get();
    }

    private boolean consumeEntityEnergy(int rfNeeded, int rfNeededPlayer, Entity entity) {
        long rf;
        int rfn = entity instanceof Player ? rfNeededPlayer : rfNeeded;
        if ((long)rfn > (rf = this.energyStorage.getEnergy())) {
            return true;
        }
        this.energyStorage.consumeEnergy((long)rfn);
        return false;
    }

    private void moveEntities(Level world, int x, int y, int z, Level destWorld, int destX, int destY, int destZ) {
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        int rfNeededPlayer = (int)((double)((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        List entities = world.m_45933_(null, new AABB((double)x - 0.1, (double)y - 0.1, (double)z - 0.1, (double)x + 1.1, (double)y + 1.1, (double)z + 1.1));
        for (Entity entity : entities) {
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            double newX = (double)destX + (entity.m_20185_() - (double)x);
            double newY = (double)destY + (entity.m_20186_() - (double)y);
            double newZ = (double)destZ + (entity.m_20189_() - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
    }

    private void swapEntities(Level world, int x, int y, int z, Level destWorld, int destX, int destY, int destZ) {
        double newZ;
        double newY;
        double newX;
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        int rfNeededPlayer = (int)((double)((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        List entitiesSrc = world.m_45933_(null, new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        List entitiesDst = destWorld.m_45933_(null, new AABB((double)destX, (double)destY, (double)destZ, (double)(destX + 1), (double)(destY + 1), (double)(destZ + 1)));
        for (Entity entity : entitiesSrc) {
            if (!this.isEntityInBlock(x, y, z, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)destX + (entity.m_20185_() - (double)x);
            newY = (double)destY + (entity.m_20186_() - (double)y);
            newZ = (double)destZ + (entity.m_20189_() - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
        for (Entity entity : entitiesDst) {
            if (!this.isEntityInBlock(destX, destY, destZ, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)x + (entity.m_20185_() - (double)destX);
            newY = (double)y + (entity.m_20186_() - (double)destY);
            newZ = (double)z + (entity.m_20189_() - (double)destZ);
            this.teleportEntity(destWorld, world, entity, newX, newY, newZ);
        }
    }

    private void teleportEntity(Level world, Level destWorld, Entity entity, double newX, double newY, double newZ) {
        TeleportationTools.teleportEntity((Entity)entity, (Level)destWorld, (double)newX, (double)newY, (double)newZ, null);
    }

    private boolean isEntityInBlock(int x, int y, int z, Entity entity) {
        return entity.m_20185_() >= (double)x && entity.m_20185_() < (double)(x + 1) && entity.m_20186_() >= (double)y && entity.m_20186_() < (double)(y + 1) && entity.m_20189_() >= (double)z && entity.m_20189_() < (double)(z + 1);
    }

    private void moveBlock(Level srcWorld, BlockPos srcPos, Level destWorld, BlockPos destPos, RotateMode rotMode) {
        Block oldDestBlock;
        BlockState oldDestState = destWorld.m_8055_(destPos);
        if (BuilderTileEntity.isEmpty(oldDestState, oldDestBlock = oldDestState.m_60734_())) {
            Block srcBlock;
            BlockState srcState = srcWorld.m_8055_(srcPos);
            if (BuilderTileEntity.isEmpty(srcState, srcBlock = srcState.m_60734_())) {
                return;
            }
            BlockEntity srcTileEntity = srcWorld.m_7702_(srcPos);
            BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((Player)this.harvester.get(), srcWorld, srcPos, srcBlock, srcTileEntity);
            if (srcInformation.getBlockLevel() == SupportBlock.SupportStatus.STATUS_ERROR) {
                return;
            }
            long rf = this.energyStorage.getEnergy();
            float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
            int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - factor) / 4.0);
            if ((long)rfNeeded > rf) {
                return;
            }
            this.energyStorage.consumeEnergy((long)rfNeeded);
            CompoundTag tc = null;
            if (srcTileEntity != null) {
                tc = srcTileEntity.m_187482_();
                srcWorld.m_46747_(srcPos);
            }
            this.clearBlock(srcWorld, srcPos);
            destWorld.m_7731_(destPos, srcState, 3);
            if (srcTileEntity != null) {
                this.setTileEntityNBT(destWorld, tc, destPos, srcState);
            }
            if (!this.silent) {
                SoundType srcSoundType = srcBlock.getSoundType(srcState, (LevelReader)srcWorld, srcPos, null);
                this.playBreakSoundSafe(srcSoundType, srcWorld, srcState, srcPos.m_123341_(), srcPos.m_123342_(), srcPos.m_123343_());
                SoundType dstSoundtype = srcBlock.getSoundType(srcState, (LevelReader)destWorld, destPos, null);
                this.playPlaceSoundSafe(dstSoundtype, destWorld, srcState, destPos.m_123341_(), destPos.m_123342_(), destPos.m_123343_());
            }
        }
    }

    private void setTileEntityNBT(Level destWorld, CompoundTag tc, BlockPos destpos, BlockState newDestState) {
        tc.m_128405_("x", destpos.m_123341_());
        tc.m_128405_("y", destpos.m_123342_());
        tc.m_128405_("z", destpos.m_123343_());
        BlockEntity tileEntity = BlockEntity.m_155241_((BlockPos)destpos, (BlockState)newDestState, (CompoundTag)tc);
        if (tileEntity != null) {
            destWorld.m_46865_(destpos).m_142169_(tileEntity);
            tileEntity.m_6596_();
            destWorld.m_7260_(destpos, newDestState, newDestState, 3);
        }
    }

    private void swapBlock(Level srcWorld, BlockPos srcPos, Level destWorld, BlockPos dstPos) {
        BlockState oldSrcState = srcWorld.m_8055_(srcPos);
        Block srcBlock = oldSrcState.m_60734_();
        BlockEntity srcTileEntity = srcWorld.m_7702_(srcPos);
        BlockState oldDstState = destWorld.m_8055_(dstPos);
        Block dstBlock = oldDstState.m_60734_();
        BlockEntity dstTileEntity = destWorld.m_7702_(dstPos);
        if (BuilderTileEntity.isEmpty(oldSrcState, srcBlock) && BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
            return;
        }
        BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((Player)this.harvester.get(), srcWorld, srcPos, srcBlock, srcTileEntity);
        if (srcInformation.getBlockLevel() == SupportBlock.SupportStatus.STATUS_ERROR) {
            return;
        }
        BlockInformation dstInformation = BuilderTileEntity.getBlockInformation((Player)this.harvester.get(), destWorld, dstPos, dstBlock, dstTileEntity);
        if (dstInformation.getBlockLevel() == SupportBlock.SupportStatus.STATUS_ERROR) {
            return;
        }
        long rf = this.energyStorage.getEnergy();
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - factor) / 4.0);
        if ((long)(rfNeeded += (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * dstInformation.getCostFactor() * (double)(4.0f - factor) / 4.0)) > rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rfNeeded);
        srcWorld.m_46747_(srcPos);
        srcWorld.m_46597_(srcPos, Blocks.f_50016_.m_49966_());
        destWorld.m_46747_(dstPos);
        destWorld.m_46597_(dstPos, Blocks.f_50016_.m_49966_());
        BlockState newDstState = oldSrcState;
        destWorld.m_7731_(dstPos, newDstState, 3);
        if (srcTileEntity != null) {
            srcTileEntity.m_6339_();
            destWorld.m_151523_(srcTileEntity);
            srcTileEntity.m_6596_();
            destWorld.m_7260_(dstPos, newDstState, newDstState, 3);
        }
        BlockState newSrcState = oldDstState;
        srcWorld.m_7731_(srcPos, newSrcState, 3);
        if (dstTileEntity != null) {
            dstTileEntity.m_6339_();
            srcWorld.m_151523_(dstTileEntity);
            dstTileEntity.m_6596_();
            srcWorld.m_7260_(srcPos, newSrcState, newSrcState, 3);
        }
        if (!this.silent) {
            SoundType dstSoundType;
            SoundType srcSoundType;
            if (!BuilderTileEntity.isEmpty(oldSrcState, srcBlock)) {
                srcSoundType = srcBlock.getSoundType(oldSrcState, (LevelReader)srcWorld, srcPos, null);
                this.playBreakSoundSafe(srcSoundType, srcWorld, oldSrcState, srcPos.m_123341_(), srcPos.m_123342_(), srcPos.m_123343_());
                dstSoundType = srcBlock.getSoundType(oldSrcState, (LevelReader)destWorld, dstPos, null);
                this.playPlaceSoundSafe(dstSoundType, destWorld, oldSrcState, dstPos.m_123341_(), dstPos.m_123342_(), dstPos.m_123343_());
            }
            if (!BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
                srcSoundType = dstBlock.getSoundType(oldDstState, (LevelReader)destWorld, dstPos, null);
                this.playBreakSoundSafe(srcSoundType, destWorld, oldDstState, dstPos.m_123341_(), dstPos.m_123342_(), dstPos.m_123343_());
                dstSoundType = dstBlock.getSoundType(oldDstState, (LevelReader)srcWorld, srcPos, null);
                this.playPlaceSoundSafe(dstSoundType, srcWorld, oldDstState, srcPos.m_123341_(), srcPos.m_123342_(), srcPos.m_123343_());
            }
        }
    }

    private BlockPos sourceToDest(BlockPos source) {
        return this.rotate(source).m_142082_(this.projDx, this.projDy, this.projDz);
    }

    private BlockPos rotate(BlockPos c) {
        switch (this.rotate) {
            case ROTATE_0: {
                return c;
            }
            case ROTATE_90: {
                return new BlockPos(-c.m_123343_(), c.m_123342_(), c.m_123341_());
            }
            case ROTATE_180: {
                return new BlockPos(-c.m_123341_(), c.m_123342_(), -c.m_123343_());
            }
            case ROTATE_270: {
                return new BlockPos(c.m_123343_(), c.m_123342_(), -c.m_123341_());
            }
        }
        return c;
    }

    private void sourceToDest(BlockPos source, BlockPos.MutableBlockPos dest) {
        this.rotate(source, dest);
        dest.m_122178_(dest.m_123341_() + this.projDx, dest.m_123342_() + this.projDy, dest.m_123343_() + this.projDz);
    }

    private void rotate(BlockPos c, BlockPos.MutableBlockPos dest) {
        switch (this.rotate) {
            case ROTATE_0: {
                dest.m_122190_((Vec3i)c);
                break;
            }
            case ROTATE_90: {
                dest.m_122178_(-c.m_123343_(), c.m_123342_(), c.m_123341_());
                break;
            }
            case ROTATE_180: {
                dest.m_122178_(-c.m_123341_(), c.m_123342_(), -c.m_123343_());
                break;
            }
            case ROTATE_270: {
                dest.m_122178_(c.m_123343_(), c.m_123342_(), -c.m_123341_());
            }
        }
    }

    private void restartScan() {
        this.lastError = null;
        this.chunkUnload();
        if (this.loopMode || this.isMachineEnabled() && this.scan == null) {
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.calculateBox();
                this.scan = this.minBox;
            } else if (this.getCardType() != ShapeCardType.CARD_UNKNOWN) {
                this.calculateBoxShaped();
                this.scan = new BlockPos(this.minBox.m_123341_(), this.maxBox.m_123342_(), this.minBox.m_123343_());
            }
            this.cachedBlocks = null;
            this.cachedChunk = null;
            this.cachedVoidableBlocks.clear();
        } else {
            this.scan = null;
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.chunkUnload();
    }

    private void chunkUnload() {
        if (this.forcedChunk != null) {
            if (this.getOwnerUUID() != null) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"rftoolsbuilder", (UUID)this.getOwnerUUID(), (int)this.forcedChunk.f_45578_, (int)this.forcedChunk.f_45579_, (boolean)false, (boolean)false);
            }
            this.forcedChunk = null;
        }
    }

    private boolean chunkLoad(int x, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        if (LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)new BlockPos(x, 0, z))) {
            return true;
        }
        if (((Boolean)BuilderConfiguration.quarryChunkloads.get()).booleanValue()) {
            ChunkPos pair = new ChunkPos(cx, cz);
            if (pair.equals((Object)this.forcedChunk)) {
                return true;
            }
            if (this.forcedChunk != null && this.getOwnerUUID() != null) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"rftoolsbuilder", (UUID)this.getOwnerUUID(), (int)this.forcedChunk.f_45578_, (int)this.forcedChunk.f_45579_, (boolean)false, (boolean)false);
            }
            this.forcedChunk = pair;
            if (this.getOwnerUUID() != null) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"rftoolsbuilder", (UUID)this.getOwnerUUID(), (int)this.forcedChunk.f_45578_, (int)this.forcedChunk.f_45579_, (boolean)true, (boolean)false);
            }
            return true;
        }
        return false;
    }

    public static void setScanLocationClient(BlockPos tePos, BlockPos scanPos) {
        scanLocClient.put(tePos, (Pair<Long, BlockPos>)Pair.of((Object)System.currentTimeMillis(), (Object)scanPos));
    }

    public static Map<BlockPos, Pair<Long, BlockPos>> getScanLocClient() {
        if (scanLocClient.isEmpty()) {
            return scanLocClient;
        }
        HashMap<BlockPos, Pair<Long, BlockPos>> scans = new HashMap<BlockPos, Pair<Long, BlockPos>>();
        long time = System.currentTimeMillis();
        for (Map.Entry<BlockPos, Pair<Long, BlockPos>> entry : scanLocClient.entrySet()) {
            if ((Long)entry.getValue().getKey() + 10000L <= time) continue;
            scans.put(entry.getKey(), entry.getValue());
        }
        scanLocClient = scans;
        return scanLocClient;
    }

    private void nextLocation() {
        if (this.scan != null) {
            int x = this.scan.m_123341_();
            int y = this.scan.m_123342_();
            int z = this.scan.m_123343_();
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.nextLocationNormal(x, y, z);
            } else {
                this.nextLocationQuarry(x, y, z);
            }
        }
    }

    private void nextLocationQuarry(int x, int y, int z) {
        if (x >= this.maxBox.m_123341_() || (x + 1) % 16 == 0) {
            if (z >= this.maxBox.m_123343_() || (z + 1) % 16 == 0) {
                if (y <= this.minBox.m_123342_()) {
                    if (x < this.maxBox.m_123341_()) {
                        z = z >> 4 << 4;
                        y = this.maxBox.m_123342_();
                        this.scan = new BlockPos(++x, y, z);
                    } else if (z < this.maxBox.m_123343_()) {
                        x = this.minBox.m_123341_();
                        y = this.maxBox.m_123342_();
                        this.scan = new BlockPos(x, y, ++z);
                    } else {
                        this.restartScan();
                    }
                } else {
                    this.scan = new BlockPos(x >> 4 << 4, y - 1, z >> 4 << 4);
                }
            } else {
                this.scan = new BlockPos(x >> 4 << 4, y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void nextLocationNormal(int x, int y, int z) {
        if (x >= this.maxBox.m_123341_()) {
            if (z >= this.maxBox.m_123343_()) {
                if (y >= this.maxBox.m_123342_()) {
                    if (this.mode != BuilderMode.MODE_SWAP || this.isShapeCard()) {
                        this.restartScan();
                    } else {
                        this.scan = null;
                    }
                } else {
                    this.scan = new BlockPos(this.minBox.m_123341_(), y + 1, this.minBox.m_123343_());
                }
            } else {
                this.scan = new BlockPos(this.minBox.m_123341_(), y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void refreshSettings() {
        this.clearSupportBlocks();
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks.clear();
        this.boxValid = false;
        this.scan = null;
        this.cardType = ShapeCardType.CARD_UNKNOWN;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        if (tagCompound.m_128441_("overflowItems")) {
            ListTag overflowItemsNbt = tagCompound.m_128437_("overflowItems", 10);
            this.overflowItems.clear();
            for (Tag overflowNbt : overflowItemsNbt) {
                this.overflowItems.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)overflowNbt)));
            }
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        if (!info.m_128441_("rsMode")) {
            this.rsMode = RedstoneMode.REDSTONE_ONREQUIRED;
        }
        this.lastError = info.m_128441_("lastError") ? info.m_128461_("lastError") : null;
        if (info.m_128441_("mode")) {
            this.mode = BuilderMode.values()[info.m_128451_("mode")];
        }
        if (info.m_128441_("anchor")) {
            this.anchor = AnchorMode.values()[info.m_128451_("anchor")];
        }
        if (info.m_128441_("rotate")) {
            this.rotate = RotateMode.values()[info.m_128451_("rotate")];
        }
        this.silent = info.m_128471_("silent");
        this.supportMode = info.m_128471_("support");
        this.entityMode = info.m_128471_("entityMode");
        this.loopMode = info.m_128471_("loopMode");
        this.waitMode = info.m_128441_("waitMode") ? info.m_128471_("waitMode") : true;
        this.hilightMode = info.m_128471_("hilightMode");
        this.scan = BlockPosTools.read((CompoundTag)info, (String)"scan");
        this.minBox = BlockPosTools.read((CompoundTag)info, (String)"minBox");
        this.maxBox = BlockPosTools.read((CompoundTag)info, (String)"maxBox");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        if (!this.overflowItems.isEmpty()) {
            ListTag overflowItemsNbt = new ListTag();
            for (ItemStack overflow : this.overflowItems.getList()) {
                overflowItemsNbt.add((Object)overflow.m_41739_(new CompoundTag()));
            }
            tagCompound.m_128365_("overflowItems", (Tag)overflowItemsNbt);
        }
        if (this.lastError != null) {
            tagCompound.m_128359_("lastError", this.lastError);
        }
        tagCompound.m_128405_("mode", this.mode.ordinal());
        tagCompound.m_128405_("anchor", this.anchor.ordinal());
        tagCompound.m_128405_("rotate", this.rotate.ordinal());
        tagCompound.m_128379_("silent", this.silent);
        tagCompound.m_128379_("support", this.supportMode);
        tagCompound.m_128379_("entityMode", this.entityMode);
        tagCompound.m_128379_("loopMode", this.loopMode);
        tagCompound.m_128379_("waitMode", this.waitMode);
        tagCompound.m_128379_("hilightMode", this.hilightMode);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"maxBox", (BlockPos)this.maxBox);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        if (this.lastError != null) {
            infoTag.m_128359_("lastError", this.lastError);
        }
        infoTag.m_128405_("mode", this.mode.ordinal());
        infoTag.m_128405_("anchor", this.anchor.ordinal());
        infoTag.m_128405_("rotate", this.rotate.ordinal());
        infoTag.m_128379_("silent", this.silent);
        infoTag.m_128379_("support", this.supportMode);
        infoTag.m_128379_("entityMode", this.entityMode);
        infoTag.m_128379_("loopMode", this.loopMode);
        infoTag.m_128379_("waitMode", this.waitMode);
        infoTag.m_128379_("hilightMode", this.hilightMode);
        BlockPosTools.write((CompoundTag)infoTag, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.write((CompoundTag)infoTag, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.write((CompoundTag)infoTag, (String)"maxBox", (BlockPos)this.maxBox);
    }

    public static int getCurrentLevelClientSide() {
        return currentLevel;
    }

    public int getCurrentLevel() {
        return this.scan == null ? -1 : this.scan.m_123342_();
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.m_60734_() == newstate.m_60734_()) {
            return;
        }
        if (this.hasSupportMode()) {
            this.clearSupportBlocks();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 2, 1));
    }

    public void rotateBlock(Rotation axis) {
        super.rotateBlock(axis);
        if (!this.f_58857_.f_46443_ && this.hasSupportMode()) {
            this.clearSupportBlocks();
            this.resetBox();
        }
    }

    private GenericItemHandler createItemHandler() {
        return new GenericItemHandler((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get()){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                this.checkShapeCard(slot, stack);
                return super.insertItem(slot, stack, simulate);
            }

            public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
                this.checkShapeCard(index, stack);
                super.setInventorySlotContents(stackLimit, index, stack);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                this.checkShapeCard(slot, ItemStack.f_41583_);
                return super.extractItem(slot, amount, simulate);
            }

            public ItemStack decrStackSize(int index, int amount) {
                this.checkShapeCard(index, ItemStack.f_41583_);
                return super.decrStackSize(index, amount);
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                this.checkShapeCard(slot, stack);
                super.setStackInSlot(slot, stack);
            }

            protected void onUpdate(int index, ItemStack stack) {
                super.onUpdate(index, stack);
                if (index == 1) {
                    BuilderTileEntity.this.filterCache.clear();
                }
            }

            private void checkShapeCard(int index, ItemStack newStack) {
                ItemStack stack = this.getStackInSlot(index);
                if (index == 0 && (stack.m_41619_() && !newStack.m_41619_() || !stack.m_41619_() && newStack.m_41619_())) {
                    BuilderTileEntity.this.refreshSettings();
                }
            }
        };
    }

    static {
        VALUE_SUPPORT = Value.create((String)"support", (Type)Type.BOOLEAN, BuilderTileEntity::hasSupportMode, BuilderTileEntity::setSupportMode);
        random = new Random();
        CMD_RESTART = Command.create((String)"restart", (te, player, params) -> te.restartScan());
        CMD_GETHUDLOG = ListCommand.create((String)"getHudLog", (te, player, params) -> te.getHudLog(), (te, player, params, list) -> {
            te.clientHudLog = list;
        });
    }

    private static class TakeableItem {
        private final IItemHandler itemHandler;
        private final int slot;
        private final ItemStack peekStack;
        public static final TakeableItem EMPTY = new TakeableItem();

        private TakeableItem() {
            this.itemHandler = null;
            this.slot = -1;
            this.peekStack = ItemStack.f_41583_;
        }

        public TakeableItem(IItemHandler itemHandler, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(itemHandler.getSlots() - 1), (long)slot);
            this.itemHandler = itemHandler;
            this.slot = slot;
            this.peekStack = itemHandler.extractItem(slot, 1, true);
        }

        public ItemStack peek() {
            return this.peekStack.m_41777_();
        }

        public void take() {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
            }
        }

        public ItemStack takeAndReplace(ItemStack replacement) {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
                return this.itemHandler.insertItem(this.slot, replacement, false);
            }
            return replacement;
        }
    }
}

