/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierSerializerRegistry;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ObjectModifierProvider<T, S, D>
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final String modId;
    private final DataGenerator dataGenerator;
    private final String name;
    private final String directory;
    private final Gson gson;
    private final ObjectModifierSerializerRegistry<T, S, D> serializerRegistry;
    private final Function<ObjectModifierGroup<T, S, D>, S> additionalSerializationGetter;
    private final List<EntryBuilder<T, S, D>> entries = new ArrayList<EntryBuilder<T, S, D>>();

    public ObjectModifierProvider(DataGenerator dataGenerator, String modId, boolean data, String subDirectory, Gson gson, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, Function<ObjectModifierGroup<T, S, D>, S> additionalSerializationGetter) {
        this.dataGenerator = dataGenerator;
        this.modId = modId;
        this.name = "Object Modifiers (" + subDirectory + "): " + modId;
        this.directory = (data ? "data/" : "assets/") + modId + "/modifiers/" + subDirectory + "/";
        this.gson = gson;
        this.serializerRegistry = serializerRegistry;
        this.additionalSerializationGetter = additionalSerializationGetter;
    }

    public ObjectModifierProvider(DataGenerator dataGenerator, String modId, boolean data, String subDirectory, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, S additionalSerializationObject) {
        this(dataGenerator, modId, data, subDirectory, DEFAULT_GSON, serializerRegistry, group -> additionalSerializationObject);
    }

    public void m_6865_(HashCache directoryCache) {
        HashSet entryNames = Sets.newHashSet();
        Path outputFolder = this.dataGenerator.m_123916_();
        Gson gson = this.gson;
        Function<ObjectModifierGroup<T, S, D>, S> additionalSerializationGetter = this.additionalSerializationGetter;
        ObjectModifierSerializerRegistry<T, S, D> serializerRegistry = this.serializerRegistry;
        List<EntryBuilder<EntryBuilder, S, D>> entries = this.entries;
        entries.clear();
        this.registerEntries();
        entries.forEach(entry -> {
            if (!entryNames.add(entry.name)) {
                throw new IllegalStateException("Duplicate modifier group: " + entry.name);
            }
            Path resolvedPath = outputFolder.resolve(this.directory + entry.name + ".json");
            try {
                ObjectModifierGroup group = new ObjectModifierGroup(entry.selector, entry.modifiers, entry.priority);
                DataProvider.m_123920_((Gson)gson, (HashCache)directoryCache, (JsonElement)group.serialize(additionalSerializationGetter.apply(group), serializerRegistry, (ICondition[][])entry.conditions.toArray((T[])new ICondition[0][])), (Path)resolvedPath);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save modifier group {}", (Object)resolvedPath, (Object)e);
            }
        });
    }

    protected abstract void registerEntries();

    protected EntryBuilder<T, S, D> entry(String name) {
        EntryBuilder entryBuilder = new EntryBuilder(name);
        this.entries.add(entryBuilder);
        return entryBuilder;
    }

    public String m_6055_() {
        return this.name;
    }

    public static final class EntryBuilder<T, S, D> {
        private final String name;
        private final LinkedList<ObjectModifier<T, S, D, ?>> modifiers = new LinkedList();
        private final ArrayList<ICondition[]> conditions = new ArrayList();
        private ConditionedResourceSelector selector = ConditionedResourceSelector.EMPTY;
        private EventPriority priority = EventPriority.NORMAL;

        public EntryBuilder(String name) {
            this.name = name;
        }

        public EntryBuilder<T, S, D> selector(ConditionedResourceSelector selector) {
            this.selector = selector;
            return this;
        }

        public EntryBuilder<T, S, D> selector(ResourceSelector<?> selector) {
            return this.selector(new ConditionedResourceSelector(selector));
        }

        public EntryBuilder<T, S, D> selects(ResourceLocation ... names) {
            return this.selector(new NamesResourceSelector(names));
        }

        public EntryBuilder<T, S, D> selects(String ... names) {
            return this.selector(new NamesResourceSelector(names));
        }

        public EntryBuilder<T, S, D> addModifier(ObjectModifier<T, S, D, ?> modifier, ICondition ... conditions) {
            this.modifiers.add(modifier);
            this.conditions.add(conditions);
            return this;
        }

        public EntryBuilder<T, S, D> priority(EventPriority priority) {
            this.priority = priority;
            return this;
        }
    }
}

