/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.item;

import com.teamabnormals.blueprint.common.entity.BlueprintBoat;
import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlueprintBoatItem
extends Item {
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> Items.f_42746_);
    private static final Predicate<Entity> COLLISION_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final String type;

    public BlueprintBoatItem(String type, Item.Properties properties) {
        super(properties);
        this.type = type;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new DispenserBoatBehavior(type));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem(this, group, items);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult hitResult = BlueprintBoatItem.m_41435_((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        Vec3 vec3d = playerIn.m_20252_(1.0f);
        List list = level.m_6249_((Entity)playerIn, playerIn.m_142469_().m_82369_(vec3d.m_82490_(5.0)).m_82400_(1.0), COLLISION_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = playerIn.m_20299_(1.0f);
            for (Entity entity : list) {
                AABB aabb = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec3d1)) continue;
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlueprintBoat boat = new BlueprintBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
            boat.setBoat(this.type);
            boat.m_146922_(playerIn.m_146908_());
            if (!level.m_45756_((Entity)boat, boat.m_142469_().m_82400_(-0.1))) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boat);
            }
            if (!playerIn.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    static class DispenserBoatBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
        private final String type;

        public DispenserBoatBehavior(String type) {
            this.type = type;
        }

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double adjustY;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double x = source.m_7096_() + (double)((float)direction.m_122429_() * 1.125f);
            double y = source.m_7098_() + (double)((float)direction.m_122430_() * 1.125f);
            double z = source.m_7094_() + (double)((float)direction.m_122431_() * 1.125f);
            BlockPos pos = source.m_7961_().m_142300_(direction);
            if (level.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                adjustY = 1.0;
            } else {
                if (!level.m_8055_(pos).m_60795_() || !level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(source, stack);
                }
                adjustY = 0.0;
            }
            BlueprintBoat boat = new BlueprintBoat((Level)level, x, y + adjustY, z);
            boat.setBoat(this.type);
            boat.m_146922_(direction.m_122435_());
            level.m_7967_((Entity)boat);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    }
}

