/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class MyrmexWorldData
extends SavedData {
    private static final String IDENTIFIER = "iceandfire_myrmex";
    private final List<BlockPos> villagerPositionsList = Lists.newArrayList();
    private final List<MyrmexHive> hiveList = Lists.newArrayList();
    private Level world;
    private int tickCounter;

    public MyrmexWorldData() {
    }

    public MyrmexWorldData(Level world) {
        this.world = world;
        this.m_77762_();
    }

    public MyrmexWorldData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public static MyrmexWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_142572_().m_129880_(world.m_46472_());
            DimensionDataStorage storage = overworld.m_8895_();
            MyrmexWorldData data = (MyrmexWorldData)storage.m_164861_(MyrmexWorldData::new, MyrmexWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.m_77762_();
            }
            return data;
        }
        return new MyrmexWorldData();
    }

    public static void addHive(Level world, MyrmexHive hive) {
        MyrmexWorldData.get((Level)world).hiveList.add(hive);
    }

    public void setWorldsForAll(Level worldIn) {
        this.world = worldIn;
        for (MyrmexHive village : this.hiveList) {
            village.setWorld(worldIn);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (MyrmexHive hive : this.hiveList) {
            hive.tick(this.tickCounter, this.world);
        }
    }

    private void removeAnnihilatedHives() {
        Iterator<MyrmexHive> iterator = this.hiveList.iterator();
        while (iterator.hasNext()) {
            MyrmexHive village = iterator.next();
            if (!village.isAnnihilated()) continue;
            iterator.remove();
            this.m_77762_();
        }
    }

    public List<MyrmexHive> getHivelist() {
        return this.hiveList;
    }

    public MyrmexHive getNearestHive(BlockPos doorBlock, int radius) {
        MyrmexHive village = null;
        double d0 = 3.4028234663852886E38;
        for (MyrmexHive village1 : this.hiveList) {
            float f;
            double d1 = village1.getCenter().m_123331_((Vec3i)doorBlock);
            if (!(d1 < d0) || !(d1 <= (double)((f = (float)(radius + village1.getVillageRadius())) * f))) continue;
            village = village1;
            d0 = d1;
        }
        return village;
    }

    private boolean positionInList(BlockPos pos) {
        for (BlockPos blockpos : this.villagerPositionsList) {
            if (!blockpos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public void debug() {
        for (MyrmexHive hive : this.hiveList) {
            IceAndFire.LOGGER.warn(hive.toString());
        }
    }

    public void load(CompoundTag nbt) {
        this.tickCounter = nbt.m_128451_("Tick");
        ListTag nbttaglist = nbt.m_128437_("Hives", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
            MyrmexHive village = new MyrmexHive();
            village.readVillageDataFromNBT(CompoundNBT);
            this.hiveList.add(village);
        }
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("Tick", this.tickCounter);
        ListTag nbttaglist = new ListTag();
        for (MyrmexHive village : this.hiveList) {
            CompoundTag CompoundNBT = new CompoundTag();
            village.writeVillageDataToNBT(CompoundNBT);
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.m_128365_("Hives", (Tag)nbttaglist);
        return compound;
    }

    public MyrmexHive getHiveFromUUID(UUID id) {
        for (MyrmexHive hive : this.hiveList) {
            if (hive.hiveUUID == null || !hive.hiveUUID.equals(id)) continue;
            return hive;
        }
        return null;
    }
}

