/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemDragonHorn
extends Item {
    public ItemDragonHorn() {
        super(new Item.Properties().m_41491_(IceAndFire.TAB_ITEMS).m_41487_(1));
    }

    public static int getDragonType(ItemStack stack) {
        String id;
        if (stack.m_41783_() != null && EntityType.m_20632_((String)(id = stack.m_41783_().m_128461_("DragonHornEntityID"))).isPresent()) {
            EntityType entityType = (EntityType)EntityType.m_20632_((String)id).get();
            if (entityType == IafEntityRegistry.FIRE_DRAGON.get()) {
                return 1;
            }
            if (entityType == IafEntityRegistry.ICE_DRAGON.get()) {
                return 2;
            }
            if (entityType == IafEntityRegistry.LIGHTNING_DRAGON.get()) {
                return 3;
            }
        }
        return 0;
    }

    public void m_7836_(ItemStack itemStack, @NotNull Level world, @NotNull Player player) {
        itemStack.m_41751_(new CompoundTag());
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, Player playerIn, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        ItemStack trueStack = playerIn.m_21120_(hand);
        if (!playerIn.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND && target instanceof EntityDragonBase && ((EntityDragonBase)target).m_21830_((LivingEntity)playerIn) && (trueStack.m_41783_() == null || trueStack.m_41783_() != null && trueStack.m_41783_().m_128469_("EntityTag").m_128456_())) {
            CompoundTag newTag = new CompoundTag();
            CompoundTag entityTag = new CompoundTag();
            target.m_20223_(entityTag);
            newTag.m_128365_("EntityTag", (Tag)entityTag);
            newTag.m_128359_("DragonHornEntityID", Registry.f_122826_.m_7981_((Object)target.m_6095_()).toString());
            trueStack.m_41751_(newTag);
            playerIn.m_6674_(hand);
            playerIn.f_19853_.m_5594_(playerIn, playerIn.m_142538_(), SoundEvents.f_12616_, SoundSource.NEUTRAL, 3.0f, 0.75f);
            target.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43719_() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (stack.m_41783_() != null && !stack.m_41783_().m_128461_("DragonHornEntityID").isEmpty()) {
            Level world = context.m_43725_();
            String id = stack.m_41783_().m_128461_("DragonHornEntityID");
            EntityType type = EntityType.m_20632_((String)id).orElse(null);
            if (type != null) {
                Entity entity = type.m_20615_(world);
                if (entity instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)entity;
                    dragon.m_20258_(stack.m_41783_().m_128469_("EntityTag"));
                }
                if (stack.m_41783_().m_128441_("EntityUUID")) {
                    entity.m_20084_(stack.m_41783_().m_128342_("EntityUUID"));
                }
                entity.m_19890_((double)context.m_8083_().m_123341_() + 0.5, (double)(context.m_8083_().m_123342_() + 1), (double)context.m_8083_().m_123343_() + 0.5, 180.0f + context.m_8125_().m_122435_(), 0.0f);
                if (world.m_7967_(entity)) {
                    CompoundTag tag = stack.m_41783_();
                    tag.m_128473_("DragonHornEntityID");
                    tag.m_128473_("EntityTag");
                    tag.m_128473_("EntityUUID");
                    stack.m_41751_(tag);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        String id;
        CompoundTag entityTag;
        if (stack.m_41783_() != null && !(entityTag = stack.m_41783_().m_128469_("EntityTag")).m_128456_() && EntityType.m_20632_((String)(id = stack.m_41783_().m_128461_("DragonHornEntityID"))).isPresent()) {
            MutableComponent component;
            EntityType type = (EntityType)EntityType.m_20632_((String)id).get();
            tooltip.add((Component)new TranslatableComponent(type.m_20675_()).m_130940_(this.getTextColorForEntityType(type)));
            String name = new TranslatableComponent("dragon.unnamed").getString();
            if (!entityTag.m_128461_("CustomName").isEmpty() && (component = Component.Serializer.m_130701_((String)entityTag.m_128461_("CustomName"))) != null) {
                name = component.getString();
            }
            tooltip.add((Component)new TextComponent(name).m_130940_(ChatFormatting.GRAY));
            String gender = new TranslatableComponent("dragon.gender").getString() + " " + new TranslatableComponent(entityTag.m_128471_("Gender") ? "dragon.gender.male" : "dragon.gender.female").getString();
            tooltip.add((Component)new TextComponent(gender).m_130940_(ChatFormatting.GRAY));
            int stagenumber = entityTag.m_128451_("AgeTicks") / 24000;
            int stage1 = 0;
            stage1 = stagenumber >= 100 ? 5 : (stagenumber >= 75 ? 4 : (stagenumber >= 50 ? 3 : (stagenumber >= 25 ? 2 : 1)));
            String stage = new TranslatableComponent("dragon.stage").getString() + " " + stage1 + " " + new TranslatableComponent("dragon.days.front").getString() + stagenumber + " " + new TranslatableComponent("dragon.days.back").getString();
            tooltip.add((Component)new TextComponent(stage).m_130940_(ChatFormatting.GRAY));
        }
    }

    private ChatFormatting getTextColorForEntityType(EntityType type) {
        if (type == IafEntityRegistry.FIRE_DRAGON.get()) {
            return ChatFormatting.DARK_RED;
        }
        if (type == IafEntityRegistry.ICE_DRAGON.get()) {
            return ChatFormatting.BLUE;
        }
        if (type == IafEntityRegistry.LIGHTNING_DRAGON.get()) {
            return ChatFormatting.DARK_PURPLE;
        }
        return ChatFormatting.GRAY;
    }
}

