/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.alexthe666.iceandfire.item.DragonSteelTier;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public interface DragonSteelOverrides<T extends TieredItem> {
    @Deprecated
    public Multimap<Attribute, AttributeModifier> bakeDragonsteel();

    default public float getAttackDamage(T item) {
        if (item instanceof SwordItem) {
            return ((SwordItem)item).m_43299_();
        }
        if (item instanceof DiggerItem) {
            return ((DiggerItem)item).m_41008_();
        }
        return item.m_43314_().m_6631_();
    }

    default public boolean isDragonsteel(Tier tier) {
        return tier.getTag() == DragonSteelTier.DRAGONSTEEL_TIER_TAG;
    }

    default public boolean isDragonsteelFire(Tier tier) {
        return tier == DragonSteelTier.DRAGONSTEEL_TIER_FIRE;
    }

    default public boolean isDragonsteelIce(Tier tier) {
        return tier == DragonSteelTier.DRAGONSTEEL_TIER_ICE;
    }

    default public boolean isDragonsteelLightning(Tier tier) {
        return tier == DragonSteelTier.DRAGONSTEEL_TIER_LIGHTNING;
    }

    default public void hurtEnemy(T item, ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (item.m_43314_() == IafItemRegistry.SILVER_TOOL_MATERIAL && target.m_6336_() == MobType.f_21641_) {
            target.m_6469_(DamageSource.f_19319_, this.getAttackDamage(item) + 3.0f);
        }
        if (item.m_43314_() == IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL) {
            if (target.m_6336_() != MobType.f_21642_) {
                target.m_6469_(DamageSource.f_19318_, this.getAttackDamage(item) + 5.0f);
            }
            if (target instanceof EntityDeathWorm) {
                target.m_6469_(DamageSource.f_19318_, this.getAttackDamage(item) + 5.0f);
            }
        }
        if (this.isDragonsteelFire(item.m_43314_()) && IafConfig.dragonWeaponFireAbility) {
            target.m_20254_(15);
            target.m_147240_(1.0, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
        }
        if (this.isDragonsteelIce(item.m_43314_()) && IafConfig.dragonWeaponIceAbility) {
            FrozenProperties.setFrozenFor(target, 300);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 2));
            target.m_147240_(1.0, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
        }
        if (this.isDragonsteelLightning(item.m_43314_()) && IafConfig.dragonWeaponLightningAbility) {
            boolean flag = true;
            if (attacker instanceof Player && (double)attacker.f_20921_ > 0.2) {
                flag = false;
            }
            if (!attacker.f_19853_.f_46443_ && flag) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(target.f_19853_);
                lightningboltentity.m_20219_(target.m_20182_());
                if (!target.f_19853_.f_46443_) {
                    target.f_19853_.m_7967_((Entity)lightningboltentity);
                }
            }
            target.m_147240_(1.0, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
        }
    }

    default public void appendHoverText(Tier tier, ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (tier == IafItemRegistry.SILVER_TOOL_MATERIAL) {
            tooltip.add((Component)new TranslatableComponent("silvertools.hurt").m_130940_(ChatFormatting.GREEN));
        }
        if (tier == IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL) {
            tooltip.add((Component)new TranslatableComponent("myrmextools.hurt").m_130940_(ChatFormatting.GREEN));
        }
        if (this.isDragonsteelFire(tier) && IafConfig.dragonWeaponFireAbility) {
            tooltip.add((Component)new TranslatableComponent("dragon_sword_fire.hurt2").m_130940_(ChatFormatting.DARK_RED));
        }
        if (this.isDragonsteelIce(tier) && IafConfig.dragonWeaponIceAbility) {
            tooltip.add((Component)new TranslatableComponent("dragon_sword_ice.hurt2").m_130940_(ChatFormatting.AQUA));
        }
        if (this.isDragonsteelLightning(tier) && IafConfig.dragonWeaponLightningAbility) {
            tooltip.add((Component)new TranslatableComponent("dragon_sword_lightning.hurt2").m_130940_(ChatFormatting.DARK_PURPLE));
        }
    }
}

