/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockDragonforgeBricks;
import com.github.alexthe666.iceandfire.block.BlockDragonforgeCore;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.github.alexthe666.iceandfire.message.MessageUpdateDragonforge;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class TileEntityDragonforge
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public int fireType;
    public int cookTime;
    public int lastDragonFlameTimer = 0;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private NonNullList<ItemStack> forgeItemStacks = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private boolean prevAssembled;
    private boolean canAddFlameAgain = true;

    public TileEntityDragonforge(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafTileEntityRegistry.DRAGONFORGE_CORE.get(), pos, state);
    }

    public TileEntityDragonforge(BlockPos pos, BlockState state, int fireType) {
        super((BlockEntityType)IafTileEntityRegistry.DRAGONFORGE_CORE.get(), pos, state);
        this.fireType = fireType;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TileEntityDragonforge entityDragonforge) {
        boolean flag = entityDragonforge.isBurning();
        boolean flag1 = false;
        entityDragonforge.fireType = entityDragonforge.getFireType(entityDragonforge.m_58900_().m_60734_());
        if (entityDragonforge.lastDragonFlameTimer > 0) {
            --entityDragonforge.lastDragonFlameTimer;
        }
        entityDragonforge.updateGrills(entityDragonforge.assembled());
        if (!level.f_46443_) {
            if (entityDragonforge.prevAssembled != entityDragonforge.assembled()) {
                BlockDragonforgeCore.setState(entityDragonforge.fireType, entityDragonforge.prevAssembled, level, pos);
            }
            entityDragonforge.prevAssembled = entityDragonforge.assembled();
            if (!entityDragonforge.assembled()) {
                return;
            }
        }
        if (entityDragonforge.cookTime > 0 && entityDragonforge.canSmelt() && entityDragonforge.lastDragonFlameTimer == 0) {
            --entityDragonforge.cookTime;
        }
        if (entityDragonforge.m_8020_(0).m_41619_() && !level.f_46443_) {
            entityDragonforge.cookTime = 0;
        }
        if (!entityDragonforge.f_58857_.f_46443_) {
            if (entityDragonforge.isBurning()) {
                if (entityDragonforge.canSmelt()) {
                    ++entityDragonforge.cookTime;
                    if (entityDragonforge.cookTime >= entityDragonforge.getMaxCookTime()) {
                        entityDragonforge.cookTime = 0;
                        entityDragonforge.smeltItem();
                        flag1 = true;
                    }
                } else if (entityDragonforge.cookTime > 0) {
                    IceAndFire.sendMSGToAll(new MessageUpdateDragonforge(pos.m_121878_(), entityDragonforge.cookTime));
                    entityDragonforge.cookTime = 0;
                }
            } else if (!entityDragonforge.isBurning() && entityDragonforge.cookTime > 0) {
                entityDragonforge.cookTime = Mth.m_14045_((int)(entityDragonforge.cookTime - 2), (int)0, (int)entityDragonforge.getMaxCookTime());
            }
            if (flag != entityDragonforge.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            entityDragonforge.m_6596_();
        }
        if (!entityDragonforge.canAddFlameAgain) {
            entityDragonforge.canAddFlameAgain = true;
        }
    }

    public int m_6643_() {
        return this.forgeItemStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.forgeItemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void updateGrills(boolean grill) {
        for (Direction facing : HORIZONTALS) {
            BlockPos grillPos = this.m_58899_().m_142300_(facing);
            if (!this.grillMatches(this.f_58857_.m_8055_(grillPos).m_60734_())) continue;
            BlockState grillState = (BlockState)this.getGrillBlock().m_49966_().m_61124_((Property)BlockDragonforgeBricks.GRILL, (Comparable)Boolean.valueOf(grill));
            if (this.f_58857_.m_8055_(grillPos) == grillState) continue;
            this.f_58857_.m_46597_(grillPos, grillState);
        }
    }

    public Block getGrillBlock() {
        switch (this.fireType) {
            case 1: {
                return (Block)IafBlockRegistry.DRAGONFORGE_ICE_BRICK.get();
            }
            case 2: {
                return (Block)IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK.get();
            }
        }
        return (Block)IafBlockRegistry.DRAGONFORGE_FIRE_BRICK.get();
    }

    public boolean grillMatches(Block block) {
        switch (this.fireType) {
            case 0: {
                return block == IafBlockRegistry.DRAGONFORGE_FIRE_BRICK.get();
            }
            case 1: {
                return block == IafBlockRegistry.DRAGONFORGE_ICE_BRICK.get();
            }
            case 2: {
                return block == IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK.get();
            }
        }
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.forgeItemStacks.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.forgeItemStacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.forgeItemStacks, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.forgeItemStacks.get(index);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.forgeItemStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !flag || this.cookTime > this.getMaxCookTime()) {
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.forgeItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.forgeItemStacks);
        this.cookTime = compound.m_128451_("CookTime");
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("CookTime", (int)((short)this.cookTime));
        ContainerHelper.m_18973_((CompoundTag)compound, this.forgeItemStacks);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public int getFireType(Block block) {
        if (block == IafBlockRegistry.DRAGONFORGE_FIRE_CORE.get() || block == IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED.get()) {
            return 0;
        }
        if (block == IafBlockRegistry.DRAGONFORGE_ICE_CORE.get() || block == IafBlockRegistry.DRAGONFORGE_ICE_CORE_DISABLED.get()) {
            return 1;
        }
        if (block == IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE.get() || block == IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()) {
            return 2;
        }
        return 0;
    }

    public String getTypeID() {
        switch (this.getFireType(this.m_58900_().m_60734_())) {
            case 0: {
                return "fire";
            }
            case 1: {
                return "ice";
            }
            case 2: {
                return "lightning";
            }
        }
        return "";
    }

    public int getMaxCookTime() {
        return this.getCurrentRecipe().map(DragonForgeRecipe::getCookTime).orElse(100);
    }

    private Block getDefaultOutput() {
        return this.fireType == 1 ? (Block)IafBlockRegistry.DRAGON_ICE.get() : (Block)IafBlockRegistry.ASH.get();
    }

    private ItemStack getCurrentResult() {
        Optional<DragonForgeRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            return recipe.get().m_8043_();
        }
        return new ItemStack((ItemLike)this.getDefaultOutput());
    }

    public Optional<DragonForgeRecipe> getCurrentRecipe() {
        return this.f_58857_.m_7465_().m_44015_(IafRecipeRegistry.DRAGON_FORGE_TYPE, (Container)this, this.f_58857_);
    }

    public List<DragonForgeRecipe> getRecipes() {
        return this.f_58857_.m_7465_().m_44013_(IafRecipeRegistry.DRAGON_FORGE_TYPE);
    }

    public boolean canSmelt() {
        ItemStack cookStack = (ItemStack)this.forgeItemStacks.get(0);
        if (cookStack.m_41619_()) {
            return false;
        }
        ItemStack forgeRecipeOutput = this.getCurrentResult();
        if (forgeRecipeOutput.m_41619_()) {
            return false;
        }
        ItemStack outputStack = (ItemStack)this.forgeItemStacks.get(2);
        if (!outputStack.m_41619_() && !outputStack.m_41656_(forgeRecipeOutput)) {
            return false;
        }
        int calculatedOutputCount = outputStack.m_41613_() + forgeRecipeOutput.m_41613_();
        return calculatedOutputCount <= this.m_6893_() && calculatedOutputCount <= outputStack.m_41741_();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack cookStack = (ItemStack)this.forgeItemStacks.get(0);
        ItemStack bloodStack = (ItemStack)this.forgeItemStacks.get(1);
        ItemStack outputStack = (ItemStack)this.forgeItemStacks.get(2);
        ItemStack output = this.getCurrentResult();
        if (outputStack.m_41619_()) {
            this.forgeItemStacks.set(2, (Object)output.m_41777_());
        } else {
            outputStack.m_41769_(output.m_41613_());
        }
        cookStack.m_41774_(1);
        bloodStack.m_41774_(1);
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        switch (index) {
            case 1: {
                return this.getRecipes().stream().anyMatch(item -> item.isValidBlood(stack));
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == Direction.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStackIn, Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.m_41720_();
            return item == Items.f_42447_ || item == Items.f_42446_;
        }
        return true;
    }

    public void m_6211_() {
        this.forgeItemStacks.clear();
    }

    public <T> @NotNull LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @NotNull
    protected Component m_6820_() {
        return new TranslatableComponent("container.dragonforge_fire" + DragonType.getNameFromInt(this.fireType));
    }

    public void transferPower(int i) {
        if (!this.f_58857_.f_46443_) {
            if (this.canSmelt()) {
                if (this.canAddFlameAgain) {
                    this.cookTime = Math.min(this.getMaxCookTime() + 1, this.cookTime + i);
                    this.canAddFlameAgain = false;
                }
            } else {
                this.cookTime = 0;
            }
            IceAndFire.sendMSGToAll(new MessageUpdateDragonforge(this.f_58858_.m_121878_(), this.cookTime));
        }
        this.lastDragonFlameTimer = 40;
    }

    private boolean checkBoneCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.m_142127_().m_142126_(), (Block)IafBlockRegistry.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.m_142127_().m_142125_(), (Block)IafBlockRegistry.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.m_142128_().m_142126_(), (Block)IafBlockRegistry.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.m_142128_().m_142125_(), (Block)IafBlockRegistry.DRAGON_BONE_BLOCK.get());
    }

    private boolean checkBrickCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.m_142127_().m_142126_(), this.getBrick()) && this.doesBlockEqual(pos.m_142127_().m_142125_(), this.getBrick()) && this.doesBlockEqual(pos.m_142128_().m_142126_(), this.getBrick()) && this.doesBlockEqual(pos.m_142128_().m_142125_(), this.getBrick());
    }

    private boolean checkBrickSlots(BlockPos pos) {
        return this.doesBlockEqual(pos.m_142127_(), this.getBrick()) && this.doesBlockEqual(pos.m_142126_(), this.getBrick()) && this.doesBlockEqual(pos.m_142125_(), this.getBrick()) && this.doesBlockEqual(pos.m_142128_(), this.getBrick());
    }

    private boolean checkY(BlockPos pos) {
        return this.doesBlockEqual(pos.m_7494_(), this.getBrick()) && this.doesBlockEqual(pos.m_7495_(), this.getBrick());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public boolean assembled() {
        return this.checkBoneCorners(this.f_58858_.m_7495_()) && this.checkBrickSlots(this.f_58858_.m_7495_()) && this.checkBrickCorners(this.f_58858_) && this.atleastThreeAreBricks(this.f_58858_) && this.checkY(this.f_58858_) && this.checkBoneCorners(this.f_58858_.m_7494_()) && this.checkBrickSlots(this.f_58858_.m_7494_());
    }

    private Block getBrick() {
        switch (this.fireType) {
            case 0: {
                return (Block)IafBlockRegistry.DRAGONFORGE_FIRE_BRICK.get();
            }
            case 1: {
                return (Block)IafBlockRegistry.DRAGONFORGE_ICE_BRICK.get();
            }
        }
        return (Block)IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK.get();
    }

    private boolean doesBlockEqual(BlockPos pos, Block block) {
        return this.f_58857_.m_8055_(pos).m_60734_() == block;
    }

    private boolean atleastThreeAreBricks(BlockPos pos) {
        int count = 0;
        for (Direction facing : HORIZONTALS) {
            if (this.f_58857_.m_8055_(pos.m_142300_(facing)).m_60734_() != this.getBrick()) continue;
            ++count;
        }
        return count > 2;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ContainerDragonForge(id, (Container)this, playerInventory, (ContainerData)new SimpleContainerData(0));
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return new ContainerDragonForge(id, (Container)this, player, (ContainerData)new SimpleContainerData(0));
    }
}

