/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntitySiren;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AquaticAIGetOutOfWater
extends Goal {
    private final Mob creature;
    private final double movementSpeed;
    private final Level world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public AquaticAIGetOutOfWater(Mob theCreatureIn, double movementSpeedIn) {
        this.creature = theCreatureIn;
        this.movementSpeed = movementSpeedIn;
        this.world = theCreatureIn.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.creature.m_20069_() || !((EntitySiren)this.creature).wantsToSing()) {
            return false;
        }
        Vec3 Vector3d = this.findPossibleShelter();
        if (Vector3d == null) {
            return false;
        }
        this.shelterX = Vector3d.f_82479_;
        this.shelterY = Vector3d.f_82480_;
        this.shelterZ = Vector3d.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        return !this.creature.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.creature.m_21573_().m_26519_(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    @Nullable
    private Vec3 findPossibleShelter() {
        Random random = this.creature.m_21187_();
        BlockPos blockpos = new BlockPos(this.creature.m_20185_(), this.creature.m_142469_().f_82289_, this.creature.m_20189_());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.m_142082_(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.world.m_8055_(blockpos1).m_60804_((BlockGetter)this.world, blockpos1)) continue;
            return new Vec3((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
        }
        return null;
    }
}

