/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.DragonFireEvent;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonFireCharge;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonSyncFire;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class EntityFireDragon
extends EntityDragonBase {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final ResourceLocation FEMALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/fire_dragon_female");
    public static final ResourceLocation MALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/fire_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = new ResourceLocation("iceandfire", "entities/dragon/fire_dragon_skeleton");

    public EntityFireDragon(Level worldIn) {
        this((EntityType)IafEntityRegistry.FIRE_DRAGON.get(), worldIn);
    }

    public EntityFireDragon(EntityType<?> t, Level worldIn) {
        super(t, worldIn, DragonType.FIRE, 1.0, 1 + IafConfig.dragonAttackDamage, IafConfig.dragonHealth * 0.04, IafConfig.dragonHealth, 0.15f, 0.4f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.m_21824_()) {
            return entity.m_6095_() != this.m_6095_() && this.m_20205_() >= entity.m_20205_() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof Player || DragonUtils.isDragonTargetable(entity, IafTagRegistry.FIRE_DRAGON_TARGETS) || !this.m_21824_() && DragonUtils.isVillager(entity);
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "red_";
            }
            case 1: {
                return "green_";
            }
            case 2: {
                return "bronze_";
            }
            case 3: 
        }
        return "gray_";
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return (Item)IafItemRegistry.DRAGONSCALES_RED.get();
            }
            case 1: {
                return (Item)IafItemRegistry.DRAGONSCALES_GREEN.get();
            }
            case 2: {
                return (Item)IafItemRegistry.DRAGONSCALES_BRONZE.get();
            }
            case 3: 
        }
        return (Item)IafItemRegistry.DRAGONSCALES_GRAY.get();
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return (Item)IafItemRegistry.DRAGONEGG_RED.get();
            }
            case 1: {
                return (Item)IafItemRegistry.DRAGONEGG_GREEN.get();
            }
            case 2: {
                return (Item)IafItemRegistry.DRAGONEGG_BRONZE.get();
            }
            case 3: 
        }
        return (Item)IafItemRegistry.DRAGONEGG_GRAY.get();
    }

    @Override
    public Item getSummoningCrystal() {
        return (Item)IafItemRegistry.SUMMONING_CRYSTAL_FIRE.get();
    }

    @Override
    public boolean m_5807_() {
        return true;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        this.m_21563_().m_24960_(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0), entityIn.m_20182_().m_82520_(0.0, (double)(entityIn.m_20206_() / 2.0f), 0.0)) && entityIn.m_20205_() < this.m_20205_() * 0.5f && this.m_6688_() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.m_20329_((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (!this.f_19853_.f_46443_ && attackTarget != null) {
            if (this.m_142469_().m_82377_((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).m_82381_(attackTarget.m_142469_())) {
                this.m_7327_((Entity)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.f_19861_)) {
                this.shootFireAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.m_20280_((Entity)attackTarget) < 100.0) {
                double difX = attackTarget.m_20185_() - this.m_20185_();
                double difY = attackTarget.m_20186_() + (double)attackTarget.m_20206_() - this.m_20186_();
                double difZ = attackTarget.m_20189_() - this.m_20189_();
                this.m_20256_(this.m_20184_().m_82520_(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.m_142469_().m_82377_((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).m_82381_(attackTarget.m_142469_())) {
                    this.m_7327_((Entity)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.m_146922_(this.f_20883_);
                if (this.f_19797_ % 5 == 0) {
                    this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.m_123341_() + 0.5f, (float)burningTarget.m_123342_() + 0.5f, (float)burningTarget.m_123343_() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.m_21187_().nextInt(5) == 0 && !this.m_6162_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.m_146922_(this.f_20883_);
                Vec3 headVec = this.getHeadPosition();
                this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.m_20154_().f_82479_;
                double d3 = controller.m_20154_().f_82480_;
                double d4 = controller.m_20154_().f_82481_;
                float inaccuracy = 1.0f;
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType)IafEntityRegistry.FIRE_DRAGON_CHARGE.get(), this.f_19853_, (EntityDragonBase)this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7967_((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                HitResult mop;
                this.m_146922_(this.f_20883_);
                if (this.f_19797_ % 5 == 0) {
                    this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.m_82450_().f_82479_, mop.m_82450_().f_82480_, mop.m_82450_().f_82481_, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    protected ItemLike getHeartItem() {
        return (ItemLike)IafItemRegistry.FIRE_DRAGON_HEART.get();
    }

    protected float m_6041_() {
        if (this.m_6046_()) {
            return this.getDragonStage() >= 2 ? 1.0f : 0.8f;
        }
        return super.m_6041_();
    }

    @Override
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_20077_()) {
            if (this.m_6142_() && this.m_6688_() == null) {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.7));
                if (this.m_5448_() == null) {
                    // empty if block
                }
            } else if (this.allowLocalMotionControl && this.m_6688_() != null && this.m_5807_() && !this.isHovering() && !this.isFlying()) {
                LivingEntity rider = (LivingEntity)this.m_6688_();
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                float lavaSpeedMod = (float)((double)0.28f + 0.1 * Mth.m_144914_((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                speed *= lavaSpeedMod;
                speed *= rider.m_20142_() ? 1.4f : 1.0f;
                float vertical = 0.0f;
                if (this.isGoingUp() && !this.isGoingDown()) {
                    vertical = 0.8f;
                } else if (this.isGoingDown() && !this.isGoingUp()) {
                    vertical = -0.8f;
                } else if (this.isGoingUp() && this.isGoingDown() && this.m_6109_()) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, (double)0.3f, 1.0));
                }
                Vec3 travelVector = new Vec3((double)rider.f_20900_, (double)vertical, (double)rider.f_20902_);
                if (this.m_6109_()) {
                    this.m_7910_(speed);
                    this.m_19920_(this.m_6113_(), travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    Vec3 currentMotion = this.m_20184_();
                    if (this.f_19862_) {
                        currentMotion = new Vec3(currentMotion.f_82479_, 0.2, currentMotion.f_82481_);
                    }
                    this.m_20256_(currentMotion.m_82490_(0.7));
                    this.m_21043_((LivingEntity)this, false);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
            } else {
                super.m_7023_(pTravelVector);
            }
        } else {
            if (this.allowLocalMotionControl && this.m_6688_() != null && this.m_5807_() && !this.isHovering() && !this.isFlying() && this.f_19853_.m_8055_(this.m_20099_()).m_60819_().m_205070_(FluidTags.f_13132_)) {
                LivingEntity rider = (LivingEntity)this.m_6688_();
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_;
                double vertical = pTravelVector.f_82480_;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
                speed *= groundSpeedModifier;
                forward *= rider.m_20142_() ? (double)1.2f : 1.0;
                forward *= rider.f_20902_ > 0.0f ? 1.0 : (double)0.2f;
                strafing *= (double)0.05f;
                if (this.m_6109_()) {
                    this.f_20887_ = speed * 0.1f;
                    this.m_7910_(speed);
                    super.m_7023_(new Vec3(strafing, vertical, forward));
                    Vec3 currentMotion = this.m_20184_();
                    if (this.f_19862_) {
                        currentMotion = new Vec3(currentMotion.f_82479_, 0.2, currentMotion.f_82481_);
                    }
                    this.m_20256_(currentMotion.m_82490_(0.7));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
                return;
            }
            super.m_7023_(pTravelVector);
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.m_21187_().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.m_146922_(this.f_20883_);
                    Vec3 headVec = this.getHeadPosition();
                    double d2 = entity.m_20185_() - headVec.f_82479_;
                    double d3 = entity.m_20186_() - headVec.f_82480_;
                    double d4 = entity.m_20189_() - headVec.f_82481_;
                    float inaccuracy = 1.0f;
                    this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType)IafEntityRegistry.FIRE_DRAGON_CHARGE.get(), this.f_19853_, (EntityDragonBase)this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                    if (!this.f_19853_.f_46443_) {
                        this.f_19853_.m_7967_((Entity)entitylargefireball);
                    }
                    if (!entity.m_6084_() || entity == null) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.m_146922_(this.f_20883_);
                    if (this.f_19797_ % 5 == 0) {
                        this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1);
                    if (!entity.m_6084_() || entity == null) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.m_21391_((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireEvent(this, burnX, burnY, burnZ))) {
            return;
        }
        if (syncType == 1 && !this.f_19853_.f_46443_) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 2 && this.f_19853_.f_46443_) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 3 && !this.f_19853_.f_46443_) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 5));
        }
        if (syncType == 4 && this.f_19853_.f_46443_) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 5));
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.m_146922_(this.f_20883_);
                Vec3 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.f_82479_;
                double d3 = burnY - headVec.f_82480_;
                double d4 = burnZ - headVec.f_82481_;
                float inaccuracy = 1.0f;
                this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType)IafEntityRegistry.FIRE_DRAGON_CHARGE.get(), this.f_19853_, (EntityDragonBase)this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7967_((Entity)entitylargefireball);
                }
                this.randomizeAttacks();
            }
            return;
        }
        this.m_21573_().m_26573_();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.f_82479_;
        double d3 = burnY - headPos.f_82480_;
        double d4 = burnZ - headPos.f_82481_;
        double distance = Math.max(2.5 * this.m_20275_(burnX, burnY, burnZ), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int particleCount = this.getDragonStage() <= 3 ? 6 : 3;
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.f_82479_ + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.f_82480_ + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.f_82481_ + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(particleCount) == 0) {
                    IceAndFire.PROXY.spawnDragonParticle(EnumParticles.DragonFire, headPos.f_82479_, headPos.f_82480_, headPos.f_82481_, 0.0, 0.0, 0.0, this);
                }
            } else if (!this.f_19853_.f_46443_) {
                BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_()), new Vec3(progressX, progressY, progressZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                BlockPos pos = new BlockPos(result.m_82450_());
                IafDragonDestructionManager.destroyAreaFire(this.f_19853_, pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.f_19796_.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.f_19796_.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.f_19796_.nextFloat() * 3.0 - 1.5;
            if (!this.f_19853_.f_46443_) {
                IafDragonDestructionManager.destroyAreaFire(this.f_19853_, new BlockPos(spawnX, spawnY, spawnZ), this);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_IDLE : (this.m_6125_() ? IafSoundRegistry.FIREDRAGON_ADULT_IDLE : IafSoundRegistry.FIREDRAGON_CHILD_IDLE);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_HURT : (this.m_6125_() ? IafSoundRegistry.FIREDRAGON_ADULT_HURT : IafSoundRegistry.FIREDRAGON_CHILD_HURT);
    }

    protected SoundEvent m_5592_() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_DEATH : (this.m_6125_() ? IafSoundRegistry.FIREDRAGON_ADULT_DEATH : IafSoundRegistry.FIREDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_ROAR : (this.m_6125_() ? IafSoundRegistry.FIREDRAGON_ADULT_ROAR : IafSoundRegistry.FIREDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() != null && stack.m_41720_() == IafItemRegistry.FIRE_STEW.get();
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            if (!this.f_19853_.f_46443_) continue;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d2, d0, d1);
        }
    }

    @Override
    protected void spawnBabyParticles() {
        for (int i = 0; i < 5; ++i) {
            float radiusAdd = (float)i * 0.15f;
            float headPosX = (float)(this.m_20185_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
            float headPosZ = (float)(this.m_20186_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
            float headPosY = (float)(this.m_20189_() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)IafItemRegistry.DRAGON_SKULL_FIRE.get());
    }

    @Override
    protected Item getBloodItem() {
        return (Item)IafItemRegistry.FIRE_DRAGON_BLOOD.get();
    }
}

