/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.config;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.config.DefaultBiomes;
import com.github.alexthe666.iceandfire.config.biome.IafSpawnBiomeData;
import com.github.alexthe666.iceandfire.config.biome.SpawnBiomeConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeConfig {
    public static Pair<String, IafSpawnBiomeData> oreGenBiomes = Pair.of((Object)"iceandfire:ore_gen_biomes", (Object)((Object)DefaultBiomes.OVERWORLD));
    public static Pair<String, IafSpawnBiomeData> sapphireBiomes = Pair.of((Object)"iceandfire:sapphire_gen_biomes", (Object)((Object)DefaultBiomes.VERY_SNOWY));
    public static Pair<String, IafSpawnBiomeData> amethystBiomes = Pair.of((Object)"iceandfire:amethyst_gen_biomes", (Object)((Object)DefaultBiomes.SAVANNAS));
    public static Pair<String, IafSpawnBiomeData> fireLilyBiomes = Pair.of((Object)"iceandfire:fire_lily_biomes", (Object)((Object)DefaultBiomes.VERY_HOT));
    public static Pair<String, IafSpawnBiomeData> iceLilyBiomes = Pair.of((Object)"iceandfire:ice_lily_biomes", (Object)((Object)DefaultBiomes.VERY_SNOWY));
    public static Pair<String, IafSpawnBiomeData> lightningLilyBiomes = Pair.of((Object)"iceandfire:lightning_lily_biomes", (Object)((Object)DefaultBiomes.SAVANNAS));
    public static Pair<String, IafSpawnBiomeData> fireDragonBiomes = Pair.of((Object)"iceandfire:fire_dragon_biomes", (Object)((Object)DefaultBiomes.FIREDRAGON_ROOST));
    public static Pair<String, IafSpawnBiomeData> fireDragonCaveBiomes = Pair.of((Object)"iceandfire:fire_dragon_cave_biomes", (Object)((Object)DefaultBiomes.FIREDRAGON_CAVE));
    public static Pair<String, IafSpawnBiomeData> iceDragonBiomes = Pair.of((Object)"iceandfire:ice_dragon_biomes", (Object)((Object)DefaultBiomes.ICEDRAGON_ROOST));
    public static Pair<String, IafSpawnBiomeData> iceDragonCaveBiomes = Pair.of((Object)"iceandfire:ice_dragon_cave_biomes", (Object)((Object)DefaultBiomes.ICEDRAGON_CAVE));
    public static Pair<String, IafSpawnBiomeData> lightningDragonBiomes = Pair.of((Object)"iceandfire:lightning_dragon_biomes", (Object)((Object)DefaultBiomes.LIGHTNING_ROOST));
    public static Pair<String, IafSpawnBiomeData> lightningDragonCaveBiomes = Pair.of((Object)"iceandfire:lightning_dragon_cave_biomes", (Object)((Object)DefaultBiomes.LIGHTNING_CAVE));
    public static Pair<String, IafSpawnBiomeData> cyclopsCaveBiomes = Pair.of((Object)"iceandfire:cyclops_cave_biomes", (Object)((Object)DefaultBiomes.BEACHES));
    public static Pair<String, IafSpawnBiomeData> hippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_biomes", (Object)((Object)DefaultBiomes.HILLS));
    public static Pair<String, IafSpawnBiomeData> pixieBiomes = Pair.of((Object)"iceandfire:pixie_village_biomes", (Object)((Object)DefaultBiomes.PIXIES));
    public static Pair<String, IafSpawnBiomeData> hippocampusBiomes = Pair.of((Object)"iceandfire:hippocampus_biomes", (Object)((Object)DefaultBiomes.OCEANS));
    public static Pair<String, IafSpawnBiomeData> seaSerpentBiomes = Pair.of((Object)"iceandfire:sea_serpent_biomes", (Object)((Object)DefaultBiomes.OCEANS));
    public static Pair<String, IafSpawnBiomeData> sirenBiomes = Pair.of((Object)"iceandfire:siren_biomes", (Object)((Object)DefaultBiomes.OCEANS));
    public static Pair<String, IafSpawnBiomeData> amphithereBiomes = Pair.of((Object)"iceandfire:amphithere_biomes", (Object)((Object)DefaultBiomes.JUNGLE));
    public static Pair<String, IafSpawnBiomeData> desertMyrmexBiomes = Pair.of((Object)"iceandfire:desert_myrmex_biomes", (Object)((Object)DefaultBiomes.DESERT));
    public static Pair<String, IafSpawnBiomeData> jungleMyrmexBiomes = Pair.of((Object)"iceandfire:jungle_myrmex_biomes", (Object)((Object)DefaultBiomes.JUNGLE));
    public static Pair<String, IafSpawnBiomeData> snowyTrollBiomes = Pair.of((Object)"iceandfire:snowy_troll_biomes", (Object)((Object)DefaultBiomes.SNOWY));
    public static Pair<String, IafSpawnBiomeData> forestTrollBiomes = Pair.of((Object)"iceandfire:forest_troll_biomes", (Object)((Object)DefaultBiomes.WOODLAND));
    public static Pair<String, IafSpawnBiomeData> mountainTrollBiomes = Pair.of((Object)"iceandfire:mountain_troll_biomes", (Object)((Object)DefaultBiomes.VERY_HILLY));
    public static Pair<String, IafSpawnBiomeData> stymphalianBiomes = Pair.of((Object)"iceandfire:stymphalian_bird_biomes", (Object)((Object)DefaultBiomes.SWAMPS));
    public static Pair<String, IafSpawnBiomeData> hydraBiomes = Pair.of((Object)"iceandfire:hydra_cave_biomes", (Object)((Object)DefaultBiomes.SWAMPS));
    public static Pair<String, IafSpawnBiomeData> mausoleumBiomes = Pair.of((Object)"iceandfire:mausoleum_biomes", (Object)((Object)DefaultBiomes.MAUSOLEUM));
    public static Pair<String, IafSpawnBiomeData> graveyardBiomes = Pair.of((Object)"iceandfire:graveyard_biomes", (Object)((Object)DefaultBiomes.GRAVEYARD));
    public static Pair<String, IafSpawnBiomeData> gorgonTempleBiomes = Pair.of((Object)"iceandfire:gorgon_temple_biomes", (Object)((Object)DefaultBiomes.BEACHES));
    public static Pair<String, IafSpawnBiomeData> cockatriceBiomes = Pair.of((Object)"iceandfire:cockatrice_biomes", (Object)((Object)DefaultBiomes.SAVANNAS));
    public static Pair<String, IafSpawnBiomeData> deathwormBiomes = Pair.of((Object)"iceandfire:deathworm_biomes", (Object)((Object)DefaultBiomes.DESERT));
    public static Pair<String, IafSpawnBiomeData> wanderingCyclopsBiomes = Pair.of((Object)"iceandfire:wandering_cyclops_biomes", (Object)((Object)DefaultBiomes.PLAINS));
    public static Pair<String, IafSpawnBiomeData> lightningDragonSkeletonBiomes = Pair.of((Object)"iceandfire:lightning_dragon_skeleton_biomes", (Object)((Object)DefaultBiomes.SAVANNAS));
    public static Pair<String, IafSpawnBiomeData> fireDragonSkeletonBiomes = Pair.of((Object)"iceandfire:fire_dragon_skeleton_biomes", (Object)((Object)DefaultBiomes.DESERT));
    public static Pair<String, IafSpawnBiomeData> iceDragonSkeletonBiomes = Pair.of((Object)"iceandfire:ice_dragon_skeleton_biomes", (Object)((Object)DefaultBiomes.VERY_SNOWY));
    public static Pair<String, IafSpawnBiomeData> blackHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_black_biomes", (Object)((Object)DefaultBiomes.HIPPOGRYPH_BLACK));
    public static Pair<String, IafSpawnBiomeData> brownHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_brown_biomes", (Object)((Object)DefaultBiomes.VERY_HILLY));
    public static Pair<String, IafSpawnBiomeData> grayHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_gray_biomes", (Object)((Object)DefaultBiomes.HIPPOGRYPH_GRAY));
    public static Pair<String, IafSpawnBiomeData> chestnutHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_chestnut_biomes", (Object)((Object)DefaultBiomes.HIPPOGRYPH_CHESTNUT));
    public static Pair<String, IafSpawnBiomeData> creamyHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_creamy_biomes", (Object)((Object)DefaultBiomes.HIPPOGRYPH_CREAMY));
    public static Pair<String, IafSpawnBiomeData> darkBrownHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_dark_brown_biomes", (Object)((Object)DefaultBiomes.HIPPOGRYPH_DARK_BROWN));
    public static Pair<String, IafSpawnBiomeData> whiteHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_white_biomes", (Object)((Object)DefaultBiomes.HIPPOGRYPH_WHITE));
    private static boolean init = false;
    private static final Map<String, IafSpawnBiomeData> biomeConfigValues = new HashMap<String, IafSpawnBiomeData>();

    public static void init() {
        try {
            for (Field f : BiomeConfig.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Pair)) continue;
                String id = (String)((Pair)obj).getLeft();
                IafSpawnBiomeData data = (IafSpawnBiomeData)((Object)((Pair)obj).getRight());
                biomeConfigValues.put(id, SpawnBiomeConfig.create(new ResourceLocation(id), data));
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Encountered error building iceandfire biome config .json files");
            e.printStackTrace();
        }
        init = true;
    }

    public static boolean test(Pair<String, IafSpawnBiomeData> spawns, Holder<Biome> biome) {
        if (!init) {
            BiomeConfig.init();
        }
        return biomeConfigValues.get(spawns.getKey()).matches(biome, ((Biome)biome.m_203334_()).getRegistryName());
    }

    @Deprecated(since="1.19.2", forRemoval=true)
    public static boolean test(Pair<String, IafSpawnBiomeData> spawns, Biome biome) {
        if (!init) {
            BiomeConfig.init();
        }
        return biomeConfigValues.get(spawns.getKey()).matches(biome);
    }
}

