/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.client.model.ModelPixie;
import com.github.alexthe666.iceandfire.client.render.entity.RenderPixie;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RenderJar<T extends TileEntityJar>
implements BlockEntityRenderer<T> {
    public static final RenderType TEXTURE_0 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_0, (boolean)false);
    public static final RenderType TEXTURE_1 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_1, (boolean)false);
    public static final RenderType TEXTURE_2 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_2, (boolean)false);
    public static final RenderType TEXTURE_3 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_3, (boolean)false);
    public static final RenderType TEXTURE_4 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_4, (boolean)false);
    public static final RenderType TEXTURE_5 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_5, (boolean)false);
    public static final RenderType TEXTURE_0_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_0);
    public static final RenderType TEXTURE_1_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_1);
    public static final RenderType TEXTURE_2_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_2);
    public static final RenderType TEXTURE_3_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_3);
    public static final RenderType TEXTURE_4_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_4);
    public static final RenderType TEXTURE_5_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_5);
    private static ModelPixie MODEL_PIXIE;

    public RenderJar(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull T entity, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int meta = 0;
        boolean hasPixie = false;
        if (MODEL_PIXIE == null) {
            MODEL_PIXIE = new ModelPixie();
        }
        if (entity != null && entity.m_58904_() != null) {
            meta = ((TileEntityJar)((Object)entity)).pixieType;
            hasPixie = ((TileEntityJar)((Object)entity)).hasPixie;
        }
        if (hasPixie) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, (double)1.501f, 0.5);
            matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122223_, 180.0f, true));
            matrixStackIn.m_85836_();
            RenderType type = TEXTURE_0;
            RenderType typeGlow = TEXTURE_0_GLO;
            switch (meta) {
                default: {
                    type = TEXTURE_0;
                    typeGlow = TEXTURE_0_GLO;
                    break;
                }
                case 1: {
                    type = TEXTURE_1;
                    typeGlow = TEXTURE_1_GLO;
                    break;
                }
                case 2: {
                    type = TEXTURE_2;
                    typeGlow = TEXTURE_2_GLO;
                    break;
                }
                case 3: {
                    type = TEXTURE_3;
                    typeGlow = TEXTURE_3_GLO;
                    break;
                }
                case 4: {
                    type = TEXTURE_4;
                    typeGlow = TEXTURE_4_GLO;
                }
            }
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(type);
            if (entity != null && entity.m_58904_() != null) {
                if (((TileEntityJar)((Object)entity)).hasProduced) {
                    matrixStackIn.m_85837_(0.0, (double)0.9f, 0.0);
                } else {
                    matrixStackIn.m_85837_(0.0, (double)0.6f, 0.0);
                }
                matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122225_, this.interpolateRotation(((TileEntityJar)((Object)entity)).prevRotationYaw, ((TileEntityJar)((Object)entity)).rotationYaw, partialTicks), true));
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                MODEL_PIXIE.animateInJar(((TileEntityJar)((Object)entity)).hasProduced, (TileEntityJar)((Object)entity), 0.0f);
                MODEL_PIXIE.m_7695_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                MODEL_PIXIE.m_7695_(matrixStackIn, bufferIn.m_6299_(typeGlow), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }
}

