/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.packets;

import com.dainxt.weaponthrow.handlers.EventsHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SPacketThrow {
    private final int progress;
    private UUID playerAnimated;
    private boolean isCharging;

    public SPacketThrow(UUID player, int maxTime, boolean isCharging) {
        this.progress = maxTime;
        this.playerAnimated = player;
        this.isCharging = isCharging;
    }

    public static void encode(SPacketThrow msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.playerAnimated.toString());
        buf.writeInt(msg.progress);
        buf.writeBoolean(msg.isCharging);
    }

    public static SPacketThrow decode(FriendlyByteBuf buf) {
        return new SPacketThrow(UUID.fromString(buf.m_130277_()), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketThrow msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> EventsHandler.onSeverUpdate(msg.playerAnimated, msg.progress, msg.isCharging));
        }
        ctx.get().setPacketHandled(true);
    }
}

