/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.SimpleBlockPredicate;
import biomesoplenty.init.ModTags;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class FleshTendonFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() == BOPBlocks.ROSE_QUARTZ_CLUSTER || world.m_8055_(pos).m_60734_() == BOPBlocks.LARGE_ROSE_QUARTZ_BUD || world.m_8055_(pos).m_60734_() == BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD || world.m_8055_(pos).m_60734_() == BOPBlocks.SMALL_ROSE_QUARTZ_BUD || world.m_8055_(pos).m_60734_() == BOPBlocks.FLESH_TENDONS_STRAND || world.m_8055_(pos).m_60734_() == BOPBlocks.FLESH_TENDONS || world.m_8055_(pos).m_60734_() == BOPBlocks.PUS_BUBBLE || world.m_8055_(pos).m_60734_() == BOPBlocks.HAIR || world.m_8055_(pos).m_60734_() == BOPBlocks.BLOOD;
    private static final int MIN_DISTANCE = 8;
    private static final int MAX_DISTANCE = 32;
    private static final float MID_POS_MULTIPLIER = 0.9f;
    private static final float TENDON_STEP = 0.005f;

    public FleshTendonFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    private static BlockPos quadratic(float t, BlockPos v0, BlockPos v1, BlockPos v2) {
        float dt = 1.0f - t;
        Vec3 v = new Vec3((double)v0.m_123341_(), (double)v0.m_123342_(), (double)v0.m_123343_()).m_82490_((double)(dt * dt)).m_82549_(new Vec3((double)v1.m_123341_(), (double)v1.m_123342_(), (double)v1.m_123343_()).m_82490_((double)(2.0f * dt * t))).m_82549_(new Vec3((double)v2.m_123341_(), (double)v2.m_123342_(), (double)v2.m_123343_()).m_82490_((double)(t * t)));
        return new BlockPos(v.f_82479_, v.f_82480_, v.f_82481_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos curPos;
        WorldGenLevel world = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos pos = context.m_159777_();
        BlockState below = world.m_8055_(pos.m_7495_());
        if (!below.m_204336_(ModTags.Blocks.FLESH)) {
            return false;
        }
        int xOff = rand.nextInt(64) - 32;
        int zOff = rand.nextInt(64) - 32;
        int minX = rand.nextBoolean() ? 8 : -8;
        int minZ = rand.nextBoolean() ? 8 : -8;
        BlockPos endPos = pos.m_142082_(Math.abs(xOff) < 8 ? minX : xOff, pos.m_123342_(), Math.abs(zOff) < 8 ? minZ : zOff);
        while (world.m_46859_(endPos) && endPos.m_123342_() < 126) {
            endPos = endPos.m_7494_();
        }
        if (endPos.m_123342_() == pos.m_123342_()) {
            return false;
        }
        Logger utilLogger = (Logger)LogManager.getLogger(Util.class);
        Level oldLevel = utilLogger.getLevel();
        utilLogger.setLevel(Level.OFF);
        BlockPos midPos = endPos.m_142022_(0.0, (double)((float)(-(endPos.m_123342_() - pos.m_123342_())) * 0.9f), 0.0);
        for (float d = 0.0f; d < 1.0f && (curPos = FleshTendonFeature.quadratic(d, pos, midPos, endPos)).m_123342_() < 126; d += 0.005f) {
            BlockState fleshBlock = BOPBlocks.FLESH.m_49966_();
            if (rand.nextInt(5) == 0) {
                fleshBlock = BOPBlocks.POROUS_FLESH.m_49966_();
            }
            this.setBlock(world, curPos, fleshBlock);
            if (rand.nextInt(75) == 0) {
                this.generateFleshBall(world, curPos, rand);
            }
            if (rand.nextInt(4) != 0) continue;
            this.placeFleshTendonColumn(world, rand, curPos.m_7495_());
        }
        utilLogger.setLevel(oldLevel);
        return true;
    }

    public boolean generateFleshBall(WorldGenLevel world, BlockPos pos, Random rand) {
        this.setBlock(world, pos, BOPBlocks.POROUS_FLESH.m_49966_());
        this.setBlock(world, pos.m_142127_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_142128_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_142126_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_142125_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_142127_().m_142125_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_142128_().m_142125_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_142127_().m_142126_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_142128_().m_142126_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_142127_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_142128_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_142126_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_142125_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_142127_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_142128_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_142126_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_142125_(), BOPBlocks.FLESH.m_49966_());
        this.placeFleshTendonColumn(world, rand, pos.m_6625_(2));
        return true;
    }

    public void placeFleshTendonColumn(WorldGenLevel p_67377_, Random p_67378_, BlockPos p_67379_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        blockpos$mutable.m_122190_((Vec3i)p_67379_);
        int rand = p_67378_.nextInt(6);
        int minHeight = rand == 0 ? 4 : 1;
        int maxHeight = rand == 0 ? 8 : 4;
        int height = Mth.m_14072_((Random)p_67378_, (int)minHeight, (int)maxHeight);
        if (p_67377_.m_8055_(blockpos$mutable.m_7494_()).m_204336_(ModTags.Blocks.FLESH)) {
            Block fleshCheck;
            for (int i = 0; i <= height && (fleshCheck = p_67377_.m_8055_(blockpos$mutable.m_7495_()).m_60734_()) != BOPBlocks.FLESH_TENDONS && fleshCheck != BOPBlocks.FLESH_TENDONS_STRAND; ++i) {
                if (p_67377_.m_46859_((BlockPos)blockpos$mutable)) {
                    if (i == height || !p_67377_.m_46859_(blockpos$mutable.m_7495_())) {
                        this.setBlock(p_67377_, (BlockPos)blockpos$mutable, BOPBlocks.FLESH_TENDONS.m_49966_(), 2);
                        break;
                    }
                    this.setBlock(p_67377_, (BlockPos)blockpos$mutable, BOPBlocks.FLESH_TENDONS_STRAND.m_49966_(), 2);
                }
                blockpos$mutable.m_122173_(Direction.DOWN);
            }
        }
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state, int flags) {
        if (this.replace.matches(world, pos)) {
            world.m_7731_(pos, state, flags);
            return true;
        }
        return false;
    }
}

