/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylib.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kosmx.bendylib.ICuboidBuilder;
import io.github.kosmx.bendylib.MutableCuboid;
import io.github.kosmx.bendylib.impl.ICuboid;
import io.github.kosmx.bendylib.impl.accessors.CuboidSideAccessor;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Tuple;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.Cube.class})
public class CuboidMutator
implements MutableCuboid,
CuboidSideAccessor {
    @Shadow
    @Final
    public float f_104335_;
    @Shadow
    @Final
    public float f_104336_;
    @Shadow
    @Final
    public float f_104337_;
    @Mutable
    @Shadow
    @Final
    private ModelPart.Polygon[] f_104341_;
    HashMap<String, ICuboid> mutators = new HashMap();
    HashMap<String, ICuboidBuilder> mutatorBuilders = new HashMap();
    private ModelPart.Polygon[] originalQuads;
    private boolean isSidesSwapped = false;
    ICuboidBuilder.Data partData;
    @Nullable
    ICuboid activeMutator;
    @Nullable
    String activeMutatorID;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void constructor(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, CallbackInfo ci) {
        this.partData = new ICuboidBuilder.Data(u, v, this.f_104335_, this.f_104336_, this.f_104337_, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirror, textureWidth, textureHeight);
        this.originalQuads = this.f_104341_;
    }

    @Override
    public boolean registerMutator(String name, ICuboidBuilder<ICuboid> builder) {
        if (this.mutatorBuilders.containsKey(name)) {
            return false;
        }
        if (builder == null) {
            throw new NullPointerException("builder can not be null");
        }
        this.mutatorBuilders.put(name, builder);
        return true;
    }

    @Override
    public boolean unregisterMutator(String name) {
        if (this.mutatorBuilders.remove(name) != null) {
            if (name.equals(this.activeMutatorID)) {
                this.activeMutator = null;
                this.activeMutatorID = null;
            }
            this.mutators.remove(name);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Tuple<String, ICuboid> getActiveMutator() {
        return this.activeMutator == null ? null : new Tuple((Object)this.activeMutatorID, (Object)this.activeMutator);
    }

    @Override
    @Nullable
    public ICuboid getMutator(String name) {
        return this.mutators.get(name);
    }

    @Override
    @Nullable
    public ICuboid getAndActivateMutator(@Nullable String name) {
        if (name == null) {
            this.activeMutatorID = null;
            this.activeMutator = null;
            return null;
        }
        if (this.mutatorBuilders.containsKey(name)) {
            if (!this.mutators.containsKey(name)) {
                this.mutators.put(name, (ICuboid)this.mutatorBuilders.get(name).build(this.partData));
            }
            this.activeMutatorID = name;
            this.activeMutator = this.mutators.get(name);
            return this.activeMutator;
        }
        return null;
    }

    @Override
    public void copyStateFrom(MutableCuboid other) {
        if (other.getActiveMutator() == null) {
            this.activeMutator = null;
            this.activeMutatorID = null;
        } else if (this.getAndActivateMutator((String)other.getActiveMutator().m_14418_()) != null) {
            this.activeMutator.copyState((ICuboid)other.getActiveMutator().m_14419_());
        }
    }

    @Inject(method={"renderCuboid"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderRedirect(PoseStack.Pose entry, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (this.getActiveMutator() != null) {
            ((ICuboid)this.getActiveMutator().m_14419_()).render(entry, vertexConsumer, red, green, blue, alpha, light, overlay);
            if (((ICuboid)this.getActiveMutator().m_14419_()).disableAfterDraw()) {
                this.activeMutator = null;
                this.activeMutatorID = null;
            }
            ci.cancel();
        }
    }

    @Override
    public void doSideSwapping() {
        List<ModelPart.Polygon> sides;
        if (this.getActiveMutator() != null && (sides = ((ICuboid)this.getActiveMutator().m_14419_()).getQuads()) != null) {
            this.isSidesSwapped = true;
            this.f_104341_ = sides.toArray(new ModelPart.Polygon[4]);
        }
    }

    @Override
    public ModelPart.Polygon[] getSides() {
        return this.f_104341_;
    }

    @Override
    public void setSides(ModelPart.Polygon[] sides) {
        this.isSidesSwapped = true;
        this.f_104341_ = sides;
    }

    @Override
    public void resetSides() {
        this.f_104341_ = this.originalQuads;
        this.isSidesSwapped = false;
    }
}

