/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import java.util.Random;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;

public class RandomWrapper
extends Random
implements RandomSource {
    protected final RandomSource source;

    public static Random of(RandomSource source) {
        return new RandomWrapper(source);
    }

    protected RandomWrapper(RandomSource source) {
        super(source.nextLong());
        this.source = source;
    }

    public RandomSource m_183458_() {
        return this.source.m_183458_();
    }

    public PositionalRandomFactory m_183423_() {
        return this.source.m_183423_();
    }

    @Override
    public void setSeed(long pSeed) {
        super.setSeed(pSeed);
        if (this.source != null) {
            this.source.setSeed(pSeed);
        }
    }

    @Override
    public int nextInt() {
        return this.source.nextInt();
    }

    @Override
    public int nextInt(int pBound) {
        return this.source.nextInt(pBound);
    }

    @Override
    public int nextInt(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound - origin is non positive");
        }
        return origin + this.source.nextInt(bound - origin);
    }

    @Override
    public long nextLong() {
        return this.source.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.source.nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.source.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.source.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.source.nextGaussian();
    }
}

