/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.compat;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class Weather2 {
    private static final Lazy<Optional<Weather2>> INSTANCE = AbstractForgeMod.singletonInstance("weather2", Weather2.class);
    private final Method getServerWeatherManager;
    private final Method getClientWeatherManager;
    private final Method getWindManager;
    private final Method getWindForce;

    private Weather2() throws ClassNotFoundException, NoSuchMethodException {
        boolean isClient = FMLEnvironment.dist.isClient();
        Class<?> serverTickHandler = Class.forName("weather2.ServerTickHandler");
        Class<?> clientTickHandler = isClient ? Class.forName("weather2.ClientTickHandler") : null;
        Class<?> weatherManager = Class.forName("weather2.weathersystem.WeatherManager");
        Class<?> windManager = Class.forName("weather2.weathersystem.wind.WindManager");
        this.getServerWeatherManager = serverTickHandler.getMethod("getWeatherManagerFor", ResourceKey.class);
        this.getClientWeatherManager = isClient ? clientTickHandler.getMethod("getClientWeather", new Class[0]) : null;
        this.getWindManager = weatherManager.getMethod("getWindManager", new Class[0]);
        this.getWindForce = windManager.getMethod("getWindForce", new Class[0]);
    }

    public static Optional<Weather2> getInstance() {
        return (Optional)INSTANCE.get();
    }

    private Vec3 getWindForce(Level level) throws InvocationTargetException, IllegalAccessException {
        Object weatherManager = level.m_5776_() ? this.getClientWeatherManager.invoke(null, new Object[0]) : this.getServerWeatherManager.invoke(null, level.m_46472_());
        Object windManager = this.getWindManager.invoke(weatherManager, new Object[0]);
        return (Vec3)this.getWindForce.invoke(windManager, new Object[0]);
    }

    public Optional<IWind> getWindAt(Level level, BlockPos pos) {
        try {
            Vec3 windForce = this.getWindForce(level);
            Wind.StaticWind wind = new Wind.StaticWind(Vect3d.from(windForce));
            return Optional.of(wind);
        }
        catch (Exception e) {
            ForgeEndertech.debugMsg(e.toString());
            return Optional.empty();
        }
    }
}

