/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class RelatedBlock
extends ForgeBlock
implements IRelatedUnit {
    private final UnitId relatedBlockId;

    public RelatedBlock(AbstractForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props.name, ((Properties)props.setBlockProps()).block);
        this.relatedBlockId = props.id;
    }

    @Override
    public UnitId getRelatedId() {
        return this.relatedBlockId;
    }

    @Override
    public String getClassRegName() {
        return "";
    }

    @Nullable
    public BlockState getRelatedState() {
        return this.getRelatedId() != null ? this.getRelatedId().getFirstMatchedState() : null;
    }

    public boolean exists() {
        return this.getRelatedState() != null;
    }

    public SoundType m_49962_(BlockState state) {
        return this.getRelatedState() != null ? this.getRelatedState().m_60827_() : super.m_49962_(state);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return this.getRelatedState() != null ? this.getRelatedState().getSoundType(world, pos, entity) : super.getSoundType(state, world, pos, entity);
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public String name = "";
        public BlockBehaviour.Properties block = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50016_);

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> withId(UnitId relatedBlockId) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return ((Properties)((Properties)props.id(relatedBlockId)).name(relatedBlockId.getRegName())).propsFromRelatedBlock();
        }

        public T name(String name) {
            this.name = name;
            return (T)((Properties)this.self);
        }

        public T nameSuffix(String suffix) {
            return this.name(Names.registry().join(this.name, suffix));
        }

        public T block(BlockBehaviour.Properties block) {
            this.block = block;
            return (T)((Properties)this.self);
        }

        public T propsFromRelatedBlock() {
            return this.block(this.id.getBlockProperties());
        }

        public T setBlockProps() {
            return (T)((Properties)this.self);
        }
    }

    public static class Item
    extends ForgeBlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        @Override
        protected boolean m_41389_(CreativeModeTab group) {
            RelatedBlock block;
            if (this.m_40614_() instanceof RelatedBlock && !(block = (RelatedBlock)this.m_40614_()).exists()) {
                return false;
            }
            return super.m_41389_(group);
        }
    }
}

