/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.common.item.ItemCrystalCatalyst;
import wayoftime.bloodmagic.common.tile.TileDemonCrystal;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="forsaken_soul")
public class RitualForsakenSoul
extends Ritual {
    public static final String CRYSTAL_RANGE = "crystal";
    public static final String CHEST_RANGE = "chest";
    public List<Integer> keyList = new ArrayList<Integer>();

    public RitualForsakenSoul() {
        super("ritualForsakenSoul", 0, 40000, "ritual.bloodmagic.forsakenSoulRitual");
        this.addBlockRange(CRYSTAL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-3, -7, -3), 7, 5, 7));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 2, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(CRYSTAL_RANGE, 250, 5, 7);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = Math.min(100, currentEssence / this.getRefreshCost());
        int totalEffects = 0;
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        List<BlockPos> chestList = chestRange.getContainedPositions(pos);
        if (chestList.size() <= 0) {
            return;
        }
        BlockEntity tileInventory = world.m_7702_(chestList.get(0));
        if (tileInventory == null) {
            return;
        }
        IItemHandler inventory = Utils.getInventory(tileInventory, null);
        if (inventory == null) {
            return;
        }
        ArrayList<TileDemonCrystal> crystalList = new ArrayList<TileDemonCrystal>();
        AreaDescriptor crystalRange = masterRitualStone.getBlockRange(CRYSTAL_RANGE);
        crystalRange.resetIterator();
        while (crystalRange.hasNext()) {
            BlockPos nextPos = ((BlockPos)crystalRange.next()).m_141952_((Vec3i)pos);
            BlockEntity tile = world.m_7702_(nextPos);
            if (!(tile instanceof TileDemonCrystal)) continue;
            crystalList.add((TileDemonCrystal)tile);
        }
        Collections.shuffle(crystalList);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            int extractedCount;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemCrystalCatalyst)) continue;
            stack = inventory.extractItem(i, stack.m_41613_(), true);
            int remainingCount = stack.m_41613_();
            for (TileDemonCrystal crystalTile : crystalList) {
                if (!((ItemCrystalCatalyst)stack.m_41720_()).applyCatalyst(crystalTile) || --remainingCount > 0 && ++totalEffects < maxEffects) continue;
                break;
            }
            if ((extractedCount = stack.m_41613_() - remainingCount) > 0) {
                inventory.extractItem(i, extractedCount, false);
            }
            if (totalEffects >= maxEffects) break;
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, -1, EnumRuneType.DUSK);
        this.addParallelRunes(components, 1, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, 1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 3, 1, 1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualForsakenSoul();
    }
}

