/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockMasterRitualStone;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.IRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="crushing")
public class RitualCrushing
extends Ritual {
    public static final String CRUSHING_RANGE = "crushingRange";
    public static final String CHEST_RANGE = "chest";
    public static double rawWillDrain = 0.05;
    public static double steadfastWillDrain = 0.2;
    public static double destructiveWillDrain = 0.2;
    public static double vengefulWillDrain = 0.2;
    public static Map<ItemStack, Integer> cuttingFluidLPMap = new HashMap<ItemStack, Integer>();
    public static Map<ItemStack, Double> cuttingFluidWillMap = new HashMap<ItemStack, Double>();
    public static int defaultRefreshTime = 40;
    private FakePlayer fakePlayer;
    public int refreshTime = 40;
    private static final ItemStack mockPick = new ItemStack((ItemLike)Items.f_42390_, 1);

    public RitualCrushing() {
        super("ritualCrushing", 0, 5000, "ritual.bloodmagic.crushingRitual");
        this.addBlockRange(CRUSHING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(CRUSHING_RANGE, 50, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        if (world.f_46443_) {
            return;
        }
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        List<BlockPos> chestList = chestRange.getContainedPositions(pos);
        if (chestList.size() <= 0) {
            return;
        }
        BlockEntity tile = world.m_7702_(chestList.get(0));
        if (tile != null && Utils.getNumberOfFreeSlots(tile, Direction.DOWN) < 1) {
            return;
        }
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        boolean isSilkTouch = steadfastWill >= steadfastWillDrain;
        boolean useCuttingFluid = corrosiveWill > 0.0;
        int fortune = destructiveWill > 0.0 ? 3 : 0;
        AreaDescriptor crushingRange = masterRitualStone.getBlockRange(CRUSHING_RANGE);
        boolean hasOperated = false;
        double rawDrain = 0.0;
        for (BlockPos newPos : crushingRange.getContainedPositions(pos)) {
            BlockState state;
            Block block;
            if (world.m_46859_(newPos) || (block = (state = world.m_8055_(newPos)).m_60734_()) instanceof BlockMasterRitualStone || block instanceof IRitualStone || state.m_60800_((BlockGetter)world, newPos) == -1.0f || Utils.isBlockLiquid(state)) continue;
            boolean isBlockClaimed = false;
            if (!isBlockClaimed && isSilkTouch) {
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerLevel)world);
                Vec3 blockCenter = new Vec3((double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5);
                List silkDrops = state.m_60724_(lootBuilder.m_78972_(LootContextParams.f_81460_, (Object)blockCenter).m_78972_(LootContextParams.f_81463_, (Object)mockPick));
                for (ItemStack item : silkDrops) {
                    ItemStack copyStack = item.m_41777_();
                    if (tile == null) {
                        Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                        continue;
                    }
                    copyStack = Utils.insertStackIntoTile(copyStack, tile, Direction.DOWN);
                    if (copyStack.m_41619_()) continue;
                    Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                }
                if (!(steadfastWill >= steadfastWillDrain)) continue;
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWillDrain, true);
                steadfastWill -= steadfastWillDrain;
            } else if (!isBlockClaimed) {
                if (fortune > 0 && destructiveWill < destructiveWillDrain) {
                    fortune = 0;
                }
                ItemStack mockFortunePick = new ItemStack((ItemLike)Items.f_42390_, 1);
                mockFortunePick.m_41663_(Enchantments.f_44987_, fortune);
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerLevel)world);
                Vec3 blockCenter = new Vec3((double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5);
                List stackList = state.m_60724_(lootBuilder.m_78972_(LootContextParams.f_81460_, (Object)blockCenter).m_78972_(LootContextParams.f_81463_, (Object)mockFortunePick));
                for (ItemStack item : stackList) {
                    ItemStack copyStack = item.m_41777_();
                    if (tile == null) {
                        Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                        continue;
                    }
                    copyStack = Utils.insertStackIntoTile(copyStack, tile, Direction.DOWN);
                    if (copyStack.m_41619_()) continue;
                    Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                }
                if (fortune > 0) {
                    WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveWillDrain, true);
                    destructiveWill -= destructiveWillDrain;
                }
            }
            world.m_46961_(newPos, false);
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
            hasOperated = true;
            if (!consumeRawWill) break;
            rawDrain += rawWillDrain;
            rawWill -= rawWillDrain;
            break;
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= rawWillDrain) {
            return Math.max(1, (int)(40.0 - rawWill / 5.0));
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getRefreshCost() {
        return 7;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, 1, EnumRuneType.AIR);
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{new TranslatableComponent(this.getTranslationKey() + ".info"), new TranslatableComponent(this.getTranslationKey() + ".default.info"), new TranslatableComponent(this.getTranslationKey() + ".corrosive.info"), new TranslatableComponent(this.getTranslationKey() + ".steadfast.info"), new TranslatableComponent(this.getTranslationKey() + ".destructive.info"), new TranslatableComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrushing();
    }

    public static void registerCuttingFluid(ItemStack stack, int lpDrain, double willDrain) {
        cuttingFluidLPMap.put(stack, lpDrain);
        cuttingFluidWillMap.put(stack, willDrain);
    }

    private FakePlayer getFakePlayer(ServerLevel world) {
        return this.fakePlayer == null ? (this.fakePlayer = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_crushing"))) : this.fakePlayer;
    }

    static {
        mockPick.m_41663_(Enchantments.f_44985_, 1);
    }
}

