/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.altar;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NumeralHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class BloodAltarRecipeCategory
implements IRecipeCategory<RecipeBloodAltar> {
    private static final int INPUT_SLOT = 1;
    private static final int OUTPUT_SLOT = 0;
    public static final ResourceLocation UID = BloodMagic.rl("altar");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public BloodAltarRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)BloodMagicBlocks.BLOOD_ALTAR.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/altar.png"), 3, 4, 155, 65);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public List<Component> getTooltipStrings(RecipeBloodAltar recipe, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 13.0 && mouseX <= 64.0 && mouseY >= 27.0 && mouseY <= 58.0) {
            tooltip.add(new TranslatableComponent("jei.bloodmagic.recipe.consumptionrate", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getConsumeRate())}));
            tooltip.add(new TranslatableComponent("jei.bloodmagic.recipe.drainrate", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getDrainRate())}));
        }
        return tooltip;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.bloodmagic.recipe.altar");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeBloodAltar recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 125, 30);
        guiItemStacks.init(1, true, 31, 0);
        guiItemStacks.set(ingredients);
    }

    public Class<? extends RecipeBloodAltar> getRecipeClass() {
        return RecipeBloodAltar.class;
    }

    public void setIngredients(RecipeBloodAltar recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void draw(RecipeBloodAltar recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        String[] infoString = new String[]{TextHelper.localize("jei.bloodmagic.recipe.requiredtier", NumeralHelper.toRoman(recipe.getMinimumTier() + 1)), TextHelper.localize("jei.bloodmagic.recipe.requiredlp", recipe.getSyphon())};
        mc.f_91062_.m_92883_(matrixStack, infoString[0], (float)(90 - mc.f_91062_.m_92895_(infoString[0]) / 2), 0.0f, Color.gray.getRGB());
        mc.f_91062_.m_92883_(matrixStack, infoString[1], (float)(90 - mc.f_91062_.m_92895_(infoString[1]) / 2), 10.0f, Color.gray.getRGB());
    }
}

