/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.base.TileTicking;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.event.RitualEvent;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumReaderBoundaries;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.RitualHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileMasterRitualStone
extends TileTicking
implements IMasterRitualStone {
    protected final Map<String, AreaDescriptor> modableRangeMap = new HashMap<String, AreaDescriptor>();
    private UUID owner;
    private SoulNetwork cachedNetwork;
    private boolean active;
    private boolean redstoned;
    private int activeTime;
    private int cooldown;
    private Ritual currentRitual;
    private Direction direction = Direction.NORTH;
    private boolean inverted;
    private List<EnumDemonWillType> currentActiveWillConfig = new ArrayList<EnumDemonWillType>();

    public TileMasterRitualStone(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileMasterRitualStone(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.MASTER_RITUAL_STONE_TYPE.get(), pos, state);
    }

    @Override
    public void onUpdate() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.isPowered() && this.isActive()) {
            this.active = false;
            this.redstoned = true;
            this.stopRitual(Ritual.BreakType.REDSTONE);
            return;
        }
        if (!this.isActive() && !this.isPowered() && this.isRedstoned() && this.getCurrentRitual() != null) {
            this.active = true;
            ItemStack crystalStack = NBTHelper.checkNBT(ItemActivationCrystal.CrystalType.getStack(this.getCurrentRitual().getCrystalLevel()));
            BindableHelper.applyBinding(crystalStack, new Binding(this.owner, PlayerHelper.getUsernameFromUUID(this.owner)));
            this.activateRitual(crystalStack, null, this.getCurrentRitual());
            this.redstoned = false;
        }
        if (this.getCurrentRitual() != null && this.isActive()) {
            if (this.activeTime % this.getCurrentRitual().getRefreshTime() == 0) {
                this.performRitual(this.m_58904_(), this.m_58899_());
            }
            ++this.activeTime;
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        UUID uUID = this.owner = tag.m_128403_("owner") ? tag.m_128342_("owner") : null;
        if (this.owner != null) {
            this.cachedNetwork = NetworkHelper.getSoulNetwork(this.owner);
        }
        this.currentRitual = BloodMagic.RITUAL_MANAGER.getRitual(tag.m_128461_("currentRitual"));
        if (this.currentRitual != null) {
            CompoundTag ritualTag = tag.m_128469_("currentRitualTag");
            if (!ritualTag.m_128456_()) {
                this.currentRitual.readFromNBT(ritualTag);
            }
            this.addBlockRanges(this.currentRitual.getModableRangeMap());
            for (Map.Entry<String, AreaDescriptor> entry : this.modableRangeMap.entrySet()) {
                CompoundTag descriptorTag = ritualTag.m_128469_(entry.getKey());
                entry.getValue().readFromNBT(descriptorTag);
            }
        }
        this.active = tag.m_128471_("isRunning");
        this.activeTime = tag.m_128451_("runtime");
        this.direction = Direction.values()[tag.m_128451_("direction")];
        this.redstoned = tag.m_128471_("isStoned");
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            if (!tag.m_128471_("EnumWill" + type)) continue;
            this.currentActiveWillConfig.add(type);
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        String ritualId = BloodMagic.RITUAL_MANAGER.getId(this.getCurrentRitual());
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
        tag.m_128359_("currentRitual", Strings.isNullOrEmpty((String)ritualId) ? "" : ritualId);
        if (this.currentRitual != null) {
            CompoundTag ritualTag = new CompoundTag();
            this.currentRitual.writeToNBT(ritualTag);
            for (Map.Entry<String, AreaDescriptor> entry : this.modableRangeMap.entrySet()) {
                CompoundTag descriptorTag = new CompoundTag();
                entry.getValue().writeToNBT(descriptorTag);
                ritualTag.m_128365_(entry.getKey(), (Tag)descriptorTag);
            }
            tag.m_128365_("currentRitualTag", (Tag)ritualTag);
        }
        tag.m_128379_("isRunning", this.isActive());
        tag.m_128405_("runtime", this.getActiveTime());
        tag.m_128405_("direction", this.direction.m_122411_());
        tag.m_128379_("isStoned", this.redstoned);
        for (EnumDemonWillType type : this.currentActiveWillConfig) {
            tag.m_128379_("EnumWill" + type, true);
        }
        return tag;
    }

    @Override
    public boolean activateRitual(ItemStack activationCrystal, @Nullable Player activator, Ritual ritual) {
        if (PlayerHelper.isFakePlayer(activator)) {
            return false;
        }
        Binding binding = ((IBindable)activationCrystal.m_41720_()).getBinding(activationCrystal);
        if (binding != null && ritual != null) {
            int crystalLevel;
            if (activationCrystal.m_41720_() instanceof ItemActivationCrystal && RitualHelper.canCrystalActivate(ritual, crystalLevel = ((ItemActivationCrystal)activationCrystal.m_41720_()).getCrystalLevel(activationCrystal))) {
                if (!this.m_58904_().f_46443_) {
                    RitualEvent.RitualActivatedEvent event;
                    SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
                    if (!this.isRedstoned() && network.getCurrentEssence() < ritual.getActivationCost() && activator != null && !activator.m_7500_()) {
                        activator.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.weak"), true);
                        return false;
                    }
                    if (this.currentRitual != null) {
                        this.currentRitual.stopRitual(this, Ritual.BreakType.ACTIVATE);
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)(event = new RitualEvent.RitualActivatedEvent(this, binding.getOwnerId(), ritual, activator, activationCrystal, crystalLevel)))) {
                        if (activator != null) {
                            activator.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.prevent"), true);
                        }
                        return false;
                    }
                    if (ritual.activateRitual(this, activator, binding.getOwnerId())) {
                        if (!this.isRedstoned() && activator != null && !activator.m_7500_()) {
                            network.syphon(this.ticket(ritual.getActivationCost()));
                        }
                        if (activator != null) {
                            activator.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.activate"), true);
                        }
                        this.active = true;
                        this.owner = binding.getOwnerId();
                        this.cachedNetwork = network;
                        this.currentRitual = ritual;
                        if (!this.checkBlockRanges(ritual.getModableRangeMap())) {
                            this.addBlockRanges(ritual.getModableRangeMap());
                        }
                        this.notifyUpdate();
                        this.m_6596_();
                        return true;
                    }
                }
                this.notifyUpdate();
                return true;
            }
        } else if (activator != null) {
            activator.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.notValid"), true);
        }
        return false;
    }

    @Override
    public void performRitual(Level world, BlockPos pos) {
        if (!world.f_46443_ && this.getCurrentRitual() != null && BloodMagic.RITUAL_MANAGER.enabled(BloodMagic.RITUAL_MANAGER.getId(this.currentRitual), false)) {
            if (RitualHelper.checkValidRitual(this.m_58904_(), this.m_58899_(), this.currentRitual, this.getDirection())) {
                Ritual ritual = this.getCurrentRitual();
                RitualEvent.RitualRunEvent event = new RitualEvent.RitualRunEvent(this, this.getOwner(), ritual);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (!this.checkBlockRanges(this.getCurrentRitual().getModableRangeMap())) {
                    this.addBlockRanges(this.getCurrentRitual().getModableRangeMap());
                }
                this.getCurrentRitual().performRitual(this);
            } else {
                this.stopRitual(Ritual.BreakType.BREAK_STONE);
            }
        }
    }

    @Override
    public void stopRitual(Ritual.BreakType breakType) {
        if (!this.m_58904_().f_46443_ && this.getCurrentRitual() != null) {
            RitualEvent.RitualStopEvent event = new RitualEvent.RitualStopEvent(this, this.getOwner(), this.getCurrentRitual(), breakType);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            this.getCurrentRitual().stopRitual(this, breakType);
            if (breakType != Ritual.BreakType.REDSTONE) {
                this.currentRitual = null;
                this.active = false;
                this.activeTime = 0;
            }
            this.notifyUpdate();
        }
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public boolean areTanksEmpty() {
        return false;
    }

    @Override
    public int getRunningTime() {
        return this.activeTime;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public SoulNetwork getOwnerNetwork() {
        return this.cachedNetwork;
    }

    public Level m_58904_() {
        return super.m_58904_();
    }

    public BlockPos m_58899_() {
        return super.m_58899_();
    }

    @Override
    public Level getWorldObj() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getMasterBlockPos() {
        return this.m_58899_();
    }

    @Override
    public String getNextBlockRange(String range) {
        if (this.currentRitual != null) {
            return this.currentRitual.getNextBlockRange(range);
        }
        return "";
    }

    @Override
    public void provideInformationOfRitualToPlayer(Player player) {
        if (this.currentRitual != null) {
            ChatUtil.sendNoSpam(player, this.currentRitual.provideInformationOfRitualToPlayer(player));
        }
    }

    @Override
    public void provideInformationOfRangeToPlayer(Player player, String range) {
        if (this.currentRitual != null && this.currentRitual.getListOfRanges().contains(range)) {
            ChatUtil.sendNoSpam(player, this.currentRitual.provideInformationOfRangeToPlayer(player, range));
        }
    }

    @Override
    public void setActiveWillConfig(Player player, List<EnumDemonWillType> typeList) {
        this.currentActiveWillConfig = typeList;
    }

    @Override
    public EnumReaderBoundaries setBlockRangeByBounds(Player player, String range, BlockPos offset1, BlockPos offset2) {
        DemonWillHolder holder;
        AreaDescriptor descriptor = this.getBlockRange(range);
        EnumReaderBoundaries modificationType = this.currentRitual.canBlockRangeBeModified(range, descriptor, this, offset1, offset2, holder = WorldDemonWillHandler.getWillHolder(this.f_58857_, this.getMasterBlockPos()));
        if (modificationType == EnumReaderBoundaries.SUCCESS) {
            descriptor.modifyAreaByBlockPositions(offset1, offset2);
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return modificationType;
    }

    @Override
    public List<EnumDemonWillType> getActiveWillConfig() {
        return new ArrayList<EnumDemonWillType>(this.currentActiveWillConfig);
    }

    @Override
    public void provideInformationOfWillConfigToPlayer(Player player, List<EnumDemonWillType> typeList) {
        if (typeList.size() >= 1) {
            int i;
            Object[] translations = new TranslatableComponent[typeList.size()];
            StringBuilder constructedString = new StringBuilder("%s");
            for (i = 1; i < typeList.size(); ++i) {
                constructedString.append(", %s");
            }
            for (i = 0; i < typeList.size(); ++i) {
                translations[i] = new TranslatableComponent("tooltip.bloodmagic.currentBaseType." + typeList.get((int)i).name.toLowerCase(Locale.ROOT));
            }
            ChatUtil.sendNoSpam(player, new Component[]{new TranslatableComponent("ritual.bloodmagic.willConfig.set", new Object[]{new TranslatableComponent(constructedString.toString(), translations)})});
        } else {
            ChatUtil.sendNoSpam(player, new Component[]{new TranslatableComponent("ritual.bloodmagic.willConfig.void")});
        }
    }

    public boolean isPowered() {
        if (this.inverted) {
            return !this.m_58904_().m_46753_(this.m_58899_());
        }
        return this.m_58904_().m_46753_(this.m_58899_());
    }

    public SoulNetwork getCachedNetwork() {
        return this.cachedNetwork;
    }

    public void setCachedNetwork(SoulNetwork cachedNetwork) {
        this.cachedNetwork = cachedNetwork;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isRedstoned() {
        return this.redstoned;
    }

    public void setRedstoned(boolean redstoned) {
        this.redstoned = redstoned;
    }

    public int getActiveTime() {
        return this.activeTime;
    }

    public void setActiveTime(int activeTime) {
        this.activeTime = activeTime;
    }

    @Override
    public Ritual getCurrentRitual() {
        return this.currentRitual;
    }

    public void setCurrentRitual(Ritual currentRitual) {
        this.currentRitual = currentRitual;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public List<EnumDemonWillType> getCurrentActiveWillConfig() {
        return this.currentActiveWillConfig;
    }

    public void setCurrentActiveWillConfig(List<EnumDemonWillType> currentActiveWillConfig) {
        this.currentActiveWillConfig = currentActiveWillConfig;
    }

    @Override
    public AreaDescriptor getBlockRange(String range) {
        if (this.modableRangeMap.containsKey(range)) {
            return this.modableRangeMap.get(range);
        }
        return null;
    }

    @Override
    public void addBlockRange(String range, AreaDescriptor defaultRange) {
        this.modableRangeMap.putIfAbsent(range, defaultRange.copy());
    }

    @Override
    public void addBlockRanges(Map<String, AreaDescriptor> blockRanges) {
        for (Map.Entry<String, AreaDescriptor> entry : blockRanges.entrySet()) {
            this.modableRangeMap.putIfAbsent(entry.getKey(), entry.getValue().copy());
        }
    }

    @Override
    public void setBlockRange(String range, AreaDescriptor defaultRange) {
        this.modableRangeMap.put(range, defaultRange.copy());
    }

    @Override
    public void setBlockRanges(Map<String, AreaDescriptor> blockRanges) {
        for (Map.Entry<String, AreaDescriptor> entry : blockRanges.entrySet()) {
            this.modableRangeMap.put(entry.getKey(), entry.getValue().copy());
        }
    }

    public boolean checkBlockRanges(Map<String, AreaDescriptor> blockRanges) {
        for (Map.Entry<String, AreaDescriptor> entry : blockRanges.entrySet()) {
            if (this.modableRangeMap.get(entry.getKey()) != null) continue;
            return false;
        }
        return true;
    }
}

