/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.ILivingUpgradePointsProvider;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class ItemLivingTome
extends Item
implements ILivingContainer,
ILivingUpgradePointsProvider {
    public ItemLivingTome() {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        boolean oneLevel = !player.m_6144_();
        ItemStack held = player.m_21120_(hand);
        LivingStats armorStats = LivingStats.fromPlayer(player, true);
        if (armorStats == null) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        LivingStats tomeStats = this.getLivingStats(held);
        if (tomeStats == null) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        Map<LivingUpgrade, Double> upgradeMap = tomeStats.getUpgrades();
        boolean[] flag = new boolean[]{false};
        double[] expUsedArray = new double[upgradeMap.size()];
        int[] i = new int[]{0};
        upgradeMap.forEach((k, v) -> {
            if (oneLevel) {
                double curExp = armorStats.getUpgrades().getOrDefault(k, 0.0);
                double expToNextLevel = (double)k.getNextRequirement((int)curExp) - curExp;
                v = Math.min(expToNextLevel, v);
            }
            Pair<LivingStats, Double> upgraded = LivingUtil.applyExperienceToUpgradeCap(player, k, v);
            flag[0] = flag[0] || (Double)upgraded.getRight() > 0.0;
            expUsedArray[i[0]] = (Double)upgraded.getRight();
            i[0] = i[0] + 1;
        });
        if (flag[0]) {
            Object[] upgradeArray = upgradeMap.entrySet().toArray();
            for (int j = 0; j < expUsedArray.length; ++j) {
                double expUsed = expUsedArray[j];
                if (!(expUsed > 0.0)) continue;
                ResourceLocation key = ((LivingUpgrade)((Object)((Map.Entry)upgradeArray[j]).getKey())).getKey();
                tomeStats.addExperience(key, -expUsed);
                this.updateLivingStats(held, tomeStats);
            }
            if (!player.m_7500_()) {
                boolean doShrink = true;
                for (Map.Entry<LivingUpgrade, Double> entry : tomeStats.getUpgrades().entrySet()) {
                    LivingUpgrade upgrade = entry.getKey();
                    int level = upgrade.getLevel(entry.getValue().intValue());
                    if (level <= 0) continue;
                    doShrink = false;
                }
                if (doShrink) {
                    held.m_41774_(1);
                }
            }
            return InteractionResultHolder.m_19090_((Object)held);
        }
        return InteractionResultHolder.m_19098_((Object)held);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        for (Map.Entry<ResourceLocation, LivingUpgrade> entry : LivingArmorRegistrar.UPGRADE_MAP.entrySet()) {
            LivingUpgrade upgrade = entry.getValue();
            int exp = 0;
            while ((exp = upgrade.getNextRequirement(exp)) != 0) {
                ItemStack tome = new ItemStack((ItemLike)this);
                this.updateLivingStats(tome, new LivingStats().setMaxPoints(upgrade.getLevelCost(exp)).addExperience(upgrade.getKey(), exp));
                items.add((Object)tome);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        ILivingContainer.appendLivingTooltip(stack, this.getLivingStats(stack), tooltip, false);
    }

    @Override
    public int getAvailableUpgradePoints(ItemStack stack, int drain) {
        return this.getTotalUpgradePoints(stack);
    }

    @Override
    public ItemStack getResultingStack(ItemStack stack, int drain) {
        return ItemStack.f_41583_;
    }

    @Override
    public int getExcessUpgradePoints(ItemStack stack, int drain) {
        return 0;
    }

    @Override
    public int getTotalUpgradePoints(ItemStack stack) {
        LivingStats tomeStats = this.getLivingStats(stack);
        if (tomeStats == null) {
            return 0;
        }
        int containedPoints = 0;
        Map<LivingUpgrade, Double> upgradeMap = tomeStats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> entry : upgradeMap.entrySet()) {
            if (entry.getKey().isNegative()) {
                containedPoints += entry.getValue().intValue();
                continue;
            }
            containedPoints += entry.getKey().getLevelCost(entry.getKey().getLevel(entry.getValue().intValue()));
        }
        return containedPoints;
    }

    @Override
    public boolean canSyphonPoints(ItemStack stack, int drain) {
        return true;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 1;
    }
}

