/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.ItemThrowingDagger;
import wayoftime.bloodmagic.entity.projectile.AbstractEntityThrowingDagger;
import wayoftime.bloodmagic.entity.projectile.EntityThrowingDagger;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemIronThrowingDagger
extends ItemThrowingDagger {
    public static int[] soulBracket = new int[]{1, 60, 200, 400, 1000, 2000, 4000};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};

    @Override
    public AbstractEntityThrowingDagger getDagger(ItemStack stack, Level world, Player player) {
        EntityThrowingDagger dagger = new EntityThrowingDagger(stack, world, (LivingEntity)player);
        EnumDemonWillType largestType = PlayerDemonWillHandler.getLargestWillType(player);
        double souls = PlayerDemonWillHandler.getTotalDemonWill(largestType, player);
        int level = this.getLevel(souls);
        if (level >= 0) {
            double willDrop = soulDrop[level] * world.f_46441_.nextDouble() + staticDrop[level];
            dagger.setWillDrop(willDrop);
            dagger.setWillType(largestType);
        }
        dagger.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 0.5f);
        dagger.setDamage(10.0);
        dagger.addEffect(new MobEffectInstance(MobEffects.f_19614_, 800, 0));
        return dagger;
    }

    protected int getLevel(double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }
}

