/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ItemDemonCrystal;
import wayoftime.bloodmagic.common.tile.TileDemonCrystal;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class BlockDemonCrystal
extends Block
implements EntityBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    public static final EnumProperty<Direction> ATTACHED = EnumProperty.m_61587_((String)"attached", Direction.class);
    private static final EnumMap<Direction, VoxelShape> bounds = new EnumMap(Direction.class);
    public final EnumDemonWillType type;
    private static final VoxelShape[] UP = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)13.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)5.0), Block.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)13.0, (double)5.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)6.0, (double)7.0), Block.m_49796_((double)5.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)6.0, (double)6.0, (double)10.0), Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)15.0, (double)6.0, (double)9.0)};
    private static final VoxelShape[] DOWN = new VoxelShape[]{Block.m_49796_((double)6.0, (double)3.0, (double)7.0, (double)10.0, (double)16.0, (double)11.0), Block.m_49796_((double)7.0, (double)10.0, (double)11.0, (double)13.0, (double)16.0, (double)16.0), Block.m_49796_((double)9.0, (double)11.0, (double)2.0, (double)13.0, (double)16.0, (double)7.0), Block.m_49796_((double)2.0, (double)9.0, (double)11.0, (double)7.0, (double)16.0, (double)15.0), Block.m_49796_((double)5.0, (double)9.0, (double)1.0, (double)9.0, (double)16.0, (double)7.0), Block.m_49796_((double)0.0, (double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0), Block.m_49796_((double)10.0, (double)11.0, (double)7.0, (double)15.0, (double)16.0, (double)10.0)};
    private static final VoxelShape[] NORTH = new VoxelShape[]{Block.m_49796_((double)6.0, (double)5.0, (double)3.0, (double)10.0, (double)9.0, (double)16.0), Block.m_49796_((double)9.0, (double)0.0, (double)6.0, (double)13.0, (double)5.0, (double)16.0), Block.m_49796_((double)8.0, (double)9.0, (double)11.0, (double)13.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0), Block.m_49796_((double)5.0, (double)9.0, (double)9.0, (double)9.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)7.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0), Block.m_49796_((double)10.0, (double)7.0, (double)10.0, (double)15.0, (double)9.0, (double)15.0)};
    private static final VoxelShape[] SOUTH = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)0.0, (double)10.0, (double)11.0, (double)13.0), Block.m_49796_((double)7.0, (double)11.0, (double)0.0, (double)13.0, (double)16.0, (double)6.0), Block.m_49796_((double)8.0, (double)2.0, (double)9.0, (double)13.0, (double)7.0, (double)14.0), Block.m_49796_((double)2.0, (double)9.0, (double)1.0, (double)7.0, (double)14.0, (double)7.0), Block.m_49796_((double)5.0, (double)1.0, (double)9.0, (double)9.0, (double)7.0, (double)9.0), Block.m_49796_((double)0.0, (double)6.0, (double)1.0, (double)6.0, (double)9.0, (double)7.0), Block.m_49796_((double)10.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)6.0)};
    private static final VoxelShape[] EAST = new VoxelShape[]{Block.m_49796_((double)0.0, (double)6.0, (double)5.0, (double)13.0, (double)10.0, (double)9.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)6.0, (double)9.0, (double)5.0), Block.m_49796_((double)0.0, (double)3.0, (double)9.0, (double)5.0, (double)8.0, (double)14.0), Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)7.0, (double)13.0, (double)7.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)7.0, (double)11.0, (double)15.0), Block.m_49796_((double)0.0, (double)10.0, (double)7.0, (double)6.0, (double)16.0, (double)10.0), Block.m_49796_((double)0.0, (double)1.0, (double)6.0, (double)5.0, (double)6.0, (double)9.0)};
    private static final VoxelShape[] WEST = new VoxelShape[]{Block.m_49796_((double)3.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)9.0), Block.m_49796_((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)5.0), Block.m_49796_((double)11.0, (double)4.0, (double)9.0, (double)16.0, (double)13.0, (double)14.0), Block.m_49796_((double)9.0, (double)3.0, (double)1.0, (double)16.0, (double)8.0, (double)7.0), Block.m_49796_((double)9.0, (double)6.0, (double)9.0, (double)16.0, (double)8.0, (double)15.0), Block.m_49796_((double)10.0, (double)1.0, (double)7.0, (double)16.0, (double)6.0, (double)10.0), Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)15.0, (double)15.0, (double)9.0)};

    public BlockDemonCrystal(EnumDemonWillType type) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 5.0f).m_60999_());
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ATTACHED, (Comparable)Direction.UP)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public static ItemStack getItemStackDropped(EnumDemonWillType type, int crystalNumber) {
        ItemStack stack = ItemStack.f_41583_;
        switch (type) {
            case CORROSIVE: {
                stack = new ItemStack((ItemLike)BloodMagicItems.CORROSIVE_CRYSTAL.get());
                break;
            }
            case DEFAULT: {
                stack = new ItemStack((ItemLike)BloodMagicItems.RAW_CRYSTAL.get());
                break;
            }
            case DESTRUCTIVE: {
                stack = new ItemStack((ItemLike)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get());
                break;
            }
            case STEADFAST: {
                stack = new ItemStack((ItemLike)BloodMagicItems.STEADFAST_CRYSTAL.get());
                break;
            }
            case VENGEFUL: {
                stack = new ItemStack((ItemLike)BloodMagicItems.VENGEFUL_CRYSTAL.get());
            }
        }
        stack.m_41764_(crystalNumber);
        return stack;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_(ATTACHED)) {
            case DOWN: {
                return DOWN[0];
            }
            case NORTH: {
                return NORTH[0];
            }
            case SOUTH: {
                return SOUTH[0];
            }
            case EAST: {
                return EAST[0];
            }
            case WEST: {
                return WEST[0];
            }
        }
        return UP[0];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        BlockEntity tile;
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof TileDemonCrystal) {
            TileDemonCrystal crystal = (TileDemonCrystal)tile;
            boolean isCreative = player.m_7500_();
            boolean holdsCrystal = player.m_21120_(hand).m_41720_() instanceof ItemDemonCrystal;
            if (PlayerDemonWillHandler.getTotalDemonWill(PlayerDemonWillHandler.getLargestWillType(player), player) > 512.0 && (!holdsCrystal || !isCreative) && crystal.dropSingleCrystal()) {
                return InteractionResult.SUCCESS;
            }
            if (!crystal.m_58904_().f_46443_ && isCreative && holdsCrystal && crystal.getCrystalCount() < 7) {
                crystal.internalCounter = 0;
                if (crystal.progressToNextCrystal > 0.0) {
                    crystal.progressToNextCrystal -= 1.0;
                }
                crystal.setCrystalCount(crystal.getCrystalCount() + 1);
                crystal.m_6596_();
                crystal.notifyUpdate();
            }
        }
        return super.m_6227_(state, world, pos, player, hand, blockRayTraceResult);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_(ATTACHED);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : adirection = context.m_6232_()) {
            Direction direction1 = direction.m_122424_();
            if (!(blockstate = (BlockState)blockstate.m_61124_(ATTACHED, (Comparable)direction1)).m_60710_((LevelReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122424_() == stateIn.m_61143_(ATTACHED) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ATTACHED, AGE});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileDemonCrystal(this.type, pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, tile) -> {
            if (tile instanceof TileDemonCrystal) {
                ((TileDemonCrystal)tile).tick();
            }
        };
    }
}

