/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor.ReactorSensorSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor.ReactorSensorType;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.ITickableMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ReactorRedstonePortEntity
extends AbstractReactorEntity
implements INeighborChangeListener,
ITickableMultiblockPart,
MenuProvider {
    private ReactorSensorSetting _setting = ReactorSensorSetting.DISABLED;
    private int _ticksSinceLastUpdate = 0;
    private boolean _isLit = false;
    private boolean _isExternallyPowered = false;
    private int _externalPowerLevel = 0;

    public ReactorRedstonePortEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REACTOR_REDSTONEPORT.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_REDSTONE_SENSOR, ReactorRedstonePortEntity::setNewSensorFromGUI).addServerHandler(CommonConstants.COMMAND_DISABLE_REDSTONE_SENSOR, ReactorRedstonePortEntity::disableSensorFromGUI).build((AbstractModBlockEntity)this));
    }

    public ReactorSensorSetting getSettings() {
        return this._setting;
    }

    public int getOutputSignalPower() {
        return ((ReactorSensorType)this.getSettings().Sensor).isOutput() && this.isRedstoneActive() ? 15 : 0;
    }

    public boolean isLit() {
        return this._isLit;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (!this.isConnected()) {
            return;
        }
        if (((ReactorSensorType)this.getSettings().Sensor).isInput()) {
            this.getOutwardDirection().map(direction -> this.getRedstonePowerLevelFrom(this.getWorldPosition().m_142300_(direction), (Direction)direction)).ifPresent(powerLevel -> {
                boolean nowPowered;
                boolean bl = nowPowered = powerLevel > 0;
                if (this._isExternallyPowered != nowPowered || this._externalPowerLevel != powerLevel) {
                    this._isExternallyPowered = nowPowered;
                    this._externalPowerLevel = powerLevel;
                    this.onRedstoneInputUpdated();
                    this.m_6596_();
                    this.updateRedstoneStateAndNotify();
                }
            });
        } else {
            this._isExternallyPowered = false;
            this._externalPowerLevel = 0;
        }
    }

    public void onMultiblockServerTick() {
        if (!this.isConnected() || this._ticksSinceLastUpdate++ < (Integer)Config.COMMON.general.ticksPerRedstoneUpdate.get()) {
            return;
        }
        this.updateRedstoneStateAndNotify();
        this._ticksSinceLastUpdate = 0;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return ModTileContainer.empty((MenuType)((MenuType)Content.ContainerTypes.REACTOR_REDSTONEPORT.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayer)((ServerPlayer)player));
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.m_128441_("setting")) {
            this._setting = ReactorSensorSetting.syncDataFrom(data.m_128469_("setting"));
        }
        if (data.m_128441_("lit")) {
            this._isLit = data.m_128471_("lit");
        }
        if (syncReason.isFullSync()) {
            this.updateRedstoneStateAndNotify();
        } else {
            this.markForRenderUpdate();
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.m_128365_("setting", (Tag)this.getSettings().syncDataTo(new CompoundTag()));
        data.m_128379_("lit", this._isLit);
        return data;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this._isLit ? 1 : 0;
    }

    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    protected boolean isRedstoneActive() {
        ReactorSensorSetting settings = this.getSettings();
        return ((ReactorSensorType)settings.Sensor).isOutput() ? this.getMultiblockController().map(settings::test).orElse(false) : this._isExternallyPowered && this.isConnected();
    }

    private void onRedstoneInputUpdated() {
        this.getMultiblockController().ifPresent(c -> this.getSettings().inputAction((IReactorWriter)c, (Boolean)this._isExternallyPowered, this._externalPowerLevel));
    }

    private void updateRedstoneStateAndNotify() {
        this.callOnLogicalServer(world -> {
            boolean oldLitState = this._isLit;
            if (oldLitState != this.updateLitState()) {
                world.m_46672_(this.getWorldPosition(), this.getBlockType());
            }
            this.notifyTileEntityUpdate();
        });
    }

    private void setNewSensorFromGUI(CompoundTag data) {
        this._setting = ReactorSensorSetting.syncDataFrom(data);
        this.getOutwardDirection().ifPresent(outward -> {
            BlockPos position = this.getWorldPosition();
            if (((ReactorSensorType)this._setting.Sensor).isInput()) {
                this._externalPowerLevel = this.getRedstonePowerLevelFrom(position.m_142300_(outward), (Direction)outward);
                boolean bl = this._isExternallyPowered = this._externalPowerLevel > 0;
                if (!this._setting.Behavior.onPulse()) {
                    this.onRedstoneInputUpdated();
                }
            } else {
                this._isExternallyPowered = false;
                this._externalPowerLevel = 0;
            }
        });
        this.updateRedstoneStateAndNotify();
    }

    private void disableSensorFromGUI() {
        this._setting = ReactorSensorSetting.DISABLED;
        this.updateRedstoneStateAndNotify();
    }

    private boolean isReceivingRedstonePowerFrom(BlockPos position, Direction direction) {
        return (Boolean)this.mapPartWorld(w -> w.m_46755_(position) > 0 || w.m_46681_(position, direction) > 0, false);
    }

    private int getRedstonePowerLevelFrom(BlockPos position, Direction direction) {
        return (Integer)this.mapPartWorld(w -> Mth.m_14045_((int)w.m_46681_(position, direction), (int)0, (int)15), 0);
    }

    protected boolean updateLitState() {
        this._isLit = ((ReactorSensorType)this.getSettings().Sensor).isOutput() && this.isRedstoneActive() || this._isExternallyPowered;
        return this._isLit;
    }
}

