/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.zerocore.lib.world.OreGenRegisteredFeature;
import it.zerono.mods.zerocore.lib.world.WorldGenManager;
import it.zerono.mods.zerocore.lib.world.WorldReGenHandler;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldGen {
    private static WorldReGenHandler s_regen;

    public static void initialize() {
        s_regen = new WorldReGenHandler("ergen", () -> ((ForgeConfigSpec.IntValue)Config.COMMON.worldgen.userWorldGenVersion).get(), () -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.enableWorldRegeneration.get() != false);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, EventPriority.LOW, WorldGen::register);
    }

    public static void register(RegistryEvent.Register<Feature<?>> event) {
        Pair yelloriteGenerators = WorldReGenHandler.oreVeinWithRegen((String)"yellorite", ExtremeReactors::newID, Content.Blocks.YELLORITE_ORE_BLOCK, (RuleTest)WorldGenManager.oreMatch((TagKey)Tags.Blocks.STONE), (int)((Integer)Config.COMMON.worldgen.yelloriteOrePerCluster.get()), (int)((Integer)Config.COMMON.worldgen.yelloriteOreMaxClustersPerChunk.get()), (int)15, (int)((Integer)Config.COMMON.worldgen.yelloriteOreMaxY.get()));
        Pair anglesiteGenerators = WorldReGenHandler.oreVeinWithRegen((String)"anglesite", ExtremeReactors::newID, Content.Blocks.ANGLESITE_ORE_BLOCK, (RuleTest)WorldGenManager.oreMatch((TagKey)Tags.Blocks.END_STONES), (int)((Integer)Config.COMMON.worldgen.anglesiteOrePerCluster.get()), (int)((Integer)Config.COMMON.worldgen.anglesiteOreMaxClustersPerChunk.get()), (int)5, (int)200);
        Pair benitoiteGenerators = WorldReGenHandler.oreVeinWithRegen((String)"benitoite", ExtremeReactors::newID, Content.Blocks.BENITOITE_ORE_BLOCK, (RuleTest)WorldGenManager.oreMatch((TagKey)Tags.Blocks.NETHERRACK), (int)((Integer)Config.COMMON.worldgen.benitoiteOrePerCluster.get()), (int)((Integer)Config.COMMON.worldgen.benitoiteOreMaxClustersPerChunk.get()), (int)5, (int)256);
        WorldGen.registerToVanilla((Pair<OreGenRegisteredFeature, OreGenRegisteredFeature>)yelloriteGenerators);
        WorldGen.registerToVanilla((Pair<OreGenRegisteredFeature, OreGenRegisteredFeature>)anglesiteGenerators);
        WorldGen.registerToVanilla((Pair<OreGenRegisteredFeature, OreGenRegisteredFeature>)benitoiteGenerators);
        Predicate<BiomeLoadingEvent> yelloriteGenEnabled = e -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.yelloriteOreEnableWorldGen.get() != false;
        Predicate<BiomeLoadingEvent> anglesiteGenEnabled = e -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.anglesiteOreEnableWorldGen.get() != false;
        Predicate<BiomeLoadingEvent> benitoiteGenEnabled = e -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.benitoiteOreEnableWorldGen.get() != false;
        Predicate<Holder> yelloriteReGenEnabled = e -> (Boolean)Config.COMMON.worldgen.yelloriteOreEnableWorldGen.get();
        Predicate<Holder> anglesiteReGenEnabled = e -> (Boolean)Config.COMMON.worldgen.anglesiteOreEnableWorldGen.get();
        Predicate<Holder> benitoiteReGenEnabled = e -> (Boolean)Config.COMMON.worldgen.benitoiteOreEnableWorldGen.get();
        s_regen.addOreVein(yelloriteGenerators, yelloriteGenEnabled, yelloriteReGenEnabled);
        s_regen.addOreVein(anglesiteGenerators, anglesiteGenEnabled, anglesiteReGenEnabled);
        s_regen.addOreVein(benitoiteGenerators, benitoiteGenEnabled, benitoiteReGenEnabled);
    }

    private static void registerToVanilla(Pair<OreGenRegisteredFeature, OreGenRegisteredFeature> features) {
        ((OreGenRegisteredFeature)features.getLeft()).register();
        ((OreGenRegisteredFeature)features.getRight()).register();
    }
}

