/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.datagen.recipes.AbstractRecipeGenerator;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.compat.Mods;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.registries.RegistryObject;

public class ReactorRecipeGenerator
extends AbstractRecipeGenerator {
    public ReactorRecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String m_6055_() {
        return "Extreme Reactors 2 Reactor recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> c) {
        ReactorVariant variant = ReactorVariant.Basic;
        RegistryObject<BlockItem> casing = Content.Items.REACTOR_CASING_BASIC;
        TagKey core = Tags.Items.SAND;
        TagKey metal = Tags.Items.INGOTS_IRON;
        TagKey alternativeMetal = null;
        this.reactorCasing(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_BASIC, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorGlass(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GLASS);
        this.reactorController(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLLER_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.reactorFuelRod(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FUELROD_BASIC, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal, (TagKey<Item>)Tags.Items.GLASS);
        this.reactorControlRod(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLROD_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorSolidAccessPort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_SOLID_ACCESSPORT_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorPowerTap(c, variant, "fe", (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_PASSIVE_BASIC, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42153_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42451_));
        this.reactorRedstonePort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_REDSTONEPORT_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal, (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:reactor", ReactorRecipeGenerator::reactorRecipeName, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CHARGINGPORT_FE_BASIC, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (ItemLike)Items.f_42534_, (ItemLike)Items.f_42451_);
        this.reactorCasingRecycle(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_BASIC, ContentTags.Items.USING_REACTOR_CASING_BASIC, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_BASIC);
        variant = ReactorVariant.Reinforced;
        casing = Content.Items.REACTOR_CASING_REINFORCED;
        core = Tags.Items.STORAGE_BLOCKS_IRON;
        metal = TAG_INGOTS_STEEL;
        alternativeMetal = Tags.Items.STORAGE_BLOCKS_IRON;
        this.reactorCasing(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_REINFORCED, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorCasingUpgrade(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorGlass(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GLASS);
        this.reactorController(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLLER_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.reactorFuelRod(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FUELROD_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal, (TagKey<Item>)Tags.Items.GLASS);
        this.reactorControlRod(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLROD_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorSolidAccessPort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_SOLID_ACCESSPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorFluidAccessPort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUID_ACCESSPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorPowerTap(c, variant, "fe", (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42153_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42451_));
        this.reactorRedstonePort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_REDSTONEPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
        this.reactorComputerPort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_COMPUTERPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.reactorFluidPort(c, variant, "forge", (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUIDPORT_FORGE_ACTIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42448_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42447_));
        this.reactorMekFluidPort(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42448_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42447_));
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:reactor", ReactorRecipeGenerator::reactorRecipeName, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CHARGINGPORT_FE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (ItemLike)Items.f_41854_, (ItemLike)Items.f_42153_);
        this.reactorCasingRecycle(c, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_REINFORCED, ContentTags.Items.USING_REACTOR_CASING_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_REINFORCED);
    }

    private void reactorCasing(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> core, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_206416_(Character.valueOf('C'), core).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_206406_(ContentTags.Items.INGOTS_GRAPHITE)));
    }

    private void reactorCasingUpgrade(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing_upgrade"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing_upgrade_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_126127_(Character.valueOf('C'), (ItemLike)Content.Blocks.REACTOR_CASING_BASIC.get()).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)Content.Blocks.REACTOR_CASING_BASIC.get()))));
    }

    private void reactorCasingRecycle(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> casingResult, TagKey<Item> casingSourceTag, Supplier<? extends ItemLike> glassSourceItem) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)casingResult.get(), (int)1).m_126209_(glassSourceItem.get()).m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)glassSourceItem.get())).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "casing_recycle_glass"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)casingResult.get(), (int)4).m_206419_(casingSourceTag).m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_206406_(casingSourceTag)).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "casing_recycle"));
    }

    private void reactorGlass(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> glass) {
        ShapedRecipeBuilder.m_126116_((ItemLike)result.get()).m_126127_(Character.valueOf('C'), casing.get()).m_206416_(Character.valueOf('G'), glass).m_126130_("GCG").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)casing.get())).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "glass"));
    }

    private void reactorController(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> diamond) {
        TAGS_YELLORIUM_INGOTS.forEach(yellorium -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('Y'), yellorium).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), diamond).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42351_).m_126130_("CXC").m_126130_("YDY").m_126130_("CRC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))).m_142284_("has_item2", (CriterionTriggerInstance)ReactorRecipeGenerator.m_206406_((TagKey)yellorium)).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "controller", (TagKey<Item>)yellorium)));
    }

    private void reactorFuelRod(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal, TagKey<Item> glass) {
        TAGS_YELLORIUM_INGOTS.forEach(yellorium -> ReactorRecipeGenerator.recipeWithAlternativeTag((Consumer)c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "fuelrod", (TagKey<Item>)yellorium), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "fuelrod_alt", (TagKey<Item>)yellorium), (TagKey)metal, (TagKey)alternativeMetal, arg_0 -> ReactorRecipeGenerator.lambda$reactorFuelRod$11((Supplier)result, yellorium, glass, arg_0)));
    }

    private void reactorControlRod(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "controlrod"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "controlrod_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41869_).m_126130_("CRC").m_126130_("MXM").m_126130_("CGC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void reactorPowerTap(Consumer<FinishedRecipe> c, ReactorVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> energyBig, Supplier<? extends ItemLike> energySmall) {
        ShapedRecipeBuilder.m_126116_((ItemLike)passiveResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), energyBig.get()).m_126127_(Character.valueOf('S'), energySmall.get()).m_126130_("CSC").m_126130_("SBS").m_126130_("CSC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)casing.get())).m_142284_("has_item2", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)energySmall.get())).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "passivetap_" + name));
        ShapedRecipeBuilder.m_126116_((ItemLike)activeResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), energyBig.get()).m_126127_(Character.valueOf('S'), energySmall.get()).m_126130_("CBC").m_126130_("BSB").m_126130_("CBC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)casing.get())).m_142284_("has_item2", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)energyBig.get())).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "activetap_" + name));
    }

    private void reactorFluidPort(Consumer<FinishedRecipe> c, ReactorVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        ShapedRecipeBuilder.m_126116_((ItemLike)passiveResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126130_("CSC").m_126130_("SBS").m_126130_("CSC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)casing.get())).m_142284_("has_item2", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)water.get())).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "passivefluidport_" + name));
        ShapedRecipeBuilder.m_126116_((ItemLike)activeResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126130_("CBC").m_126130_("BSB").m_126130_("CBC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)casing.get())).m_142284_("has_item2", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)lava.get())).m_142700_(c, ReactorRecipeGenerator.reactorRecipeName(variant, "activefluidport_" + name));
    }

    private void reactorMekFluidPort(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        ConditionalRecipe.builder().addCondition(ReactorRecipeGenerator.modLoaded((String)Mods.MEKANISM.id())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_((ItemLike)passiveResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42110_).m_126130_("CSC").m_126130_("BXB").m_126130_("CSC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)casing.get())).m_142284_("has_item2", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)water.get()))).m_176498_(arg_0)).build(c, ReactorRecipeGenerator.reactorRecipeName(variant, "passivefluidport_mekanism"));
    }

    private void reactorSolidAccessPort(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "solidaccessport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "solidaccessport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('W'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41869_).m_126130_("CHC").m_126130_("MWM").m_126130_("CXC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void reactorFluidAccessPort(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "fluidaccessport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "fluidaccessport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42155_).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41869_).m_126130_("CHC").m_126130_("MWM").m_126130_("CXC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void reactorRedstonePort(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal, TagKey<Item> gold) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "redstoneport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "redstoneport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('G'), gold).m_126127_(Character.valueOf('Z'), (ItemLike)Items.f_42351_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42350_).m_126130_("CZC").m_126130_("MGM").m_126130_("CXC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void reactorComputerPort(Consumer<FinishedRecipe> c, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "computerport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "computerport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('G'), Tags.Items.STORAGE_BLOCKS_GOLD).m_206416_(Character.valueOf('Z'), Tags.Items.GEMS_LAPIS).m_206416_(Character.valueOf('X'), Tags.Items.DUSTS_GLOWSTONE).m_126130_("CZC").m_126130_("MGM").m_126130_("CXC").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private static ResourceLocation reactorRecipeName(IMultiblockGeneratorVariant variant, String name) {
        return ExtremeReactors.newID("reactor/" + variant.getName() + "/" + name);
    }

    private static ResourceLocation reactorRecipeName(IMultiblockGeneratorVariant variant, String name, TagKey<Item> tag) {
        return ExtremeReactors.newID("reactor/" + variant.getName() + "/" + name + "_" + tag.f_203868_().m_135815_().replace('/', '_'));
    }

    private static /* synthetic */ ShapedRecipeBuilder lambda$reactorFuelRod$11(Supplier result, TagKey yellorium, TagKey glass, TagKey metalTag) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('Y'), yellorium).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_206416_(Character.valueOf('L'), glass).m_126130_("MGM").m_126130_("LYL").m_126130_("MGM").m_142409_("bigreactors:reactor").m_142284_("has_item", (CriterionTriggerInstance)ReactorRecipeGenerator.m_206406_((TagKey)yellorium));
    }
}

