/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.SourceTag;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.tag.TagList;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="bigreactors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ReactantMappingsRegistry {
    public static final int STANDARD_SOLID_REACTANT_AMOUNT = 1000;
    public static final int STANDARD_FLUID_REACTANT_AMOUNT = 1;
    private static final Map<TagKey<Item>, IMapping<TagKey<Item>, Reactant>> s_solidToReactant = Maps.newHashMap();
    private static final Map<TagKey<Fluid>, IMapping<TagKey<Fluid>, Reactant>> s_fluidToReactant = Maps.newHashMap();
    private static final Map<Reactant, List<IMapping<Reactant, TagKey<Item>>>> s_reactantToSolid = Maps.newHashMap();
    private static final Map<Reactant, List<IMapping<Reactant, TagKey<Fluid>>>> s_reactantToFluid = Maps.newHashMap();
    private static final TagList<Item> s_solidTags = TagList.items();
    private static final TagList<Fluid> s_fluidTags = TagList.fluids();
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/ReactantMappingsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});
    private static final Component TOOLTIP_FUEL_SOURCE = new TranslatableComponent("api.bigreactors.reactor.tooltip.reactant.fuel").m_6270_(ExtremeReactorsAPI.STYLE_TOOLTIP);

    public static Optional<IMapping<TagKey<Item>, Reactant>> getFromSolid(ItemStack stack) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        Item item = stack.m_41720_();
        List tags = TagsHelper.ITEMS.getTags((Object)item);
        return s_solidTags.findFirst(tags::contains).map(s_solidToReactant::get);
    }

    public static Optional<IMapping<TagKey<Fluid>, Reactant>> getFromFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Fluid fluid = stack.getFluid();
        List tags = TagsHelper.FLUIDS.getTags((Object)fluid);
        return s_fluidTags.findFirst(tags::contains).map(s_fluidToReactant::get);
    }

    public static Optional<List<IMapping<Reactant, TagKey<Item>>>> getToSolid(Reactant reactant) {
        return Optional.ofNullable(s_reactantToSolid.get(reactant));
    }

    public static Optional<List<IMapping<Reactant, TagKey<Fluid>>>> getToFluid(Reactant reactant) {
        return Optional.ofNullable(s_reactantToFluid.get(reactant));
    }

    public static ItemStack getSolidStackFrom(IMapping<Reactant, TagKey<Item>> mapping, int amount) {
        return s_solidTags.first(mapping.getProduct()).map(item -> ItemHelper.stackFrom((ItemLike)item, (int)amount)).orElse(ItemStack.f_41583_);
    }

    public static FluidStack getFluidStackFrom(IMapping<Reactant, TagKey<Fluid>> mapping, int amount) {
        return s_fluidTags.first(mapping.getProduct()).map(fluid -> new FluidStack(fluid, amount)).orElse(FluidStack.EMPTY);
    }

    public static void registerSolid(String reactantName, int reactantQty, String sourceItemTagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceItemTagId) ? 1 : 0) != 0);
        ReactantMappingsRegistry.registerSolid(reactantName, reactantQty, (TagKey<Item>)TagsHelper.ITEMS.createKey(sourceItemTagId));
    }

    public static void registerSolid(String reactantName, int reactantQty, TagKey<Item> sourceItemTag) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)reactantName) ? 1 : 0) != 0);
        Preconditions.checkNotNull(sourceItemTag);
        InternalDispatcher.dispatch("mapping-register", () -> {
            int qty;
            if (reactantQty < 0) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Using default quantity for reactant {} instead of the provided, invalid, one: {}", (Object)reactantName, (Object)reactantQty);
                qty = 1000;
            } else {
                qty = reactantQty;
            }
            ReactantsRegistry.get(reactantName).ifPresentOrElse(reactant -> {
                IMapping<TagKey, Reactant> mapping = IMapping.of(sourceItemTag, 1, reactant, qty);
                s_solidToReactant.put((TagKey<Item>)mapping.getSource(), mapping);
                s_reactantToSolid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
                s_solidTags.addTag(sourceItemTag);
            }, () -> ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source reactant: {}", (Object)reactantName));
        });
    }

    public static void registerFluid(String reactantName, String sourceFluidTagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceFluidTagId) ? 1 : 0) != 0);
        ReactantMappingsRegistry.registerFluid(reactantName, (TagKey<Fluid>)TagsHelper.FLUIDS.createKey(sourceFluidTagId));
    }

    public static void registerFluid(String reactantName, TagKey<Fluid> sourceFluidTag) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)reactantName) ? 1 : 0) != 0);
        Preconditions.checkNotNull(sourceFluidTag);
        InternalDispatcher.dispatch("mapping-register", () -> ReactantsRegistry.get(reactantName).ifPresentOrElse(reactant -> {
            IMapping<TagKey, Reactant> mapping = IMapping.of(sourceFluidTag, 1, reactant, 1);
            s_fluidToReactant.put((TagKey<Fluid>)mapping.getSource(), mapping);
            s_reactantToFluid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
            s_fluidTags.addTag(sourceFluidTag);
        }, () -> ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source reactant: {}", (Object)reactantName)));
    }

    public static void removeSolid(String sourceItemTagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceItemTagId) ? 1 : 0) != 0);
        ReactantMappingsRegistry.removeSolid((TagKey<Item>)TagsHelper.ITEMS.createKey(sourceItemTagId));
    }

    public static void removeSolid(TagKey<Item> sourceItemTag) {
        Preconditions.checkNotNull(sourceItemTag);
        InternalDispatcher.dispatch("mapping-remove", () -> {
            IMapping<TagKey<Item>, Reactant> removedMapping = s_solidToReactant.remove(sourceItemTag);
            if (null != removedMapping) {
                s_reactantToSolid.getOrDefault(removedMapping.getProduct(), Collections.emptyList()).removeIf(reactantToTagMapping -> ((TagKey)reactantToTagMapping.getProduct()).equals((Object)sourceItemTag));
                s_reactantToSolid.entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(s_reactantToSolid::remove);
                s_solidTags.removeTag(sourceItemTag);
            }
        });
    }

    public static void removeFluid(String sourceFluidTagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceFluidTagId) ? 1 : 0) != 0);
        ReactantMappingsRegistry.removeFluid((TagKey<Fluid>)TagsHelper.FLUIDS.createKey(sourceFluidTagId));
    }

    public static void removeFluid(TagKey<Fluid> sourceFluidTag) {
        Preconditions.checkNotNull(sourceFluidTag);
        InternalDispatcher.dispatch("mapping-remove", () -> {
            IMapping<TagKey<Fluid>, Reactant> removedMapping = s_fluidToReactant.remove(sourceFluidTag);
            if (null != removedMapping) {
                s_reactantToFluid.getOrDefault(removedMapping.getProduct(), Collections.emptyList()).removeIf(reactantToTagMapping -> ((TagKey)reactantToTagMapping.getProduct()).equals((Object)sourceFluidTag));
                s_reactantToFluid.entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(s_reactantToFluid::remove);
                s_fluidTags.removeTag(sourceFluidTag);
            }
        });
    }

    public static void fillReactantsTooltips(Map<Item, Set<Component>> tooltipsMap, NonNullSupplier<Set<Component>> setSupplier) {
        s_solidToReactant.values().stream().filter(mapping -> ((Reactant)mapping.getProduct()).getType().isFuel()).map(IMapping::getSource).forEach(key -> s_solidTags.forEach(key, item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_FUEL_SOURCE)));
        s_fluidToReactant.values().stream().filter(mapping -> ((Reactant)mapping.getProduct()).getType().isFuel()).map(IMapping::getSource).forEach(key -> s_fluidTags.forEach(key, fluid -> tooltipsMap.computeIfAbsent(fluid.m_6859_(), k -> (Set)setSupplier.get()).add(TOOLTIP_FUEL_SOURCE)));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        ReactantMappingsRegistry.processWrapper("solid", wrapper.ReactorReactantSources, () -> {
            s_solidToReactant.clear();
            s_reactantToSolid.clear();
        }, ReactantMappingsRegistry::removeSolid, w -> ReactantMappingsRegistry.registerSolid(w.ProductName, w.ProductQuantity, w.SourceTagId));
    }

    public static Map<Reactant, List<IMapping<Reactant, TagKey<Item>>>> getToSolidMap() {
        return ReactantMappingsRegistry.unmodifiableInverseMap(s_reactantToSolid);
    }

    public static Map<Reactant, List<IMapping<Reactant, TagKey<Fluid>>>> getToFluidMap() {
        return ReactantMappingsRegistry.unmodifiableInverseMap(s_reactantToFluid);
    }

    private ReactantMappingsRegistry() {
    }

    private static <X> void processWrapper(String objectName, AddRemoveSection<SourceTag> wrapperSection, Runnable clearAction, Consumer<String> removeAction, Consumer<SourceTag> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} Reactor Reactant source mappings", (Object)objectName);
            clearAction.run();
        } else {
            Arrays.stream(wrapperSection.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        Arrays.stream((SourceTag[])wrapperSection.Add).filter(Objects::nonNull).forEach(addAction);
    }

    private static <T> Map<Reactant, List<IMapping<Reactant, TagKey<T>>>> unmodifiableInverseMap(Map<Reactant, List<IMapping<Reactant, TagKey<T>>>> map) {
        Object2ObjectArrayMap copy = new Object2ObjectArrayMap(map.size());
        for (Map.Entry<Reactant, List<IMapping<Reactant, TagKey<T>>>> entry : map.entrySet()) {
            copy.put((Object)entry.getKey(), (Object)new ObjectArrayList((Collection)entry.getValue()));
        }
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)copy);
    }
}

