/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractNamedValue {
    private final String _name;
    private final String _translationKey;

    protected AbstractNamedValue(String name, String translationKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)translationKey) ? 1 : 0) != 0);
        for (int i = 0; i < name.length(); ++i) {
            if (ResourceLocation.m_135816_((char)name.charAt(i))) continue;
            throw new IllegalArgumentException("Names should be valid for use in a ResourceLocation");
        }
        this._name = name;
        this._translationKey = translationKey;
    }

    public String getName() {
        return this._name;
    }

    public String getTranslationKey() {
        return this._translationKey;
    }

    public Component getTranslatedName() {
        return new TranslatableComponent(this.getTranslationKey());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractNamedValue) {
            AbstractNamedValue other = (AbstractNamedValue)obj;
            return this == other || this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

