/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.compat.theoneprobe;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.setup.Registration;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;
import org.apache.commons.lang3.text.WordUtils;

public class TOPCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", GetTheOneProbe::new);
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Override
        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            Logging.log("Enabled support for The One Probe");
            probe.registerProvider(new IProbeInfoProvider(){

                public ResourceLocation getID() {
                    return new ResourceLocation("mcjtylib:default");
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
                    TOPInfoProvider provider;
                    TOPDriver driver;
                    if (blockState.m_60734_() instanceof TOPInfoProvider && (driver = (provider = (TOPInfoProvider)blockState.m_60734_()).getProbeDriver()) != null) {
                        driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
                    }
                }
            });
            probe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
                Block block = blockState.m_60734_();
                if (block == Registration.MULTIPART_BLOCK) {
                    String modid = "mcjtylib";
                    ItemStack pickBlock = data.getPickBlock();
                    MultipartTE.Part part = MultipartBlock.getHitPart(blockState, (BlockGetter)world, data.getPos(), MultipartHelper.getPlayerEyes(player), data.getHitVec());
                    if (part != null) {
                        pickBlock = part.getState().m_60734_().m_7397_((BlockGetter)world, data.getPos(), part.getState());
                        modid = Tools.getId(part.getState()).m_135827_();
                    }
                    modid = WordUtils.capitalize((String)modid);
                    if (!pickBlock.m_41619_()) {
                        probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modid));
                    } else {
                        probeInfo.vertical().text(CompoundText.create().name(block.m_7705_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modid));
                    }
                    return true;
                }
                return false;
            });
            return null;
        }
    }
}

