/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.util.JsonHelper;

public class SizedIngredient
implements Predicate<ItemStack> {
    public static final SizedIngredient EMPTY = SizedIngredient.of(Ingredient.f_43901_, 0);
    private final Ingredient ingredient;
    private final int amountNeeded;
    private WeakReference<ItemStack[]> lastIngredientMatch;
    private List<ItemStack> matchingStacks;

    public static SizedIngredient of(Ingredient ingredient) {
        return SizedIngredient.of(ingredient, 1);
    }

    public static SizedIngredient fromItems(int amountNeeded, ItemLike ... items) {
        return SizedIngredient.of(Ingredient.m_43929_((ItemLike[])items), amountNeeded);
    }

    public static SizedIngredient fromItems(ItemLike ... items) {
        return SizedIngredient.fromItems(1, items);
    }

    public static SizedIngredient fromTag(TagKey<Item> tag, int amountNeeded) {
        return SizedIngredient.of(Ingredient.m_204132_(tag), amountNeeded);
    }

    public static SizedIngredient fromTag(TagKey<Item> tag) {
        return SizedIngredient.fromTag(tag, 1);
    }

    @Override
    public boolean test(ItemStack stack) {
        return stack.m_41613_() >= this.amountNeeded && this.ingredient.test(stack);
    }

    public boolean hasNoMatchingStacks() {
        return this.ingredient.m_43947_();
    }

    public List<ItemStack> getMatchingStacks() {
        ItemStack[] ingredientMatch = this.ingredient.m_43908_();
        if (this.matchingStacks == null || this.lastIngredientMatch.get() != ingredientMatch) {
            this.matchingStacks = Arrays.stream(ingredientMatch).map(stack -> {
                if (stack.m_41613_() != this.amountNeeded) {
                    stack = stack.m_41777_();
                    stack.m_41764_(this.amountNeeded);
                }
                return stack;
            }).collect(Collectors.toList());
            this.lastIngredientMatch = new WeakReference<ItemStack[]>(ingredientMatch);
        }
        return this.matchingStacks;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.amountNeeded);
        this.ingredient.m_43923_(buffer);
    }

    public JsonObject serialize() {
        JsonElement ingredient = this.ingredient.m_43942_();
        JsonObject json = null;
        if (ingredient.isJsonObject() && ((json = ingredient.getAsJsonObject()).has("ingredient") || json.has("amount_needed"))) {
            json = null;
        }
        if (json == null) {
            json = new JsonObject();
            json.add("ingredient", ingredient);
        }
        if (this.amountNeeded != 1) {
            json.addProperty("amount_needed", (Number)this.amountNeeded);
        }
        return json;
    }

    public static SizedIngredient read(FriendlyByteBuf buffer) {
        int amountNeeded = buffer.m_130242_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return SizedIngredient.of(ingredient, amountNeeded);
    }

    public static SizedIngredient deserialize(JsonObject json) {
        int amountNeeded = GsonHelper.m_13824_((JsonObject)json, (String)"amount_needed", (int)1);
        Ingredient ingredient = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)JsonHelper.getElement(json, "ingredient")) : Ingredient.m_43917_((JsonElement)json);
        return SizedIngredient.of(ingredient, amountNeeded);
    }

    private SizedIngredient(Ingredient ingredient, int amountNeeded) {
        this.ingredient = ingredient;
        this.amountNeeded = amountNeeded;
    }

    public static SizedIngredient of(Ingredient ingredient, int amountNeeded) {
        return new SizedIngredient(ingredient, amountNeeded);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getAmountNeeded() {
        return this.amountNeeded;
    }
}

