/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network.packet;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.network.packet.OpenNamedBookPacket;

public record ClearBookCachePacket(@Nullable ResourceLocation book) implements IThreadsafePacket
{
    public ClearBookCachePacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean() ? buffer.m_130281_() : null);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        if (this.book != null) {
            buf.writeBoolean(true);
            buf.m_130085_(this.book);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        if (this.book != null) {
            BookData bookData = BookLoader.getBook(this.book);
            if (bookData != null) {
                bookData.reset();
            } else {
                OpenNamedBookPacket.ClientOnly.errorStatus(this.book);
            }
        } else {
            BookLoader.resetAllBooks();
        }
    }
}

