/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.tooltip;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.TagKeySerializer;
import slimeknights.mantle.fluid.tooltip.FluidUnit;
import slimeknights.mantle.fluid.tooltip.FluidUnitList;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;

public class FluidTooltipHandler
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(FluidTooltipHandler.class);
    public static final Component HOLD_SHIFT = Mantle.makeComponent("gui", "fluid.hold_shift").m_130940_(ChatFormatting.GRAY);
    public static final String FOLDER = "mantle/fluid_tooltips";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(FluidIngredient.class, (Object)FluidIngredient.SERIALIZER).registerTypeAdapter(TagKey.class, new TagKeySerializer(Registry.f_122899_)).setPrettyPrinting().disableHtmlEscaping().create();
    public static final ResourceLocation DEFAULT_ID = Mantle.getResource("fallback");
    private static final FluidUnit BUCKET = new FluidUnit(Mantle.makeDescriptionId("gui", "fluid.bucket"), 1000);
    private static final FluidUnit MILLIBUCKET = new FluidUnit(Mantle.makeDescriptionId("gui", "fluid.millibucket"), 1);
    private static final FluidUnitList DEFAULT_LIST = new FluidUnitList(null, Collections.singletonList(BUCKET));
    public static final BiConsumer<Integer, List<Component>> BUCKET_FORMATTER = FluidTooltipHandler::appendBuckets;
    public static final FluidTooltipHandler INSTANCE = new FluidTooltipHandler();
    private FluidUnitList fallback = DEFAULT_LIST;
    private Map<ResourceLocation, FluidUnitList> unitLists = Collections.emptyMap();
    private final Map<Fluid, FluidUnitList> listCache = new HashMap<Fluid, FluidUnitList>();

    public static void init(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)INSTANCE);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TagsUpdatedEvent.class, event -> FluidTooltipHandler.INSTANCE.listCache.clear());
    }

    private FluidTooltipHandler() {
        super(GSON, FOLDER);
    }

    @Nullable
    private static FluidUnitList loadList(ResourceLocation key, JsonElement json) {
        try {
            return (FluidUnitList)GSON.fromJson(json, FluidUnitList.class);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load fluid container transfer info from {}", (Object)key, (Object)e);
            return null;
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager manager, ProfilerFiller profiler) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<ResourceLocation, ResourceLocation> redirects = new HashMap<ResourceLocation, ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : splashList.entrySet()) {
            JsonObject object;
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            if (element.isJsonObject() && (object = element.getAsJsonObject()).has("redirect")) {
                ResourceLocation redirect = JsonHelper.getResourceLocation(object, "redirect");
                redirects.put(key, redirect);
                continue;
            }
            FluidUnitList list = FluidTooltipHandler.loadList(key, element);
            if (list == null) continue;
            builder.put((Object)key, (Object)list);
        }
        ImmutableMap mapBeforeRedirects = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)mapBeforeRedirects);
        for (Map.Entry entry : redirects.entrySet()) {
            ResourceLocation from = (ResourceLocation)entry.getKey();
            ResourceLocation to = (ResourceLocation)entry.getValue();
            FluidUnitList list = (FluidUnitList)mapBeforeRedirects.get(to);
            if (list != null) {
                builder.put((Object)from, (Object)list);
                continue;
            }
            log.error("Invalid fluid tooltip redirect {} as unit list {} does not exist", (Object)from, (Object)to);
        }
        this.unitLists = builder.build();
        this.fallback = this.unitLists.getOrDefault(DEFAULT_ID, DEFAULT_LIST);
        this.listCache.clear();
        log.info("Loaded {} fluid unit lists in {} ms", (Object)this.unitLists.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    private FluidUnitList getUnitList(Fluid fluid) {
        FluidUnitList cached = this.listCache.get(fluid);
        if (cached != null) {
            return cached;
        }
        for (FluidUnitList list : this.unitLists.values()) {
            if (!list.matches(fluid)) continue;
            this.listCache.put(fluid, list);
            return list;
        }
        this.listCache.put(fluid, this.fallback);
        return this.fallback;
    }

    private FluidUnitList getUnitList(ResourceLocation id) {
        return this.unitLists.getOrDefault(id, this.fallback);
    }

    public static List<Component> getFluidTooltip(FluidStack fluid) {
        return FluidTooltipHandler.getFluidTooltip(fluid, fluid.getAmount());
    }

    public static List<Component> getFluidTooltip(FluidStack fluid, int amount) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)fluid.getDisplayName().m_6879_().m_130940_(ChatFormatting.WHITE));
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), amount, tooltip);
        ModList.get().getModContainerById(Objects.requireNonNull(fluid.getFluid().getRegistryName()).m_135827_()).map(container -> container.getModInfo().getDisplayName()).ifPresent(name -> tooltip.add((Component)new TextComponent(name).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
        return tooltip;
    }

    public static void appendMaterial(FluidStack fluid, List<Component> tooltip) {
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), fluid.getAmount(), tooltip);
    }

    public static void appendMaterial(Fluid fluid, int amount, List<Component> tooltip) {
        if (FluidTooltipHandler.appendMaterialNoShift(fluid, amount, tooltip)) {
            FluidTooltipHandler.appendShift(tooltip);
        }
    }

    public static boolean appendMaterialNoShift(Fluid fluid, int original, List<Component> tooltip) {
        if (SafeClientAccess.getTooltipKey() != TooltipKey.SHIFT) {
            int amount = original;
            amount = INSTANCE.getUnitList(fluid).getText(tooltip, amount);
            MILLIBUCKET.getText(tooltip, amount);
            return FluidTooltipHandler.INSTANCE.listCache.get(fluid) != FluidTooltipHandler.INSTANCE.fallback;
        }
        FluidTooltipHandler.appendBuckets(original, tooltip);
        return false;
    }

    public static void appendShift(List<Component> tooltip) {
        if (!SafeClientAccess.getTooltipKey().isShiftOrUnknown()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add(HOLD_SHIFT);
        }
    }

    public static void appendNamedList(ResourceLocation id, int amount, List<Component> tooltip) {
        amount = INSTANCE.getUnitList(id).getText(tooltip, amount);
        FluidTooltipHandler.appendBuckets(amount, tooltip);
    }

    public static void appendBuckets(int amount, List<Component> tooltip) {
        amount = FluidTooltipHandler.INSTANCE.fallback.getText(tooltip, amount);
        MILLIBUCKET.getText(tooltip, amount);
    }
}

