/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.damage;

import java.util.function.Predicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.AndJsonPredicate;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.InvertedJsonPredicate;
import slimeknights.mantle.data.predicate.NestedJsonPredicateLoader;
import slimeknights.mantle.data.predicate.OrJsonPredicate;

public interface DamageSourcePredicate
extends IJsonPredicate<DamageSource> {
    public static final DamageSourcePredicate ANY = DamageSourcePredicate.simple(source -> true);
    public static final GenericLoaderRegistry<IJsonPredicate<DamageSource>> LOADER = new GenericLoaderRegistry<DamageSourcePredicate>(ANY, true);
    public static final InvertedJsonPredicate.Loader<DamageSource> INVERTED = new InvertedJsonPredicate.Loader(LOADER, false);
    public static final NestedJsonPredicateLoader<DamageSource, AndJsonPredicate<DamageSource>> AND = AndJsonPredicate.createLoader(LOADER, INVERTED);
    public static final NestedJsonPredicateLoader<DamageSource, OrJsonPredicate<DamageSource>> OR = OrJsonPredicate.createLoader(LOADER, INVERTED);
    public static final DamageSourcePredicate PROJECTILE = DamageSourcePredicate.simple(DamageSource::m_19360_);
    public static final DamageSourcePredicate EXPLOSION = DamageSourcePredicate.simple(DamageSource::m_19372_);
    public static final DamageSourcePredicate BYPASS_ARMOR = DamageSourcePredicate.simple(DamageSource::m_19376_);
    public static final DamageSourcePredicate DAMAGE_HELMET = DamageSourcePredicate.simple(DamageSource::m_146705_);
    public static final DamageSourcePredicate BYPASS_INVULNERABLE = DamageSourcePredicate.simple(DamageSource::m_19378_);
    public static final DamageSourcePredicate BYPASS_MAGIC = DamageSourcePredicate.simple(DamageSource::m_19379_);
    public static final DamageSourcePredicate FIRE = DamageSourcePredicate.simple(DamageSource::m_19384_);
    public static final DamageSourcePredicate MAGIC = DamageSourcePredicate.simple(DamageSource::m_19387_);
    public static final DamageSourcePredicate FALL = DamageSourcePredicate.simple(DamageSource::m_146707_);
    public static final DamageSourcePredicate CAN_PROTECT = DamageSourcePredicate.simple(source -> !source.m_19379_() && !source.m_19378_());
    public static final DamageSourcePredicate MELEE = DamageSourcePredicate.simple(source -> {
        if (source.m_19360_()) {
            return false;
        }
        if (source.m_7639_() != null) {
            EntityDamageSource entityDamage;
            return source instanceof EntityDamageSource && !(entityDamage = (EntityDamageSource)source).m_19403_();
        }
        return !source.m_19376_() && !source.m_19384_() && !source.m_19387_() && !source.m_19372_();
    });

    @Override
    default public IJsonPredicate<DamageSource> inverted() {
        return INVERTED.create(this);
    }

    public static DamageSourcePredicate simple(final Predicate<DamageSource> predicate) {
        return GenericLoaderRegistry.SingletonLoader.singleton(loader -> new DamageSourcePredicate(){
            final /* synthetic */ GenericLoaderRegistry.IGenericLoader val$loader;
            {
                this.val$loader = iGenericLoader;
            }

            @Override
            public boolean matches(DamageSource source) {
                return predicate.test(source);
            }

            @Override
            public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<DamageSource>> getLoader() {
                return this.val$loader;
            }
        });
    }
}

