/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.loader.NestedLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;

public class InvertedJsonPredicate<I>
implements IJsonPredicate<I> {
    private final Loader<I> loader;
    private final IJsonPredicate<I> base;

    @Override
    public boolean matches(I input) {
        return !this.base.matches(input);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<I>> getLoader() {
        return this.loader;
    }

    @Override
    public IJsonPredicate<I> inverted() {
        return this.base;
    }

    public InvertedJsonPredicate(Loader<I> loader, IJsonPredicate<I> base) {
        this.loader = loader;
        this.base = base;
    }

    public static class Loader<I>
    implements GenericLoaderRegistry.IGenericLoader<InvertedJsonPredicate<I>> {
        private final GenericLoaderRegistry<IJsonPredicate<I>> loader;
        private final boolean allowNested;

        public Loader(GenericLoaderRegistry<IJsonPredicate<I>> loader) {
            this(loader, true);
        }

        public InvertedJsonPredicate<I> create(IJsonPredicate<I> predicate) {
            return new InvertedJsonPredicate<I>(this, predicate);
        }

        @Override
        public InvertedJsonPredicate<I> deserialize(JsonObject json) {
            if (this.allowNested && json.has("predicate")) {
                return this.create(this.loader.getAndDeserialize(json, "predicate"));
            }
            NestedLoader.mapType(json, "inverted_type");
            return this.create(this.loader.deserialize((JsonElement)json));
        }

        @Override
        public InvertedJsonPredicate<I> fromNetwork(FriendlyByteBuf buffer) {
            return this.create(this.loader.fromNetwork(buffer));
        }

        @Override
        public void serialize(InvertedJsonPredicate<I> object, JsonObject json) {
            NestedLoader.serializeInto(json, "inverted_type", this.loader, object.base);
        }

        @Override
        public void toNetwork(InvertedJsonPredicate<I> object, FriendlyByteBuf buffer) {
            this.loader.toNetwork(object.base, buffer);
        }

        public Loader(GenericLoaderRegistry<IJsonPredicate<I>> loader, boolean allowNested) {
            this.loader = loader;
            this.allowNested = allowNested;
        }
    }
}

