/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loader;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;

public record RegistrySetLoader<R extends IForgeRegistryEntry<R>, T extends GenericLoaderRegistry.IHaveLoader<?>>(String key, IForgeRegistry<R> registry, Function<Set<R>, T> constructor, Function<T, Set<R>> getter) implements GenericLoaderRegistry.IGenericLoader<T>
{
    @Override
    public T deserialize(JsonObject json) {
        ImmutableSet set = ImmutableSet.copyOf(JsonHelper.parseList(json, this.key, (element, jsonKey) -> {
            ResourceLocation objectKey = JsonHelper.convertToResourceLocation(element, jsonKey);
            if (this.registry.containsKey(objectKey)) {
                return this.registry.getValue(objectKey);
            }
            throw new JsonSyntaxException("Unknown " + this.key + " '" + objectKey + "'");
        }));
        return (T)((GenericLoaderRegistry.IHaveLoader)this.constructor.apply((Set<R>)set));
    }

    @Override
    public void serialize(T object, JsonObject json) {
        JsonArray array = new JsonArray();
        for (IForgeRegistryEntry entry : this.getter.apply(object)) {
            array.add(Objects.requireNonNull(entry.getRegistryName()).toString());
        }
        json.add(this.key, (JsonElement)array);
    }

    @Override
    public T fromNetwork(FriendlyByteBuf buffer) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            builder.add((Object)buffer.readRegistryIdUnsafe(this.registry));
        }
        return (T)((GenericLoaderRegistry.IHaveLoader)this.constructor.apply((Set<R>)builder.build()));
    }

    @Override
    public void toNetwork(T object, FriendlyByteBuf buffer) {
        Set<R> set = this.getter.apply(object);
        buffer.m_130130_(set.size());
        for (IForgeRegistryEntry entry : set) {
            buffer.writeRegistryIdUnsafe(this.registry, entry);
        }
    }
}

