/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.util.math.base.Axis;

public class VectorUtils {
    public static Vector3d set(Vector3d vec, double value, Axis axis) {
        switch (axis) {
            case X: {
                new Vector3d(value, vec.f_86215_, vec.f_86216_);
                break;
            }
            case Y: {
                new Vector3d(vec.f_86214_, value, vec.f_86216_);
                break;
            }
            case Z: {
                new Vector3d(vec.f_86214_, vec.f_86215_, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vec3 set(Vec3 vec, double value, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> new Vec3(value, vec.f_82480_, vec.f_82481_);
            case Axis.Y -> new Vec3(vec.f_82479_, value, vec.f_82481_);
            case Axis.Z -> new Vec3(vec.f_82479_, vec.f_82480_, value);
        };
    }

    public static void set(BlockPos.MutableBlockPos vec, int value, Axis axis) {
        switch (axis) {
            case X: {
                vec.m_142451_(value);
                break;
            }
            case Y: {
                vec.m_142448_(value);
                break;
            }
            case Z: {
                vec.m_142443_(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static BlockPos set(BlockPos vec, int value, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> new BlockPos(value, vec.m_123342_(), vec.m_123343_());
            case Axis.Y -> new BlockPos(vec.m_123341_(), value, vec.m_123343_());
            case Axis.Z -> new BlockPos(vec.m_123341_(), vec.m_123342_(), value);
        };
    }

    public static double get(Axis axis, Vector3d vec) {
        return VectorUtils.get(axis, vec.f_86214_, vec.f_86215_, vec.f_86216_);
    }

    public static double get(Axis axis, Vec3 vec) {
        return VectorUtils.get(axis, vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public static double get(Direction.Axis axis, Vec3 vec) {
        return VectorUtils.get(axis, vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public static float get(Axis axis, Vector3f vec) {
        return VectorUtils.get(axis, vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
    }

    public static int get(Axis axis, Vec3i vec) {
        return VectorUtils.get(axis, vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public static float get(Axis axis, float x, float y, float z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> x;
            case Axis.Y -> y;
            case Axis.Z -> z;
        };
    }

    public static double get(Axis axis, double x, double y, double z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> x;
            case Axis.Y -> y;
            case Axis.Z -> z;
        };
    }

    public static int get(Axis axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> x;
            case Axis.Y -> y;
            case Axis.Z -> z;
        };
    }

    public static float get(Direction.Axis axis, float x, float y, float z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
    }

    public static double get(Direction.Axis axis, double x, double y, double z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
    }

    public static int get(Direction.Axis axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> x;
            case Direction.Axis.Y -> y;
            case Direction.Axis.Z -> z;
        };
    }

    public static boolean isZero(double number) {
        return number > (double)-1.0E-4f && number < (double)1.0E-4f;
    }

    public static boolean isZero(float number) {
        return number > -1.0E-4f && number < 1.0E-4f;
    }

    public static boolean equals(double number, double number2) {
        return number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }

    public static boolean equals(float number, float number2) {
        return number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }

    public static boolean greaterEquals(float number, float number2) {
        return number > number2 || number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }

    public static boolean smallerEquals(float number, float number2) {
        return number < number2 || number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }

    public static boolean greaterEquals(double number, double number2) {
        return number > number2 || number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }

    public static boolean smallerEquals(double number, double number2) {
        return number < number2 || number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }
}

