/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    public static final NamedHandlerRegistry<GuiCreativeIngredientHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiCreativeIngredientHandler find(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : REGISTRY.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return REGISTRY.getDefault();
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.registerDefault("Default", new GuiCreativeIngredientHandler(){

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector("inv", null, new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
                gui.add((GuiControl)selector);
                gui.add((GuiControl)new GuiLabel("guilabel1"));
                gui.add((GuiControl)new GuiLabel("guilabel2"));
                GuiStateButton damage = new GuiStateButton("damage", 0, new TextListBuilder().add("Damage: Off", "Damage: On"));
                gui.add((GuiControl)damage);
                GuiStateButton nbt = new GuiStateButton("nbt", 0, new TextListBuilder().add("NBT: Off", "NBT: On"));
                gui.add((GuiControl)nbt);
                if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                    selector.setSelectedForce(info.getExample().m_41777_());
                    if (info instanceof CreativeIngredientItemStack) {
                        damage.nextState();
                        if (((CreativeIngredientItemStack)info).needNBT) {
                            nbt.nextState();
                        }
                    }
                }
                this.onChanged(gui, new GuiControlChangedEvent<GuiStackSelector>(selector));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
            }

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                ItemStack stack = ((GuiStackSelector)gui.get("inv")).getSelected();
                if (stack != null) {
                    boolean nbt;
                    boolean damage = ((GuiStateButton)gui.get("damage")).getState() == 1;
                    boolean bl = nbt = ((GuiStateButton)gui.get("nbt")).getState() == 1;
                    if (damage) {
                        return new CreativeIngredientItemStack(stack.m_41777_(), nbt);
                    }
                    if (!(Block.m_49814_((Item)stack.m_41720_()) instanceof AirBlock)) {
                        return new CreativeIngredientBlock(Block.m_49814_((Item)stack.m_41720_()));
                    }
                    return new CreativeIngredientItem(stack.m_41720_());
                }
                return null;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                GuiControl guiControl;
                if (event.control.is("inv") && (guiControl = event.control) instanceof GuiStackSelector) {
                    GuiStackSelector selector = (GuiStackSelector)guiControl;
                    ItemStack stack = selector.getSelected();
                    if (!stack.m_41619_()) {
                        ((GuiLabel)gui.get("guilabel1")).setTitle((Component)new TextComponent("damage: " + stack.m_41773_()));
                        ((GuiLabel)gui.get("guilabel2")).setTitle((Component)new TextComponent("nbt: " + stack.m_41783_()));
                    } else {
                        ((GuiLabel)gui.get("guilabel1")).setTitle((Component)new TextComponent(""));
                        ((GuiLabel)gui.get("guilabel2")).setTitle((Component)new TextComponent(""));
                    }
                }
            }
        });
        REGISTRY.register("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                TagKey tag = (TagKey)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((TagKey<Block>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<TagKey> box = new GuiComboBoxMapped<TagKey>("tag", new TextMapBuilder<TagKey>().addComponents(Registry.f_122824_.m_203613_().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = Registry.f_122824_.m_203431_(x);
                    if (tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0) {
                        builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).m_203662_(0).m_203334_()));
                    }
                    return builder.text(x.f_203868_().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(Registry.f_122824_.m_203613_().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = Registry.f_122824_.m_203431_(x);
                        if (tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0) {
                            builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).m_203662_(0).m_203334_()));
                        }
                        return builder.text(x.f_203868_().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                TagKey tag = (TagKey)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((TagKey<Item>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<TagKey> box = new GuiComboBoxMapped<TagKey>("tag", new TextMapBuilder<TagKey>().addComponents(Registry.f_122827_.m_203613_().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = Registry.f_122827_.m_203431_(x);
                    if (tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0) {
                        builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).m_203662_(0).m_203334_()));
                    }
                    return builder.text(x.f_203868_().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(Registry.f_122827_.m_203613_().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = Registry.f_122827_.m_203431_(x);
                        if (tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0) {
                            builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).m_203662_(0).m_203334_()));
                        }
                        return builder.text(x.f_203868_().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add((GuiControl)new GuiLabel("info").setTitle((Component)new TextComponent("Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }
}

