/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.style;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyleUtils;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.DisplayTexture;
import team.creative.creativecore.common.gui.style.display.DisplayTextureRepeat;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.type.Color;

public class GuiStyle {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Gson GSON = new GsonBuilder().create();
    public static final NamedHandlerRegistry<GuiStyle> REGISTRY = new NamedHandlerRegistry<Object>(null);
    @SerializedName(value="font-color")
    public Color fontColor = new Color(255, 255, 255);
    @SerializedName(value="font-color-highlight")
    public Color fontColorHighlight = new Color(255, 255, 100);
    @SerializedName(value="font-color-disabled")
    public Color fontColorDisabled = new Color(100, 100, 100);
    @SerializedName(value="border-width")
    public int borderWidth = 1;
    @SerializedName(value="border-thick-width")
    public int borderThickWidth = 2;
    public StyleDisplay disabled = new DisplayColor(0.0f, 0.0f, 0.0f, 0.4f);
    public StyleDisplay border = new DisplayColor(0.0f, 0.0f, 0.0f, 1.0f);
    @SerializedName(value="border-thick")
    public StyleDisplay borderThick = new DisplayColor(0.0f, 0.0f, 0.0f, 1.0f);
    public StyleDisplay background = new DisplayColor(0.6f, 0.6f, 0.6f, 1.0f);
    @SerializedName(value="secondary-background")
    public StyleDisplay secondaryBackground = new DisplayColor(0.5f, 0.5f, 0.5f, 1.0f);
    @SerializedName(value="header-background")
    public StyleDisplay headerBackground = new DisplayColor(1.0f, 1.0f, 1.0f, 1.0f);
    public StyleDisplay bar = new DisplayColor(0.1f, 0.1f, 0.1f, 1.0f);
    public StyleDisplay clickable = new DisplayColor(0.4f, 0.4f, 0.4f, 1.0f);
    @SerializedName(value="clickable-highlight")
    public StyleDisplay clickableHighlight = new DisplayColor(0.5f, 0.5f, 0.5f, 1.0f);
    @SerializedName(value="clickable-inactive")
    public StyleDisplay clickableInactive = new DisplayColor(0.25f, 0.25f, 0.25f, 1.0f);
    @SerializedName(value="clickable-inactive-highlight")
    public StyleDisplay clickableInactiveHighlight = new DisplayColor(0.3f, 0.3f, 0.3f, 1.0f);
    public StyleDisplay disabledBackground = new DisplayColor(0.1f, 0.1f, 0.1f, 1.0f);
    public StyleDisplay slot = new DisplayTexture(GuiStyleUtils.GUI_ASSETS, 0, 0);
    @SerializedName(value="transparency-background")
    public StyleDisplay transparencyBackground = new DisplayTextureRepeat(GuiStyleUtils.GUI_ASSETS, 224, 240, 16, 16);

    public static void reload() {
        try {
            Resource resource = mc.m_91098_().m_142591_(GuiStyleUtils.DEFAULT_STYLE_LOCATION);
            try (InputStream input = resource.m_6679_();){
                JsonObject root = JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)).getAsJsonObject();
                NamedHandlerRegistry.clearRegistry(REGISTRY);
                REGISTRY.registerDefault("default", (GuiStyle)GSON.fromJson((JsonElement)root, GuiStyle.class));
            }
        }
        catch (Exception e) {
            CreativeCore.LOGGER.error((Object)e);
            CreativeCore.LOGGER.error("Could not load default style");
            REGISTRY.registerDefault("default", new GuiStyle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GuiStyle getStyle(String name) {
        GuiStyle guiStyle;
        GuiStyle cached = REGISTRY.get(name);
        if (cached != null) {
            return cached;
        }
        Resource resource = mc.m_91098_().m_142591_(new ResourceLocation(name));
        InputStream input = resource.m_6679_();
        try {
            JsonObject root = JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)).getAsJsonObject();
            cached = (GuiStyle)GSON.fromJson((JsonElement)root, GuiStyle.class);
            REGISTRY.register(name, cached);
            guiStyle = cached;
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchElementException e) {
                REGISTRY.register(name, REGISTRY.getDefault());
                return REGISTRY.getDefault();
            }
            catch (Exception e) {
                CreativeCore.LOGGER.error((Object)e);
                CreativeCore.LOGGER.error("Found invalid style " + name);
                return REGISTRY.getDefault();
            }
        }
        input.close();
        return guiStyle;
    }

    public StyleDisplay get(ControlFormatting.ControlStyleBorder border) {
        return switch (border) {
            case ControlFormatting.ControlStyleBorder.BIG -> this.borderThick;
            case ControlFormatting.ControlStyleBorder.SMALL -> this.border;
            default -> StyleDisplay.NONE;
        };
    }

    public StyleDisplay get(ControlFormatting.ControlStyleFace face, boolean mouseOver) {
        return switch (face) {
            case ControlFormatting.ControlStyleFace.BACKGROUND -> this.background;
            case ControlFormatting.ControlStyleFace.BAR -> this.bar;
            case ControlFormatting.ControlStyleFace.CLICKABLE -> {
                if (mouseOver) {
                    yield this.clickableHighlight;
                }
                yield this.clickable;
            }
            case ControlFormatting.ControlStyleFace.CLICKABLE_INACTIVE -> {
                if (mouseOver) {
                    yield this.clickableInactiveHighlight;
                }
                yield this.clickableInactive;
            }
            case ControlFormatting.ControlStyleFace.NESTED_BACKGROUND -> this.secondaryBackground;
            case ControlFormatting.ControlStyleFace.SLOT -> this.slot;
            case ControlFormatting.ControlStyleFace.DISABLED -> this.disabledBackground;
            case ControlFormatting.ControlStyleFace.HEADER_BACKGROUND -> this.headerBackground;
            default -> StyleDisplay.NONE;
        };
    }

    public int getBorder(ControlFormatting.ControlStyleBorder border) {
        return switch (border) {
            case ControlFormatting.ControlStyleBorder.BIG -> this.borderThickWidth;
            case ControlFormatting.ControlStyleBorder.SMALL -> this.borderWidth;
            default -> 0;
        };
    }

    public int getContentOffset(ControlFormatting formatting) {
        return this.getBorder(formatting.border) + formatting.padding;
    }
}

