/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.dialog;

import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobalLayer;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;

public class GuiDialogHandler {
    public static final GuiSyncGlobalLayer<DialogGuiLayer> DIALOG_HANDLER = GuiSyncHolder.GLOBAL.layer("dialog", nbt -> {
        int[] array = nbt.m_128465_("buttons");
        DialogGuiLayer.DialogButton[] buttons = new DialogGuiLayer.DialogButton[array.length];
        for (int i = 0; i < array.length; ++i) {
            buttons[i] = DialogGuiLayer.DialogButton.values()[array[i]];
        }
        return new DialogGuiLayer(nbt.m_128461_("name"), (Component)Component.Serializer.m_130701_((String)nbt.m_128461_("title")), null, buttons);
    });

    public static void init() {
    }

    public static GuiLayer openDialog(IGuiIntegratedParent parent, String name, BiConsumer<DialogGuiLayer, DialogGuiLayer.DialogButton> onClicked, DialogGuiLayer.DialogButton ... buttons) {
        return GuiDialogHandler.openDialog(parent, name, (Component)new TranslatableComponent("dialog." + name), onClicked, buttons);
    }

    public static GuiLayer openDialog(IGuiIntegratedParent parent, String name, Component title, BiConsumer<DialogGuiLayer, DialogGuiLayer.DialogButton> onClicked, DialogGuiLayer.DialogButton ... buttons) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", name);
        nbt.m_128359_("title", Component.Serializer.m_130703_((Component)title));
        int[] array = new int[buttons.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buttons[i].ordinal();
        }
        nbt.m_128385_("buttons", array);
        DialogGuiLayer layer = DIALOG_HANDLER.open(parent, nbt);
        layer.onClicked = onClicked;
        return layer;
    }
}

