/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.parent.GuiTopBottomBox;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.GuiCreativeIngredientHandler;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class FullItemDialogGuiLayer
extends GuiLayer {
    public static List<CreativeIngredient> latest = new ArrayList<CreativeIngredient>();
    public GuiInfoStackButton button;
    public GuiCreativeIngredientHandler handler;

    public FullItemDialogGuiLayer() {
        super("info", 250, 230);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> {
            if (x.control.is("type")) {
                this.init();
            } else {
                this.handler.onChanged(this, (GuiControlChangedEvent)x);
            }
        });
    }

    @Override
    public void create() {
        if (this.button == null) {
            return;
        }
        CreativeIngredient info = this.button.get();
        this.handler = GuiCreativeIngredientHandler.find(info);
        GuiComboBoxMapped<GuiCreativeIngredientHandler> box = (GuiComboBoxMapped<GuiCreativeIngredientHandler>)this.get("type");
        if (box != null) {
            this.handler = (GuiCreativeIngredientHandler)box.getSelected();
        }
        this.clear();
        GuiTopBottomBox topBottom = new GuiTopBottomBox();
        this.add((GuiControl)topBottom);
        box = new GuiComboBoxMapped<GuiCreativeIngredientHandler>("type", new TextMapBuilder().addEntrySet(GuiCreativeIngredientHandler.REGISTRY.entrySet(), x -> new TextComponent((String)x.getKey())));
        box.setExpandableX();
        box.select(this.handler);
        topBottom.addTop(box);
        this.handler.createControls(topBottom.top, info);
        GuiScrollY scroll = (GuiScrollY)new GuiScrollY("latest").setDim(100, 80).setExpandableX();
        for (int i = 0; i < latest.size(); ++i) {
            int id = i;
            scroll.add(new GuiButton("" + i, x -> {
                this.button.set(latest.get(id));
                this.closeTopLayer();
                FullItemDialogGuiLayer.playSound(SoundEvents.f_12490_);
            }).setTitle(GuiInfoStackButton.getLabelText(latest.get(i))).setAlign(Align.CENTER).setExpandableX());
        }
        topBottom.addBottom(scroll);
        GuiLeftRightBox actionBox = new GuiLeftRightBox().addLeft(new GuiButton("cancel", x -> this.closeTopLayer()).setTitle((Component)new TranslatableComponent("gui.cancel"))).addRight(new GuiButton("save", x -> {
            CreativeIngredient parsedInfo = this.handler.parseControls(topBottom.top);
            if (parsedInfo != null) {
                this.button.set(parsedInfo);
                if (!latest.contains(parsedInfo)) {
                    latest.add(0, parsedInfo.copy());
                }
                this.closeTopLayer();
            }
        }).setTitle((Component)new TranslatableComponent("gui.save")));
        topBottom.addBottom(actionBox);
    }
}

