/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class CreativeBakedQuad
extends BakedQuad {
    public static final int STRIDE = DefaultVertexFormat.f_85811_.m_86017_();
    public static final int POSITION = CreativeBakedQuad.findOffset(DefaultVertexFormat.f_85804_);
    public static final int COLOR = CreativeBakedQuad.findOffset(DefaultVertexFormat.f_85805_);
    public static final int UV0 = CreativeBakedQuad.findOffset(DefaultVertexFormat.f_85806_);
    public static final int UV1 = CreativeBakedQuad.findOffset(DefaultVertexFormat.f_85807_);
    public static final int UV2 = CreativeBakedQuad.findOffset(DefaultVertexFormat.f_85808_);
    public static final int NORMAL = CreativeBakedQuad.findOffset(DefaultVertexFormat.f_85809_);
    public final RenderBox cube;

    private static int findOffset(VertexFormatElement element) {
        int index = DefaultVertexFormat.f_85811_.m_86023_().indexOf((Object)element);
        return index < 0 ? -1 : DefaultVertexFormat.f_85811_.getOffset(index) / 4;
    }

    public CreativeBakedQuad(int[] vertices, BakedQuad quad, RenderBox cube, int tintedColor, boolean shouldOverrideColor) {
        this(vertices, quad, cube, tintedColor, shouldOverrideColor, quad.m_111306_());
    }

    public CreativeBakedQuad(int[] vertices, BakedQuad quad, RenderBox cube, int tintedColor, boolean shouldOverrideColor, Direction facing) {
        super(vertices, shouldOverrideColor ? tintedColor : quad.m_111305_(), facing, quad.m_173410_(), quad.m_111307_());
        this.cube = cube;
    }

    public void updateAlpha() {
        int alpha = ColorUtils.alpha(this.cube.color);
        if (alpha == 255) {
            return;
        }
        for (int k = 0; k < 4; ++k) {
            int index = k * STRIDE + COLOR;
            this.m_111303_()[index] = ColorUtils.setAlpha(this.m_111303_()[index], alpha);
        }
    }
}

