/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.client.render.box.QuadGeneratorContext;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBakedBoxModelTranslucent;
import team.creative.creativecore.client.render.model.CreativeBakedModel;
import team.creative.creativecore.client.render.model.CreativeBakedQuad;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.creativecore.common.util.math.base.Facing;

public class CreativeBakedBoxModel
extends CreativeBakedModel {
    public static Minecraft mc = Minecraft.m_91087_();
    private static final ThreadLocal<QuadGeneratorContext> QUAD_CONTEXT = ThreadLocal.withInitial(QuadGeneratorContext::new);
    private final List<BakedModel> both;
    private final CreativeBakedBoxModelTranslucent pairModel;
    public CreativeBlockModel block;
    public ItemOverrides customOverride = new ItemOverrides(){

        public BakedModel m_173464_(BakedModel original, ItemStack stack, ClientLevel level, LivingEntity entity, int p_173469_) {
            CreativeBakedBoxModel.this.renderedStack = stack;
            return super.m_173464_(original, stack, level, entity, p_173469_);
        }
    };

    public static List<BakedQuad> compileBoxes(List<? extends RenderBox> boxes, Facing side, RenderType layer, Random rand, boolean item, List<BakedQuad> baked) {
        if (side == null) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < boxes.size(); ++i) {
            RenderBox box = boxes.get(i);
            if (!box.shouldRenderFace(side)) continue;
            BlockState state = Blocks.f_50016_.m_49966_();
            if (box.state != null) {
                state = box.state;
            }
            BakedModel blockModel = mc.m_91289_().m_110910_(state);
            int defaultColor = -1;
            if (item) {
                defaultColor = mc.getItemColors().m_92676_(new ItemStack((ItemLike)state.m_60734_()), defaultColor);
            }
            QuadGeneratorContext context = QUAD_CONTEXT.get();
            baked.addAll(box.getBakedQuad(context, null, null, box.getOffset(), state, blockModel, side, layer, rand, true, defaultColor));
            context.clear();
        }
        for (BakedQuad quad : baked) {
            if (!(quad instanceof CreativeBakedQuad)) continue;
            CreativeBakedQuad c = (CreativeBakedQuad)quad;
            c.updateAlpha();
        }
        return baked;
    }

    public CreativeBakedBoxModel(ModelResourceLocation location, CreativeItemBoxModel item, CreativeBlockModel block) {
        super(location, item);
        this.block = block;
        this.pairModel = new CreativeBakedBoxModelTranslucent(location, item, block);
        this.both = Arrays.asList(this, this.pairModel);
    }

    CreativeBakedBoxModel(ModelResourceLocation location, CreativeItemBoxModel item, CreativeBlockModel block, boolean outside) {
        super(location, item);
        this.block = block;
        if (outside) {
            this.pairModel = new CreativeBakedBoxModelTranslucent(location, item, block);
            this.both = Arrays.asList(this, this.pairModel);
        } else {
            this.pairModel = null;
            this.both = null;
        }
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        if (this.block != null) {
            return this.block.getModelData(level, pos, state, modelData);
        }
        return modelData;
    }

    public boolean translucent() {
        return false;
    }

    @Override
    @Deprecated
    public List<BakedQuad> m_6840_(BlockState state, Direction direction, Random rand) {
        return this.get().m_6840_(state, direction, rand);
    }
}

