/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.backport;

import com.mojang.serialization.DataResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final Pattern COPY_COUNTER_PATTERN = Pattern.compile("(<name>.*) \\((<count>\\d*)\\)", 66);
    private static final Pattern RESERVED_WINDOWS_FILENAMES = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    private static final Pattern STRICT_PATH_SEGMENT_CHECK = Pattern.compile("[-._a-z0-9]+");

    public static String findAvailableName(Path pDirPath, String pFileName, String pFileFormat) throws IOException {
        for (char c0 : SharedConstants.f_136184_) {
            pFileName = ((String)pFileName).replace(c0, '_');
        }
        if (RESERVED_WINDOWS_FILENAMES.matcher((CharSequence)(pFileName = ((String)pFileName).replaceAll("[./\"]", "_"))).matches()) {
            pFileName = "_" + (String)pFileName + "_";
        }
        Matcher matcher = COPY_COUNTER_PATTERN.matcher((CharSequence)pFileName);
        int j = 0;
        if (matcher.matches()) {
            pFileName = matcher.group("name");
            j = Integer.parseInt(matcher.group("count"));
        }
        if (((String)pFileName).length() > 255 - pFileFormat.length()) {
            pFileName = ((String)pFileName).substring(0, 255 - pFileFormat.length());
        }
        while (true) {
            Object s = pFileName;
            if (j != 0) {
                String s1 = " (" + j + ")";
                int i = 255 - s1.length();
                if (((String)pFileName).length() > i) {
                    s = ((String)pFileName).substring(0, i);
                }
                s = (String)s + s1;
            }
            s = (String)s + pFileFormat;
            Path path = pDirPath.resolve((String)s);
            try {
                Path path1 = Files.createDirectory(path, new FileAttribute[0]);
                Files.deleteIfExists(path1);
                return pDirPath.relativize(path1).toString();
            }
            catch (FileAlreadyExistsException filealreadyexistsexception) {
                ++j;
                continue;
            }
            break;
        }
    }

    public static boolean isPathNormalized(Path pPath) {
        Path path = pPath.normalize();
        return path.equals(pPath);
    }

    public static boolean isPathPortable(Path pPath) {
        for (Path path : pPath) {
            if (!RESERVED_WINDOWS_FILENAMES.matcher(path.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public static Path createPathToResource(Path pDirPath, String pLocationPath, String pFileFormat) {
        String s = pLocationPath + pFileFormat;
        Path path = Paths.get(s, new String[0]);
        if (path.endsWith(pFileFormat)) {
            throw new InvalidPathException(s, "empty resource name");
        }
        return pDirPath.resolve(path);
    }

    public static String getFullResourcePath(String pPath) {
        return FilenameUtils.getFullPath((String)pPath).replace(File.separator, "/");
    }

    public static String normalizeResourcePath(String pPath) {
        return FilenameUtils.normalize((String)pPath).replace(File.separator, "/");
    }

    public static DataResult<List<String>> decomposePath(String pPath) {
        int i = pPath.indexOf(47);
        if (i == -1) {
            return switch (pPath) {
                case "", ".", ".." -> DataResult.error((String)("Invalid path '" + pPath + "'"));
                default -> !FileUtil.isValidStrictPathSegment(pPath) ? DataResult.error((String)("Invalid path '" + pPath + "'")) : DataResult.success(List.of(pPath));
            };
        }
        ArrayList<String> list = new ArrayList<String>();
        int j = 0;
        boolean flag = false;
        while (true) {
            String s = pPath.substring(j, i);
            switch (pPath.substring(j, i)) {
                case "": 
                case ".": 
                case "..": {
                    return DataResult.error((String)("Invalid segment '" + s + "' in path '" + pPath + "'"));
                }
            }
            if (!FileUtil.isValidStrictPathSegment(s)) {
                return DataResult.error((String)("Invalid segment '" + s + "' in path '" + pPath + "'"));
            }
            list.add(s);
            if (flag) {
                return DataResult.success(list);
            }
            j = i + 1;
            if ((i = pPath.indexOf(47, j)) != -1) continue;
            i = pPath.length();
            flag = true;
        }
    }

    public static Path resolvePath(Path pPath, List<String> p_251495_) {
        int i = p_251495_.size();
        return switch (i) {
            case 0 -> pPath;
            case 1 -> pPath.resolve(p_251495_.get(0));
            default -> {
                String[] astring = new String[i - 1];
                for (int j = 1; j < i; ++j) {
                    astring[j - 1] = p_251495_.get(j);
                }
                yield pPath.resolve(pPath.getFileSystem().getPath(p_251495_.get(0), astring));
            }
        };
    }

    public static boolean isValidStrictPathSegment(String p_249814_) {
        return STRICT_PATH_SEGMENT_CHECK.matcher(p_249814_).matches();
    }

    public static void validatePath(String ... pElements) {
        if (pElements.length == 0) {
            throw new IllegalArgumentException("Path must have at least one element");
        }
        for (String s : pElements) {
            if (!s.equals("..") && !s.equals(".") && FileUtil.isValidStrictPathSegment(s)) continue;
            throw new IllegalArgumentException("Illegal segment " + s + " in path " + Arrays.toString(pElements));
        }
    }

    public static void createDirectoriesSafe(Path pPath) throws IOException {
        Files.createDirectories(Files.exists(pPath, new LinkOption[0]) ? pPath.toRealPath(new LinkOption[0]) : pPath, new FileAttribute[0]);
    }
}

