/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore.particle;

import com.eruannie_9.extragore.ModConfiguration;
import com.eruannie_9.extragore.util.EntityUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BloodParticle
extends TextureSheetParticle {
    private final float yOffsetStandard;
    private final float sizeScalingFactor;
    private boolean stoppedByCollision;
    private final float yOffsetStuck;
    private float decayFactor = 1.0f;
    private final Quaternion onGroundQuaternion;
    private final EntityUtil.CollisionMode controlMode;
    private final EntityUtil.WeightMode weightMode;
    private final EntityUtil.StateMode stateMode;
    private int fadeStartTime;
    private int timeInWater = 0;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);

    public BloodParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, float sizeScalingFactor, Color color, EntityUtil.CollisionMode controlMode, EntityUtil.WeightMode weightMode, EntityUtil.StateMode stateMode) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        float randomRatio = this.f_107223_.nextFloat();
        this.f_107215_ = xSpeed + (this.f_107223_.nextDouble() * 0.1 - 0.05);
        this.f_107216_ = ySpeed * 0.5 + (this.f_107223_.nextDouble() * 0.1 - 0.05);
        this.f_107217_ = zSpeed + (this.f_107223_.nextDouble() * 0.1 - 0.05);
        this.sizeScalingFactor = sizeScalingFactor;
        this.f_107225_ = (int)Mth.m_14179_((float)randomRatio, (float)((Integer)ModConfiguration.MIN_AGE.get()).intValue(), (float)((Integer)ModConfiguration.MAX_AGE.get()).intValue());
        this.f_107224_ = (int)((float)this.f_107225_ * Mth.m_14179_((float)randomRatio, (float)0.0f, (float)0.5f));
        this.fadeStartTime = (int)((double)(this.f_107225_ * 3) / 4.0);
        this.yOffsetStandard = Mth.m_14179_((float)randomRatio, (float)0.001f, (float)0.005f);
        this.yOffsetStuck = Mth.m_14179_((float)randomRatio, (float)0.13f, (float)0.16f);
        this.onGroundQuaternion = Vector3f.f_122223_.m_122270_(1.5707964f);
        this.onGroundQuaternion.m_80148_(Vector3f.f_122227_.m_122270_((float)this.f_107223_.nextInt(4) * 1.5707964f));
        this.f_107230_ = 1.0f;
        this.controlMode = controlMode;
        this.weightMode = weightMode;
        this.stateMode = stateMode;
        Color color1 = color != null ? color : new Color(255, 0, 0);
        this.f_107227_ = (float)color1.getRed() / 255.0f;
        this.f_107228_ = (float)color1.getGreen() / 255.0f;
        this.f_107229_ = (float)color1.getBlue() / 255.0f;
        this.m_108335_(spriteSet);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.controlMode == EntityUtil.CollisionMode.MAGIC) {
            this.handleMagic(this.f_107215_, this.f_107216_, this.f_107217_);
        } else if (this.isInWater()) {
            this.handleWaterMovement();
        } else {
            this.handleAirMovement();
        }
        if (this.f_107224_ >= this.fadeStartTime) {
            float remainingLifespan = this.f_107225_ - this.f_107224_;
            this.f_107230_ = Math.max(remainingLifespan * (1.0f / (float)(this.f_107225_ - this.fadeStartTime)), 0.0f);
        }
        if (++this.f_107224_ >= this.f_107225_ || this.f_107230_ <= 0.0f) {
            this.m_107274_();
        }
    }

    private void handleWaterMovement() {
        BlockPos particlePos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        FluidState fluidState = this.f_107208_.m_6425_(particlePos);
        boolean onWaterSurface = this.isOnWaterSurface();
        this.f_107218_ = false;
        if (!onWaterSurface) {
            this.timeInWater = 0;
            if (this.weightMode == EntityUtil.WeightMode.HEAVY) {
                this.f_107216_ -= 0.005;
            } else {
                if (this.f_107216_ < 0.05) {
                    this.f_107216_ += 0.005;
                }
                Vec3 flowDirection = fluidState.m_76179_((BlockGetter)this.f_107208_, particlePos);
                this.f_107215_ += flowDirection.f_82479_ * 0.05 + ((double)this.f_107223_.nextFloat() - 0.5) * 0.02;
                this.f_107217_ += flowDirection.f_82481_ * 0.05 + ((double)this.f_107223_.nextFloat() - 0.5) * 0.02;
            }
            this.f_107215_ *= 0.5;
            this.f_107217_ *= 0.5;
        } else {
            ++this.timeInWater;
            this.f_107216_ = 0.0;
            Vec3 flowDirection = fluidState.m_76179_((BlockGetter)this.f_107208_, particlePos);
            this.f_107215_ += flowDirection.f_82479_ * 0.1 + ((double)this.f_107223_.nextFloat() - 0.5) * 0.1;
            this.f_107217_ += flowDirection.f_82481_ * 0.1 + ((double)this.f_107223_.nextFloat() - 0.5) * 0.1;
            float motionReducer = 0.5f / (1.0f + 0.1f * (float)this.timeInWater);
            this.f_107215_ *= (double)motionReducer;
            this.f_107217_ *= (double)motionReducer;
            if (this.fadeStartTime > (int)((double)(this.f_107225_ * 2) / 3.0)) {
                this.fadeStartTime = Math.min((int)((double)this.f_107225_ / 10.0), this.f_107225_ - this.timeInWater * 5);
            }
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    private void handleMagic(double xMove, double yMove, double zMove) {
        if (this.f_107223_.nextBoolean()) {
            int fSteps = 10;
            double fX = xMove;
            double fY = yMove;
            double fZ = zMove;
            for (int i = 0; i < fSteps; ++i) {
                fX += this.f_107215_ * Math.pow(0.98, i);
                fZ += this.f_107217_ * Math.pow(0.98, i);
                fY += this.f_107216_ * Math.pow(0.96, i);
            }
            this.f_107212_ = fX;
            this.f_107214_ = fZ;
            this.f_107213_ = fY;
            return;
        }
        this.decayFactor = (float)((double)this.decayFactor * 0.97);
        this.f_107215_ += ((double)this.f_107223_.nextFloat() - 0.5) * 0.02 * (double)this.decayFactor;
        this.f_107217_ += ((double)this.f_107223_.nextFloat() - 0.5) * 0.02 * (double)this.decayFactor;
        this.f_107216_ += 0.0035 * (double)this.decayFactor;
        this.f_107215_ *= 0.98;
        this.f_107217_ *= 0.98;
        this.f_107216_ *= 0.96;
        double[] moveVector = new double[]{xMove + this.f_107215_, yMove + this.f_107216_, zMove + this.f_107217_};
        this.processPhysicsAndMove(moveVector);
        this.m_6257_(moveVector[0], moveVector[1], moveVector[2]);
    }

    private void handleAirMovement() {
        this.f_107215_ *= this.f_107218_ ? 0.5 : 0.95;
        this.f_107216_ -= this.f_107218_ ? 0.0 : 0.0375;
        this.f_107217_ *= this.f_107218_ ? 0.5 : 0.95;
        if (this.f_107224_ > 150) {
            this.stoppedByCollision = false;
            this.f_107216_ -= 0.04;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public void m_6257_(double xMove, double yMove, double zMove) {
        if (!this.stoppedByCollision) {
            switch (this.controlMode) {
                case BOUNCE: {
                    this.handledBounce(xMove, yMove, zMove);
                    break;
                }
                case STUCK: {
                    this.handleCollision(xMove, yMove, zMove);
                    break;
                }
                case NONE: {
                    this.handledNone(xMove, yMove, zMove);
                }
            }
        }
    }

    private void processPhysicsAndMove(double[] moveVector) {
        if (this.f_107219_ && (moveVector[0] != 0.0 || moveVector[1] != 0.0 || moveVector[2] != 0.0) && moveVector[0] * moveVector[0] + moveVector[1] * moveVector[1] + moveVector[2] * moveVector[2] < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 collisionResponse = Entity.m_198894_(null, (Vec3)new Vec3(moveVector[0], moveVector[1], moveVector[2]), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            moveVector[0] = collisionResponse.f_82479_;
            moveVector[1] = collisionResponse.f_82480_;
            moveVector[2] = collisionResponse.f_82481_;
        }
        if (moveVector[0] != 0.0 || moveVector[1] != 0.0 || moveVector[2] != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(moveVector[0], moveVector[1], moveVector[2]));
            this.m_107275_();
        }
    }

    private void handleCollision(double xMove, double yMove, double zMove) {
        double[] moveVector = new double[]{xMove, yMove, zMove};
        double originalX = xMove;
        double originalY = yMove;
        double originalZ = zMove;
        this.processPhysicsAndMove(moveVector);
        xMove = moveVector[0];
        yMove = moveVector[1];
        zMove = moveVector[2];
        if (!this.isInWater()) {
            this.stoppedByCollision = originalX != xMove && originalX != 0.0 || originalZ != zMove && originalZ != 0.0 || Math.abs(originalY) >= (double)1.0E-5f && Math.abs(yMove) < (double)1.0E-5f;
        }
        this.updateStatePostMove(originalX, xMove, originalY, yMove, originalZ, zMove);
    }

    private void handledBounce(double xMove, double yMove, double zMove) {
        double[] moveVector = new double[]{xMove, yMove, zMove};
        double originalX = xMove;
        double originalY = yMove;
        double originalZ = zMove;
        this.processPhysicsAndMove(moveVector);
        xMove = moveVector[0];
        yMove = moveVector[1];
        zMove = moveVector[2];
        if (!this.isInWater()) {
            if (originalX != xMove) {
                this.f_107215_ = -this.f_107215_ * 0.5;
            }
            if (originalZ != zMove) {
                this.f_107217_ = -this.f_107217_ * 0.5;
            }
            if (Math.abs(originalY) >= (double)1.0E-5f && Math.abs(yMove) < (double)1.0E-5f) {
                this.f_107216_ = -this.f_107216_ * 0.5;
            }
        }
        this.updateStatePostMove(originalX, xMove, originalY, yMove, originalZ, zMove);
    }

    private void handledNone(double xMove, double yMove, double zMove) {
        double[] moveVector = new double[]{xMove, yMove, zMove};
        double originalX = xMove;
        double originalY = yMove;
        double originalZ = zMove;
        this.processPhysicsAndMove(moveVector);
        xMove = moveVector[0];
        yMove = moveVector[1];
        zMove = moveVector[2];
        if (originalX != xMove) {
            this.f_107215_ = -this.f_107215_ * 0.5;
        }
        if (originalZ != zMove) {
            this.f_107217_ = -this.f_107217_ * 0.5;
        }
        if (Math.abs(originalY) >= (double)1.0E-5f && Math.abs(yMove) < (double)1.0E-5f && !this.f_107218_) {
            this.f_107216_ = -this.f_107216_ * 0.5;
        }
        this.updateStatePostMove(originalX, xMove, originalY, yMove, originalZ, zMove);
    }

    private void updateStatePostMove(double originalX, double xMove, double originalY, double yMove, double originalZ, double zMove) {
        boolean bl = this.f_107218_ = originalY != yMove && originalY < 0.0;
        if (originalX != xMove) {
            this.f_107215_ = 0.0;
        }
        if (originalZ != zMove) {
            this.f_107217_ = 0.0;
        }
    }

    public void m_5744_(@NotNull VertexConsumer consumer, Camera camera, float partialTick) {
        Quaternion rotation;
        Vec3 cameraPos = camera.m_90583_();
        float interpolatedX = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float interpolatedY = this.getY((float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_()));
        float interpolatedZ = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        if (this.f_107231_ == 0.0f) {
            rotation = new Quaternion(camera.m_90591_());
        } else {
            rotation = new Quaternion(camera.m_90591_());
            Quaternion rollRotation = Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_));
            rotation.m_80148_(rollRotation);
        }
        rotation = this.getQuaternion(rotation);
        Vector3f[] corners = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTick);
        if (this.stoppedByCollision && !this.f_107218_) {
            corners[0].m_122245_(corners[0].m_122239_(), -2.0f, corners[0].m_122269_());
            corners[3].m_122245_(corners[3].m_122239_(), -2.0f, corners[3].m_122269_());
            float deformation = (float)((Double)ModConfiguration.VIBRATION.get()).doubleValue();
            Vector3f[] vector3fArray = corners;
            int n = vector3fArray.length;
            for (int i = 0; i < n; ++i) {
                Vector3f corner = vector3fArray[i];
                corner.m_122261_((float)(1.0 + (Math.random() - 0.5) * (double)deformation));
            }
        }
        for (Vector3f corner : corners) {
            corner.m_122251_(rotation);
            corner.m_122261_(size);
            corner.m_122272_(interpolatedX, interpolatedY, interpolatedZ);
        }
        float uStart = this.m_5970_();
        float uEnd = this.m_5952_();
        float vStart = this.m_5951_();
        float vEnd = this.m_5950_();
        int lightLevel = this.m_6355_(partialTick);
        consumer.m_5483_((double)corners[0].m_122239_(), (double)corners[0].m_122260_(), (double)corners[0].m_122269_()).m_7421_(uEnd, vEnd).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightLevel).m_5752_();
        consumer.m_5483_((double)corners[1].m_122239_(), (double)corners[1].m_122260_(), (double)corners[1].m_122269_()).m_7421_(uEnd, vStart).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightLevel).m_5752_();
        consumer.m_5483_((double)corners[2].m_122239_(), (double)corners[2].m_122260_(), (double)corners[2].m_122269_()).m_7421_(uStart, vStart).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightLevel).m_5752_();
        consumer.m_5483_((double)corners[3].m_122239_(), (double)corners[3].m_122260_(), (double)corners[3].m_122269_()).m_7421_(uStart, vEnd).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightLevel).m_5752_();
    }

    public float m_5902_(float scaleFactor) {
        if (this.stateMode == EntityUtil.StateMode.SOLID) {
            return this.f_107663_ * 0.8f;
        }
        float baseSize = this.f_107663_ * ((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_ * this.sizeScalingFactor;
        if (this.stoppedByCollision && !this.f_107218_) {
            return baseSize * 0.8f;
        }
        if (this.isOnWaterSurface()) {
            float dynamicScale = 1.0f + 1.2f * ((float)this.f_107224_ / (float)this.f_107225_);
            return baseSize * 0.8f * dynamicScale;
        }
        return baseSize;
    }

    public Quaternion getQuaternion(Quaternion originalQuaternion) {
        return this.f_107218_ || this.isOnWaterSurface() ? this.onGroundQuaternion : originalQuaternion;
    }

    public float getY(float y) {
        if (this.stoppedByCollision && !this.f_107218_) {
            return y + this.yOffsetStuck;
        }
        return y + this.yOffsetStandard;
    }

    private boolean isOnWaterSurface() {
        if (this.weightMode == EntityUtil.WeightMode.HEAVY) {
            return false;
        }
        BlockPos particlePos = new BlockPos(this.f_107212_, this.f_107213_ - 0.9, this.f_107214_);
        BlockPos abovePos = particlePos.m_7494_();
        boolean isStillWaterBelow = this.f_107208_.m_6425_(particlePos).m_205070_(FluidTags.f_13131_) && !this.f_107208_.m_6425_(particlePos).m_192917_((Fluid)Fluids.f_76192_);
        boolean isWaterAbove = this.f_107208_.m_6425_(abovePos).m_205070_(FluidTags.f_13131_);
        return isStillWaterBelow && !isWaterAbove;
    }

    private boolean isInWater() {
        return this.f_107208_.m_6425_(new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_)).m_205070_(FluidTags.f_13131_);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }
}

